"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const data_azurerm_client_config_1 = require("@cdktf/provider-azurerm/lib/data-azurerm-client-config");
const log_analytics_workspace_1 = require("@cdktf/provider-azurerm/lib/log-analytics-workspace");
const provider_1 = require("@cdktf/provider-azurerm/lib/provider");
const resource_group_1 = require("@cdktf/provider-azurerm/lib/resource-group");
const cdktf_1 = require("cdktf");
const acr = require("..");
const testing_1 = require("../../testing");
const randomName_1 = require("../../util/randomName");
require("cdktf/lib/testing/adapters/jest");
describe("Example of deploying a Container Registry", () => {
    let stack;
    let fullSynthResult;
    const streamOutput = process.env.STREAM_OUTPUT !== "false";
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "test");
        const randomName = (0, randomName_1.generateRandomName)(12);
        const clientConfig = new data_azurerm_client_config_1.DataAzurermClientConfig(stack, "CurrentClientConfig", {});
        new provider_1.AzurermProvider(stack, "azureFeature", { features: {} });
        const resourceGroup = new resource_group_1.ResourceGroup(stack, "rg", {
            name: `rg-${randomName}`,
            location: "eastus",
        });
        const logAnalyticsWorkspace = new log_analytics_workspace_1.LogAnalyticsWorkspace(stack, "log_analytics", {
            location: "eastus",
            name: `la-${randomName}`,
            resourceGroupName: resourceGroup.name,
        });
        const azureContainerRegistry = new acr.Registry(stack, "testACR", {
            name: `acr${randomName}`,
            location: resourceGroup.location,
            resourceGroup: resourceGroup,
            sku: "Premium",
            adminEnabled: false,
            geoReplicationLocations: [{ location: "westus" }],
            tags: {
                environment: "test",
            },
        });
        //Diag Settings
        azureContainerRegistry.addDiagSettings({
            name: "diagsettings",
            logAnalyticsWorkspaceId: logAnalyticsWorkspace.id,
            metric: [
                {
                    category: "AllMetrics",
                },
            ],
        });
        //RBAC
        azureContainerRegistry.addAccess(clientConfig.objectId, "Contributor");
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    afterEach(() => {
        try {
            (0, testing_1.TerraformDestroy)(fullSynthResult, streamOutput);
        }
        catch (error) {
            console.error("Error during Terraform destroy:", error);
        }
    });
    it("check if stack can be deployed", () => {
        (0, testing_1.TerraformApplyAndCheckIdempotency)(fullSynthResult, streamOutput); // Set to true to stream output
    });
});
//# sourceMappingURL=data:application/json;base64,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