"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataLakePath = void 0;
const storage_data_lake_gen2_path_1 = require("@cdktf/provider-azurerm/lib/storage-data-lake-gen2-path");
const constructs_1 = require("constructs");
class DataLakePath extends constructs_1.Construct {
    /**
     * Manages a specific path within an Azure Data Lake Storage Gen2 filesystem.
     *
     * This class provides functionality to configure and manage a data path within a Data Lake Gen2 filesystem,
     * such as directories and files, with access control settings. It is used to create and manage the structure
     * and security settings of data stored in Azure Data Lake Storage Gen2.
     *
     * @param scope - The scope in which to define this construct, typically representing the Cloud Development Kit (CDK) stack.
     * @param id - The unique identifier for this instance of the Data Lake path. Typically, this is the name of the path.
     * @param props - Configuration properties for the Data Lake Gen2 path. These properties may include:
     *                - `filesystemName`: The name of the filesystem within which this path is defined.
     *                - `path`: The specific path within the filesystem. This could represent a file or a directory.
     *                - `storageAccountId`: The ID of the Azure Storage account that hosts the filesystem.
     *                - `ace`: An array of access control expressions to define permissions for the path.
     *                - `owner`: The owner of the path for access control purposes.
     *                - `group`: The owning group for the path for access control purposes.
     *                - `resource`: Type of the resource, typically a file or directory.
     *
     * Example usage:
     * ```typescript
     * const dataLakePath = new DataLakePath(this, 'myDataPath', {
     *   filesystemName: 'myfilesystem',
     *   path: 'path/to/directory',
     *   storageAccountId: 'storage_account_id',
     *   owner: 'owner_id',
     *   group: 'group_id',
     *   ace: [{
     *     id: 'user_id',
     *     type: 'user',
     *     permissions: 'rwx',
     *   }],
     *   resource: 'directory'
     * });
     * ```
     * This setup creates and manages a directory or a file path within a specified Data Lake Gen2 filesystem,
     * applying the necessary permissions and access controls as configured.
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.name = id;
        this.filesystem = new storage_data_lake_gen2_path_1.StorageDataLakeGen2Path(this, "path", props);
    }
}
exports.DataLakePath = DataLakePath;
//# sourceMappingURL=data:application/json;base64,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