"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const provider_1 = require("@cdktf/provider-azurerm/lib/provider");
const cdktf_1 = require("cdktf");
const storage = require("..");
const testing_1 = require("../../testing");
require("cdktf/lib/testing/adapters/jest");
describe("Azure Datalake With Defaults", () => {
    let stack;
    let fullSynthResult;
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "test");
        new provider_1.AzurermProvider(stack, "azureFeature", { features: {} });
        // Create a Storage Account with the defined rules
        new storage.DataLake(stack, "storageaccount", {
            name: "test42348808",
            location: "eastus",
        });
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    it("renders an Azure Storage Account with defaults and checks snapshot", () => {
        expect(cdktf_1.Testing.synth(stack)).toMatchSnapshot(); // Compare the already prepared stack
    });
    it("check if the produced terraform configuration is valid", () => {
        expect(fullSynthResult).toBeValidTerraform(); // Use the saved result
    });
    it("check if this can be planned", () => {
        (0, testing_1.TerraformPlan)(fullSynthResult); // Use the saved result
    });
});
//# sourceMappingURL=data:application/json;base64,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