"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const data_azurerm_client_config_1 = require("@cdktf/provider-azurerm/lib/data-azurerm-client-config");
const provider_1 = require("@cdktf/provider-azurerm/lib/provider");
const resource_group_1 = require("@cdktf/provider-azurerm/lib/resource-group");
const cdktf_1 = require("cdktf");
const storage = require("..");
const testing_1 = require("../../testing");
const randomName_1 = require("../../util/randomName");
require("cdktf/lib/testing/adapters/jest");
describe("Example of deploying Datalake", () => {
    let stack;
    let fullSynthResult;
    const streamOutput = process.env.STREAM_OUTPUT !== "false";
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "test");
        const randomName = (0, randomName_1.generateRandomName)(12);
        const clientConfig = new data_azurerm_client_config_1.DataAzurermClientConfig(stack, "CurrentClientConfig", {});
        new provider_1.AzurermProvider(stack, "azureFeature", {
            features: {},
            storageUseAzuread: true,
        });
        // Create a resource group
        const resourceGroup = new resource_group_1.ResourceGroup(stack, "rg", {
            name: `rg-${randomName}`,
            location: "eastus",
        });
        const storageAccount = new storage.DataLake(stack, "storageaccount", {
            name: `sta${randomName}8898`,
            resourceGroup: resourceGroup,
            location: "eastus",
            accountReplicationType: "LRS",
            accountTier: "Standard",
            enableHttpsTrafficOnly: true,
            accessTier: "Hot",
            isHnsEnabled: true,
            minTlsVersion: "TLS1_2",
            publicNetworkAccessEnabled: true,
        });
        //RBAC
        storageAccount.addAccess(clientConfig.objectId, "Storage Blob Data Contributor");
        storageAccount.addAccess(clientConfig.objectId, "Storage Queue Data Contributor");
        storageAccount.addAccess(clientConfig.objectId, "Storage Table Data Contributor");
        storageAccount.addAccess(clientConfig.objectId, "Storage File Data SMB Share Contributor");
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    afterEach(() => {
        try {
            (0, testing_1.TerraformDestroy)(fullSynthResult, streamOutput);
        }
        catch (error) {
            console.error("Error during Terraform destroy:", error);
        }
    });
    it("check if stack can be deployed", () => {
        (0, testing_1.TerraformApplyAndCheckIdempotency)(fullSynthResult, streamOutput);
    });
});
//# sourceMappingURL=data:application/json;base64,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