"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthorizationRule = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const eventhub_authorization_rule_1 = require("@cdktf/provider-azurerm/lib/eventhub-authorization-rule");
const cdktf = require("cdktf");
const constructs_1 = require("constructs");
class AuthorizationRule extends constructs_1.Construct {
    /**
     * Constructs a new Authorization Rule for an Azure Event Hub.
     *
     * This class creates an authorization rule which defines the permissions granted to users and applications
     * for accessing and managing the Event Hub. An Authorization Rule can grant listening, sending, and full manage
     * permissions based on the properties specified.
     *
     * @param scope - The scope in which to define this construct, typically used for managing lifecycles and creation order.
     * @param name - The unique name for this instance of the Authorization Rule.
     * @param ehInstanceAuthProps - The properties for configuring the Authorization Rule. The properties include:
     *                - `name`: Required. The name of the Authorization Rule.
     *                - `listen`: Optional. Specifies whether the rule allows listening to the Event Hub. Defaults to false.
     *                - `send`: Optional. Specifies whether the rule allows sending events to the Event Hub. Defaults to false.
     *                - `manage`: Optional. Specifies whether the rule allows managing the Event Hub, including sending and listening. Defaults to false.
     *                When `manage` is true, both `listen` and `send` are implicitly set to true.
     *
     * Example usage:
     * ```typescript
     * const authRule = new AuthorizationRule(this, 'exampleAuthRule', {
     *   name: 'myAuthRule',
     *   listen: true,
     *   send: true,
     *   manage: false // Only listening and sending are enabled; not managing.
     * });
     * ```
     *
     * @remarks
     * The primary connection string and primary key are accessible after the instance creation,
     * allowing for integration with other Azure services or client applications.
     */
    constructor(scope, name, ehInstanceAuthProps) {
        super(scope, name);
        this.ehInstanceAuthProps = ehInstanceAuthProps;
        // Fix input properties
        let listen = ehInstanceAuthProps.listen || false;
        let send = ehInstanceAuthProps.send || false;
        let manage = ehInstanceAuthProps.manage || false;
        if (manage) {
            listen = true;
            send = true;
        }
        const eventhubauthrule = new eventhub_authorization_rule_1.EventhubAuthorizationRule(this, ehInstanceAuthProps.name, {
            name: ehInstanceAuthProps.name,
            resourceGroupName: this.ehInstanceAuthProps.resourceGroupName,
            namespaceName: this.ehInstanceAuthProps.namespaceName,
            eventhubName: this.ehInstanceAuthProps.eventhubName,
            listen: listen,
            send: send,
            manage: manage,
        });
        // Outputs
        this.primaryConnectionString = eventhubauthrule.primaryConnectionString;
        this.primaryKey = eventhubauthrule.primaryKey;
        const cdktfTerraformOutputEventhubAuthPrimaryConnectionString = new cdktf.TerraformOutput(this, "primary_connection_string", {
            value: eventhubauthrule.primaryConnectionString,
            sensitive: true,
        });
        const cdktfTerraformOutputEventhubAuthPrimaryKey = new cdktf.TerraformOutput(this, "primary_key", {
            value: eventhubauthrule.primaryKey,
            sensitive: true,
        });
        cdktfTerraformOutputEventhubAuthPrimaryConnectionString.overrideLogicalId("primary_connection_string");
        cdktfTerraformOutputEventhubAuthPrimaryKey.overrideLogicalId("primary_key");
    }
    addPrimaryConnectionStringToVault(vault, name, expirationDate) {
        vault.addSecret(name, this.primaryConnectionString, expirationDate);
    }
    addPrimaryKeyToVault(vault, name, expirationDate) {
        vault.addSecret(name, this.primaryKey, expirationDate);
    }
}
exports.AuthorizationRule = AuthorizationRule;
_a = JSII_RTTI_SYMBOL_1;
AuthorizationRule[_a] = { fqn: "@microsoft/terraform-cdk-constructs.azure_eventhub.AuthorizationRule", version: "0.0.3-pre.12" };
//# sourceMappingURL=data:application/json;base64,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