"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConsumerGroup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const eventhub_consumer_group_1 = require("@cdktf/provider-azurerm/lib/eventhub-consumer-group");
const cdktf_1 = require("cdktf");
const constructs_1 = require("constructs");
class ConsumerGroup extends constructs_1.Construct {
    /**
     * Constructs a new Event Hub Consumer Group.
     *
     * An Event Hub Consumer Group is a view of an entire Event Hub that enables consumer applications to each have
     * a separate view of the event stream. They read the stream independently at their own pace and with their own
     * offsets. This class creates a consumer group for a specified Event Hub, allowing for decentralized and
     * scalable event processing.
     *
     * @param scope - The scope in which to define this construct, typically representing the Cloud Development Kit (CDK) stack.
     * @param name - The unique name for this instance of the Consumer Group.
     * @param ehConsumerGroupProps - The properties for configuring the Consumer Group. These properties include:
     *                - `name`: Required. The name of the Consumer Group.
     *                - `resourceGroup`: Required. The Azure Resource Group in which the Consumer Group's grandparent Namespace exists.
     *                - `namespaceName`: Required. The name of the grandparent EventHub Namespace.
     *                - `eventhubName`: Required. The name of the Event Hub for which the consumer group is created.
     *                - `userMetadata`: Optional. User-defined metadata to provide additional context about the Consumer Group.
     *
     * Example usage:
     * ```typescript
     * const consumerGroup = new ConsumerGroup(this, 'myConsumerGroup', {
     *   resourceGroup: resourceGroup,
     *   namespaceName: 'exampleNamespace',
     *   eventhubName: 'exampleEventHub',
     *   name: 'myConsumerGroupName',
     *   userMetadata: 'Information about consumer group'
     * });
     * ```
     */
    constructor(scope, name, ehConsumerGroupProps) {
        super(scope, name);
        this.ehConsumerGroupProps = ehConsumerGroupProps;
        const eventhubConsumerGroup = new eventhub_consumer_group_1.EventhubConsumerGroup(this, ehConsumerGroupProps.name, {
            name: ehConsumerGroupProps.name,
            resourceGroupName: ehConsumerGroupProps.resourceGroup.name,
            namespaceName: ehConsumerGroupProps.namespaceName,
            eventhubName: ehConsumerGroupProps.eventhubName,
            userMetadata: ehConsumerGroupProps.userMetadata,
        });
        this.id = eventhubConsumerGroup.id;
        // Outputs
        const cdktfTerraformOutputEventhubConsumerGroupId = new cdktf_1.TerraformOutput(this, "id", {
            value: eventhubConsumerGroup.id,
        });
        cdktfTerraformOutputEventhubConsumerGroupId.overrideLogicalId("id");
    }
}
exports.ConsumerGroup = ConsumerGroup;
_a = JSII_RTTI_SYMBOL_1;
ConsumerGroup[_a] = { fqn: "@microsoft/terraform-cdk-constructs.azure_eventhub.ConsumerGroup", version: "0.0.3-pre.12" };
//# sourceMappingURL=data:application/json;base64,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