"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cluster = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const eventhub_cluster_1 = require("@cdktf/provider-azurerm/lib/eventhub-cluster");
const cdktf = require("cdktf");
const lib_1 = require("../../core-azure/lib");
class Cluster extends lib_1.AzureResource {
    /**
     * Constructs a new Event Hub Cluster.
     *
     * This class creates an Azure Event Hub Cluster which is a dedicated capacity resource for handling
     * high-throughput, low-latency event ingestion and streaming. It is used in scenarios where you need
     * predictable performance and cost regardless of the volume of data ingress or number of downstream
     * event consumers.
     *
     * @param scope - The scope in which to define this construct, usually representing the Cloud Development Kit (CDK) stack.
     * @param name - The unique name for this instance of the Event Hub Cluster.
     * @param props - The properties for configuring the Event Hub Cluster. These properties include:
     *                - `resourceGroup`: Optional. Reference to the resource group for deployment.
     *                - `name`: Required. The name of the Event Hub Cluster.
     *                - `skuName`: Optional. The SKU name for the cluster, which determines the pricing and capabilities.
     *                             Currently, the only supported value is "Dedicated_1". Defaults to "Dedicated_1" if not specified.
     *                - `tags`: Optional. Tags for resource management and categorization.
     *
     * Example usage:
     * ```typescript
     * const eventHubCluster = new Cluster(this, 'myEventHubCluster', {
     *   resourceGroup: resourceGroup,
     *   name: 'myCluster',
     *   skuName: 'Dedicated_1', // This is optional since it defaults to 'Dedicated_1'
     *   tags: {
     *     department: 'IT'
     *   }
     * });
     * ```
     */
    constructor(scope, name, props) {
        super(scope, name);
        this.props = props;
        this.resourceGroup = this.setupResourceGroup(props);
        const defaults = {
            skuName: props.skuName || "Dedicated_1",
            tags: props.tags || {},
        };
        const ehCluster = new eventhub_cluster_1.EventhubCluster(this, "ehcluster", {
            name: props.name,
            resourceGroupName: this.resourceGroup.name,
            location: this.resourceGroup.location,
            ...defaults,
        });
        this.id = ehCluster.id;
        // Outputs
        const cdktfTerraformOutputEventhubId = new cdktf.TerraformOutput(this, "id", {
            value: ehCluster.id,
        });
        cdktfTerraformOutputEventhubId.overrideLogicalId("id");
    }
}
exports.Cluster = Cluster;
_a = JSII_RTTI_SYMBOL_1;
Cluster[_a] = { fqn: "@microsoft/terraform-cdk-constructs.azure_eventhub.Cluster", version: "0.0.3-pre.12" };
//# sourceMappingURL=data:application/json;base64,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