"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KustoDataConnection = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const kusto_eventhub_data_connection_1 = require("@cdktf/provider-azurerm/lib/kusto-eventhub-data-connection");
const constructs_1 = require("constructs");
class KustoDataConnection extends constructs_1.Construct {
    /**
     * Constructs a new Azure Kusto Data Connection for ingesting data from an EventHub.
     *
     * This class creates a data connection within a specified Kusto (Azure Data Explorer) database that connects
     * to an Azure EventHub. This setup enables seamless data ingestion from EventHub into the Kusto database,
     * allowing for real-time analytics on streamed data.
     *
     * @param scope - The scope in which to define this construct, typically representing the Cloud Development Kit (CDK) stack.
     * @param id - The unique identifier for this instance of the data connection.
     * @param kustoDataConnectionProps - The properties for configuring the Kusto EventHub Data Connection. These properties include:
     *                - `name`: Required. The name of the data connection.
     *                - `location`: Required. The Azure region where the data connection will be created.
     *                - `kustoResourceGroup`: Required. The Resource Group where the Kusto database exists.
     *                - `kustoClusterName`: Required. The name of the Kusto Cluster to which this data connection will be added.
     *                - `kustoDatabaseName`: Required. The name of the Kusto Database to which this data connection will be added.
     *                - `eventhubId`: Required. The resource ID of the EventHub used for data ingestion.
     *                - `consumerGroup`: Optional. The EventHub consumer group used for ingestion. Defaults to "$Default".
     *                - `tableName`: Optional. The target table name in the Kusto database used for data ingestion.
     *                - `identityId`: Optional. The resource ID of a managed identity used for authentication with EventHub.
     *                - `mappingRuleName`: Optional. The mapping rule name used for data ingestion.
     *                - `dataFormat`: Optional. Specifies the data format of EventHub messages. Defaults to "JSON".
     *                - `databaseRoutingType`: Optional. Indicates the routing type for the database. Defaults to "Single".
     *                - `compression`: Optional. Specifies the compression type for the data connection. Defaults to "None".
     *
     * Example usage:
     * ```typescript
     * const kustoDataConnection = new KustoDataConnection(this, 'myDataConnection', {
     *   name: 'exampleDataConnection',
     *   location: 'East US',
     *   kustoResourceGroup: resourceGroup,
     *   kustoClusterName: 'exampleCluster',
     *   kustoDatabaseName: 'exampleDatabase',
     *   eventhubId: '/subscriptions/{sub-id}/resourceGroups/{rg}/providers/Microsoft.EventHub/namespaces/{namespace}/eventhubs/{eventhub}',
     *   consumerGroup: '$Default',
     *   tableName: 'destinationTable',
     *   dataFormat: 'JSON',
     *   databaseRoutingType: 'Single',
     *   compression: 'None'
     * });
     * ```
     */
    constructor(scope, id, kustoDataConnectionProps) {
        super(scope, id);
        this.eventhubKustoDataConnectionProps = kustoDataConnectionProps;
        const defaults = {
            tableName: kustoDataConnectionProps.tableName || undefined,
            identityId: kustoDataConnectionProps.identityId || undefined,
            mappingRuleName: kustoDataConnectionProps.mappingRuleName || undefined,
            consumerGroup: kustoDataConnectionProps.consumerGroup || "$Default",
            dataFormat: kustoDataConnectionProps.dataFormat || "JSON",
            databaseRoutingType: kustoDataConnectionProps.databaseRoutingType || "Single",
            compression: kustoDataConnectionProps.compression || "None",
        };
        new kusto_eventhub_data_connection_1.KustoEventhubDataConnection(this, `kusto-data-connection-${this.eventhubKustoDataConnectionProps.name}`, {
            name: this.eventhubKustoDataConnectionProps.name,
            location: this.eventhubKustoDataConnectionProps.location,
            resourceGroupName: this.eventhubKustoDataConnectionProps.kustoResourceGroup.name,
            clusterName: this.eventhubKustoDataConnectionProps.kustoClusterName,
            databaseName: this.eventhubKustoDataConnectionProps.kustoDatabaseName,
            eventhubId: this.eventhubKustoDataConnectionProps.eventhubId,
            ...defaults,
        });
    }
}
exports.KustoDataConnection = KustoDataConnection;
_a = JSII_RTTI_SYMBOL_1;
KustoDataConnection[_a] = { fqn: "@microsoft/terraform-cdk-constructs.azure_eventhub.KustoDataConnection", version: "0.0.3-pre.12" };
//# sourceMappingURL=data:application/json;base64,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