"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Namespace = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const eventhub_namespace_1 = require("@cdktf/provider-azurerm/lib/eventhub-namespace");
const cdktf = require("cdktf");
const instance_1 = require("./instance");
const lib_1 = require("../../core-azure/lib");
class Namespace extends lib_1.AzureResourceWithAlert {
    /**
     * Constructs a new Event Hub Namespace.
     *
     * This class creates an Azure Event Hub Namespace, which serves as a container for all messaging components.
     * Namespaces provide a scoping container for Event Hub resources within a specific region, which can be further
     * controlled and managed using the provided settings.
     *
     * @param scope - The scope in which to define this construct, typically representing the Cloud Development Kit (CDK) stack.
     * @param name - The unique name for this instance of the Event Hub Namespace.
     * @param ehNamespaceProps - The properties for configuring the Event Hub Namespace. These properties include:
     *                - `resourceGroup`: Optional. Reference to the resource group for deployment.
     *                - `name`: Required. The name of the Event Hub Namespace to create.
     *                - `sku`: Optional. The SKU tier of the namespace (Basic, Standard, Premium). Defaults to "Basic".
     *                - `capacity`: Optional. Specifies the throughput units for a Standard SKU namespace. Defaults to 2.
     *                - `autoInflateEnabled`: Optional. Enables or disables Auto Inflate. Defaults to false.
     *                - `maximumThroughputUnits`: Optional. The maximum number of throughput units when Auto Inflate is enabled. Defaults to 2.
     *                - `zoneRedundant`: Optional. Specifies if the namespace should be zone redundant. Defaults to true.
     *                - `tags`: Optional. Tags for resource management and categorization.
     *                - `minimumTlsVersion`: Optional. Specifies the minimum supported TLS version. Defaults to "1.2".
     *                - `publicNetworkAccessEnabled`: Optional. Specifies if public network access is enabled. Defaults to true.
     *                - `localAuthenticationEnabled`: Optional. Specifies if SAS authentication is enabled. Defaults to false.
     *                - `identityType`: Optional. The type of Managed Service Identity. Defaults to "SystemAssigned".
     *                - `identityIds`: Optional. A list of User Assigned Managed Identity IDs.
     *
     * Example usage:
     * ```typescript
     * const eventHubNamespace = new Namespace(this, 'myNamespace', {
     *   resourceGroup: resourceGroup,
     *   name: 'myEventHubNamespace',
     *   sku: 'Standard',
     *   capacity: 4,
     *   autoInflateEnabled: true,
     *   maximumThroughputUnits: 10,
     *   zoneRedundant: false,
     *   tags: {
     *     department: 'IT'
     *   },
     *   minimumTlsVersion: '1.2',
     *   publicNetworkAccessEnabled: false,
     *   localAuthenticationEnabled: true,
     *   identityType: 'SystemAssigned'
     * });
     * ```
     */
    constructor(scope, name, props) {
        super(scope, name);
        this.props = props;
        this.resourceGroup = this.setupResourceGroup(props);
        const defaults = {
            sku: props.sku || "Basic",
            capacity: props.capacity || 2,
            autoInflateEnabled: props.autoInflateEnabled || false,
            maximumThroughputUnits: props.maximumThroughputUnits || 0,
            zoneRedundant: props.zoneRedundant || false,
            tags: props.tags || {},
            minimumTlsVersion: props.minimumTlsVersion || "1.2",
            publicNetworkAccessEnabled: props.publicNetworkAccessEnabled || true,
            localAuthenticationEnabled: props.localAuthenticationEnabled || true,
            identity: {
                type: props.identityType || "SystemAssigned",
                identityIds: props.identityType == "UserAssigned" ? props.identityIds : undefined,
            },
        };
        const eventhubNamespace = new eventhub_namespace_1.EventhubNamespace(this, "ehnamespace", {
            name: props.name,
            resourceGroupName: this.resourceGroup.name,
            location: this.resourceGroup.location,
            ...defaults,
        });
        this.name = eventhubNamespace.name;
        // Outputs
        this.id = eventhubNamespace.id;
        const cdktfTerraformOutputEventhubNamespceId = new cdktf.TerraformOutput(this, "id", {
            value: eventhubNamespace.id,
        });
        cdktfTerraformOutputEventhubNamespceId.overrideLogicalId("id");
    }
    /**
     * Creates and adds an Event Hub instance to the current namespace.
     *
     * This method sets up a new Event Hub instance within the namespace defined by this class. An Event Hub instance
     * serves as a container that processes and stores events. This method facilitates the setup of multiple Event Hubs
     * within a single namespace, each configured according to the specified properties.
     *
     * @param props - The properties for configuring the new Event Hub instance. These properties extend `BaseInstanceProps`, which include:
     *                - `name`: Required. The name of the Event Hub instance.
     *                - `partitionCount`: Optional. The number of partitions in the Event Hub. Default is 2.
     *                - `messageRetention`: Optional. The number of days to retain messages in the Event Hub. Default is 1.
     *                - `status`: Optional. The operational status of the Event Hub (Active, Disabled, SendDisabled). Default is "Active".
     *                Other properties from `BaseInstanceProps` can also be passed and will be used in the creation of the Event Hub.
     *
     * @returns An instance of the Event Hub (`Instance` class), configured with the specified properties.
     *
     * Example usage:
     * ```typescript
     * const eventHub = namespace.addEventhubInstance({
     *   name: 'myEventHub',
     *   partitionCount: 4,
     *   messageRetention: 7,
     *   status: 'Active'
     * });
     * ```
     *
     * @remarks
     * Ensure that the namespace has sufficient capacity and configuration to support the properties of the Event Hub being created,
     * especially in terms of partition count and throughput units if applicable.
     */
    addEventhubInstance(props) {
        return new instance_1.Instance(this, props.name, {
            resourceGroup: this.resourceGroup,
            namespaceName: this.name,
            ...props,
        });
    }
}
exports.Namespace = Namespace;
_a = JSII_RTTI_SYMBOL_1;
Namespace[_a] = { fqn: "@microsoft/terraform-cdk-constructs.azure_eventhub.Namespace", version: "0.0.3-pre.12" };
//# sourceMappingURL=data:application/json;base64,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