"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const data_azurerm_client_config_1 = require("@cdktf/provider-azurerm/lib/data-azurerm-client-config");
const provider_1 = require("@cdktf/provider-azurerm/lib/provider");
const resource_group_1 = require("@cdktf/provider-azurerm/lib/resource-group");
const cdktf_1 = require("cdktf");
const testing_1 = require("../../testing");
const randomName_1 = require("../../util/randomName");
require("cdktf/lib/testing/adapters/jest");
const eh = require("../lib");
describe("Example of deploying an Event Hub", () => {
    let stack;
    let fullSynthResult;
    const streamOutput = process.env.STREAM_OUTPUT !== "false";
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "test");
        const randomName = (0, randomName_1.generateRandomName)(12);
        const clientConfig = new data_azurerm_client_config_1.DataAzurermClientConfig(stack, "CurrentClientConfig", {});
        new provider_1.AzurermProvider(stack, "azureFeature", { features: {} });
        // Create a resource group
        const resourceGroup = new resource_group_1.ResourceGroup(stack, "rg", {
            name: `rg-${randomName}`,
            location: "eastus",
        });
        // Create Eventhub Namespace
        const eventhubNamespace = new eh.Namespace(stack, "eventhub", {
            resourceGroup: resourceGroup,
            name: `ehns-${randomName}`,
            sku: "Standard",
            capacity: 3,
            autoInflateEnabled: true,
            maximumThroughputUnits: 5,
            zoneRedundant: false,
            minimumTlsVersion: "1.2",
            publicNetworkAccessEnabled: false,
            localAuthenticationEnabled: true,
            identityType: "SystemAssigned",
        });
        // Create Eventhub Instance
        const eventhubInstance = eventhubNamespace.addEventhubInstance({
            name: "test-eventhub-instance",
            partitionCount: 2,
            messageRetention: 1,
            status: "Active",
        });
        // Create Eventhub Instance Authorization Rule
        eventhubInstance.addAuthorizationRule({
            name: "test-rule",
            listen: true,
            send: true,
            manage: false,
        });
        // Add Consumer Group to Eventhub Instance
        eventhubInstance.addConsumerGroup("test-consumer-group");
        // Add IAM role to Eventhub Namespace
        eventhubNamespace.addAccess(clientConfig.objectId, "Contributor");
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    afterEach(() => {
        try {
            (0, testing_1.TerraformDestroy)(fullSynthResult, streamOutput);
        }
        catch (error) {
            console.error("Error during Terraform destroy:", error);
        }
    });
    it("check if stack can be deployed", () => {
        (0, testing_1.TerraformApplyAndCheckIdempotency)(fullSynthResult, streamOutput); // Set to true to stream output
    });
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQXp1cmVFdmVudGh1Yi5pbnRlZy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9henVyZS1ldmVudGh1Yi90ZXN0L0F6dXJlRXZlbnRodWIuaW50ZWcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSx1R0FBaUc7QUFDakcsbUVBQXVFO0FBQ3ZFLCtFQUEyRTtBQUMzRSxpQ0FBZ0Q7QUFDaEQsMkNBR3VCO0FBQ3ZCLHNEQUEyRDtBQUMzRCwyQ0FBeUM7QUFDekMsNkJBQTZCO0FBRTdCLFFBQVEsQ0FBQyxtQ0FBbUMsRUFBRSxHQUFHLEVBQUU7SUFDakQsSUFBSSxLQUFxQixDQUFDO0lBQzFCLElBQUksZUFBb0IsQ0FBQztJQUN6QixNQUFNLFlBQVksR0FBRyxPQUFPLENBQUMsR0FBRyxDQUFDLGFBQWEsS0FBSyxPQUFPLENBQUM7SUFFM0QsVUFBVSxDQUFDLEdBQUcsRUFBRTtRQUNkLE1BQU0sR0FBRyxHQUFHLGVBQU8sQ0FBQyxHQUFHLEVBQUUsQ0FBQztRQUMxQixLQUFLLEdBQUcsSUFBSSxzQkFBYyxDQUFDLEdBQUcsRUFBRSxNQUFNLENBQUMsQ0FBQztRQUN4QyxNQUFNLFVBQVUsR0FBRyxJQUFBLCtCQUFrQixFQUFDLEVBQUUsQ0FBQyxDQUFDO1FBRTFDLE1BQU0sWUFBWSxHQUFHLElBQUksb0RBQXVCLENBQzlDLEtBQUssRUFDTCxxQkFBcUIsRUFDckIsRUFBRSxDQUNILENBQUM7UUFFRixJQUFJLDBCQUFlLENBQUMsS0FBSyxFQUFFLGNBQWMsRUFBRSxFQUFFLFFBQVEsRUFBRSxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRTdELDBCQUEwQjtRQUMxQixNQUFNLGFBQWEsR0FBRyxJQUFJLDhCQUFhLENBQUMsS0FBSyxFQUFFLElBQUksRUFBRTtZQUNuRCxJQUFJLEVBQUUsTUFBTSxVQUFVLEVBQUU7WUFDeEIsUUFBUSxFQUFFLFFBQVE7U0FDbkIsQ0FBQyxDQUFDO1FBRUgsNEJBQTRCO1FBQzVCLE1BQU0saUJBQWlCLEdBQUcsSUFBSSxFQUFFLENBQUMsU0FBUyxDQUFDLEtBQUssRUFBRSxVQUFVLEVBQUU7WUFDNUQsYUFBYSxFQUFFLGFBQWE7WUFDNUIsSUFBSSxFQUFFLFFBQVEsVUFBVSxFQUFFO1lBQzFCLEdBQUcsRUFBRSxVQUFVO1lBQ2YsUUFBUSxFQUFFLENBQUM7WUFDWCxrQkFBa0IsRUFBRSxJQUFJO1lBQ3hCLHNCQUFzQixFQUFFLENBQUM7WUFDekIsYUFBYSxFQUFFLEtBQUs7WUFDcEIsaUJBQWlCLEVBQUUsS0FBSztZQUN4QiwwQkFBMEIsRUFBRSxLQUFLO1lBQ2pDLDBCQUEwQixFQUFFLElBQUk7WUFDaEMsWUFBWSxFQUFFLGdCQUFnQjtTQUMvQixDQUFDLENBQUM7UUFFSCwyQkFBMkI7UUFDM0IsTUFBTSxnQkFBZ0IsR0FBRyxpQkFBaUIsQ0FBQyxtQkFBbUIsQ0FBQztZQUM3RCxJQUFJLEVBQUUsd0JBQXdCO1lBQzlCLGNBQWMsRUFBRSxDQUFDO1lBQ2pCLGdCQUFnQixFQUFFLENBQUM7WUFDbkIsTUFBTSxFQUFFLFFBQVE7U0FDakIsQ0FBQyxDQUFDO1FBRUgsOENBQThDO1FBQzlDLGdCQUFnQixDQUFDLG9CQUFvQixDQUFDO1lBQ3BDLElBQUksRUFBRSxXQUFXO1lBQ2pCLE1BQU0sRUFBRSxJQUFJO1lBQ1osSUFBSSxFQUFFLElBQUk7WUFDVixNQUFNLEVBQUUsS0FBSztTQUNkLENBQUMsQ0FBQztRQUVILDBDQUEwQztRQUMxQyxnQkFBZ0IsQ0FBQyxnQkFBZ0IsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1FBRXpELHFDQUFxQztRQUNyQyxpQkFBaUIsQ0FBQyxTQUFTLENBQUMsWUFBWSxDQUFDLFFBQVEsRUFBRSxhQUFhLENBQUMsQ0FBQztRQUVsRSxlQUFlLEdBQUcsZUFBTyxDQUFDLFNBQVMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLDRCQUE0QjtJQUMxRSxDQUFDLENBQUMsQ0FBQztJQUVILFNBQVMsQ0FBQyxHQUFHLEVBQUU7UUFDYixJQUFJO1lBQ0YsSUFBQSwwQkFBZ0IsRUFBQyxlQUFlLEVBQUUsWUFBWSxDQUFDLENBQUM7U0FDakQ7UUFBQyxPQUFPLEtBQUssRUFBRTtZQUNkLE9BQU8sQ0FBQyxLQUFLLENBQUMsaUNBQWlDLEVBQUUsS0FBSyxDQUFDLENBQUM7U0FDekQ7SUFDSCxDQUFDLENBQUMsQ0FBQztJQUVILEVBQUUsQ0FBQyxnQ0FBZ0MsRUFBRSxHQUFHLEVBQUU7UUFDeEMsSUFBQSwyQ0FBaUMsRUFBQyxlQUFlLEVBQUUsWUFBWSxDQUFDLENBQUMsQ0FBQywrQkFBK0I7SUFDbkcsQ0FBQyxDQUFDLENBQUM7QUFDTCxDQUFDLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IERhdGFBenVyZXJtQ2xpZW50Q29uZmlnIH0gZnJvbSBcIkBjZGt0Zi9wcm92aWRlci1henVyZXJtL2xpYi9kYXRhLWF6dXJlcm0tY2xpZW50LWNvbmZpZ1wiO1xuaW1wb3J0IHsgQXp1cmVybVByb3ZpZGVyIH0gZnJvbSBcIkBjZGt0Zi9wcm92aWRlci1henVyZXJtL2xpYi9wcm92aWRlclwiO1xuaW1wb3J0IHsgUmVzb3VyY2VHcm91cCB9IGZyb20gXCJAY2RrdGYvcHJvdmlkZXItYXp1cmVybS9saWIvcmVzb3VyY2UtZ3JvdXBcIjtcbmltcG9ydCB7IFRlc3RpbmcsIFRlcnJhZm9ybVN0YWNrIH0gZnJvbSBcImNka3RmXCI7XG5pbXBvcnQge1xuICBUZXJyYWZvcm1BcHBseUFuZENoZWNrSWRlbXBvdGVuY3ksXG4gIFRlcnJhZm9ybURlc3Ryb3ksXG59IGZyb20gXCIuLi8uLi90ZXN0aW5nXCI7XG5pbXBvcnQgeyBnZW5lcmF0ZVJhbmRvbU5hbWUgfSBmcm9tIFwiLi4vLi4vdXRpbC9yYW5kb21OYW1lXCI7XG5pbXBvcnQgXCJjZGt0Zi9saWIvdGVzdGluZy9hZGFwdGVycy9qZXN0XCI7XG5pbXBvcnQgKiBhcyBlaCBmcm9tIFwiLi4vbGliXCI7XG5cbmRlc2NyaWJlKFwiRXhhbXBsZSBvZiBkZXBsb3lpbmcgYW4gRXZlbnQgSHViXCIsICgpID0+IHtcbiAgbGV0IHN0YWNrOiBUZXJyYWZvcm1TdGFjaztcbiAgbGV0IGZ1bGxTeW50aFJlc3VsdDogYW55O1xuICBjb25zdCBzdHJlYW1PdXRwdXQgPSBwcm9jZXNzLmVudi5TVFJFQU1fT1VUUFVUICE9PSBcImZhbHNlXCI7XG5cbiAgYmVmb3JlRWFjaCgoKSA9PiB7XG4gICAgY29uc3QgYXBwID0gVGVzdGluZy5hcHAoKTtcbiAgICBzdGFjayA9IG5ldyBUZXJyYWZvcm1TdGFjayhhcHAsIFwidGVzdFwiKTtcbiAgICBjb25zdCByYW5kb21OYW1lID0gZ2VuZXJhdGVSYW5kb21OYW1lKDEyKTtcblxuICAgIGNvbnN0IGNsaWVudENvbmZpZyA9IG5ldyBEYXRhQXp1cmVybUNsaWVudENvbmZpZyhcbiAgICAgIHN0YWNrLFxuICAgICAgXCJDdXJyZW50Q2xpZW50Q29uZmlnXCIsXG4gICAgICB7fSxcbiAgICApO1xuXG4gICAgbmV3IEF6dXJlcm1Qcm92aWRlcihzdGFjaywgXCJhenVyZUZlYXR1cmVcIiwgeyBmZWF0dXJlczoge30gfSk7XG5cbiAgICAvLyBDcmVhdGUgYSByZXNvdXJjZSBncm91cFxuICAgIGNvbnN0IHJlc291cmNlR3JvdXAgPSBuZXcgUmVzb3VyY2VHcm91cChzdGFjaywgXCJyZ1wiLCB7XG4gICAgICBuYW1lOiBgcmctJHtyYW5kb21OYW1lfWAsXG4gICAgICBsb2NhdGlvbjogXCJlYXN0dXNcIixcbiAgICB9KTtcblxuICAgIC8vIENyZWF0ZSBFdmVudGh1YiBOYW1lc3BhY2VcbiAgICBjb25zdCBldmVudGh1Yk5hbWVzcGFjZSA9IG5ldyBlaC5OYW1lc3BhY2Uoc3RhY2ssIFwiZXZlbnRodWJcIiwge1xuICAgICAgcmVzb3VyY2VHcm91cDogcmVzb3VyY2VHcm91cCxcbiAgICAgIG5hbWU6IGBlaG5zLSR7cmFuZG9tTmFtZX1gLFxuICAgICAgc2t1OiBcIlN0YW5kYXJkXCIsXG4gICAgICBjYXBhY2l0eTogMyxcbiAgICAgIGF1dG9JbmZsYXRlRW5hYmxlZDogdHJ1ZSxcbiAgICAgIG1heGltdW1UaHJvdWdocHV0VW5pdHM6IDUsXG4gICAgICB6b25lUmVkdW5kYW50OiBmYWxzZSxcbiAgICAgIG1pbmltdW1UbHNWZXJzaW9uOiBcIjEuMlwiLFxuICAgICAgcHVibGljTmV0d29ya0FjY2Vzc0VuYWJsZWQ6IGZhbHNlLFxuICAgICAgbG9jYWxBdXRoZW50aWNhdGlvbkVuYWJsZWQ6IHRydWUsXG4gICAgICBpZGVudGl0eVR5cGU6IFwiU3lzdGVtQXNzaWduZWRcIixcbiAgICB9KTtcblxuICAgIC8vIENyZWF0ZSBFdmVudGh1YiBJbnN0YW5jZVxuICAgIGNvbnN0IGV2ZW50aHViSW5zdGFuY2UgPSBldmVudGh1Yk5hbWVzcGFjZS5hZGRFdmVudGh1Ykluc3RhbmNlKHtcbiAgICAgIG5hbWU6IFwidGVzdC1ldmVudGh1Yi1pbnN0YW5jZVwiLFxuICAgICAgcGFydGl0aW9uQ291bnQ6IDIsXG4gICAgICBtZXNzYWdlUmV0ZW50aW9uOiAxLFxuICAgICAgc3RhdHVzOiBcIkFjdGl2ZVwiLFxuICAgIH0pO1xuXG4gICAgLy8gQ3JlYXRlIEV2ZW50aHViIEluc3RhbmNlIEF1dGhvcml6YXRpb24gUnVsZVxuICAgIGV2ZW50aHViSW5zdGFuY2UuYWRkQXV0aG9yaXphdGlvblJ1bGUoe1xuICAgICAgbmFtZTogXCJ0ZXN0LXJ1bGVcIixcbiAgICAgIGxpc3RlbjogdHJ1ZSxcbiAgICAgIHNlbmQ6IHRydWUsXG4gICAgICBtYW5hZ2U6IGZhbHNlLFxuICAgIH0pO1xuXG4gICAgLy8gQWRkIENvbnN1bWVyIEdyb3VwIHRvIEV2ZW50aHViIEluc3RhbmNlXG4gICAgZXZlbnRodWJJbnN0YW5jZS5hZGRDb25zdW1lckdyb3VwKFwidGVzdC1jb25zdW1lci1ncm91cFwiKTtcblxuICAgIC8vIEFkZCBJQU0gcm9sZSB0byBFdmVudGh1YiBOYW1lc3BhY2VcbiAgICBldmVudGh1Yk5hbWVzcGFjZS5hZGRBY2Nlc3MoY2xpZW50Q29uZmlnLm9iamVjdElkLCBcIkNvbnRyaWJ1dG9yXCIpO1xuXG4gICAgZnVsbFN5bnRoUmVzdWx0ID0gVGVzdGluZy5mdWxsU3ludGgoc3RhY2spOyAvLyBTYXZlIHRoZSByZXN1bHQgZm9yIHJldXNlXG4gIH0pO1xuXG4gIGFmdGVyRWFjaCgoKSA9PiB7XG4gICAgdHJ5IHtcbiAgICAgIFRlcnJhZm9ybURlc3Ryb3koZnVsbFN5bnRoUmVzdWx0LCBzdHJlYW1PdXRwdXQpO1xuICAgIH0gY2F0Y2ggKGVycm9yKSB7XG4gICAgICBjb25zb2xlLmVycm9yKFwiRXJyb3IgZHVyaW5nIFRlcnJhZm9ybSBkZXN0cm95OlwiLCBlcnJvcik7XG4gICAgfVxuICB9KTtcblxuICBpdChcImNoZWNrIGlmIHN0YWNrIGNhbiBiZSBkZXBsb3llZFwiLCAoKSA9PiB7XG4gICAgVGVycmFmb3JtQXBwbHlBbmRDaGVja0lkZW1wb3RlbmN5KGZ1bGxTeW50aFJlc3VsdCwgc3RyZWFtT3V0cHV0KTsgLy8gU2V0IHRvIHRydWUgdG8gc3RyZWFtIG91dHB1dFxuICB9KTtcbn0pO1xuIl19