"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FunctionAppLinux = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const linux_function_app_1 = require("@cdktf/provider-azurerm/lib/linux-function-app");
const service_plan_1 = require("@cdktf/provider-azurerm/lib/service-plan");
const storage_account_1 = require("@cdktf/provider-azurerm/lib/storage-account");
const lib_1 = require("../../core-azure/lib");
class FunctionAppLinux extends lib_1.AzureResource {
    /**
     * Constructs a new FunctionAppLinux.
     *
     * @param scope - The scope in which to define this construct.
     * @param id - The ID of this construct.
     * @param props - The properties for configuring the Azure Function App on Linux. The properties include:
     *                - `name`: Required. Unique name for the Function App within Azure.
     *                - `location`: Required. Azure Region for deployment.
     *                - `resourceGroup`: Optional. Reference to the resource group for deployment.
     *                - `storageAccount`: Optional. Reference to the storage account used by the Function App.
     *                - `runtimeVersion`: Optional. Specifies the runtime version (Node.js, .NET, Java, etc.).
     *                - `servicePlan`: Optional. ID of an existing App Service Plan.
     *                - `servicePlanSku`: Optional. SKU for the App Service Plan.
     *                - `tags`: Optional. Tags for resource management.
     *                - `siteConfig`: Optional. Additional site configuration settings.
     *                - Additional optional properties as described in `FunctionAppLinuxProps` interface.
     *
     * Example usage:
     * ```typescript
     * new FunctionAppLinux(this, 'premiumFA', {
     *   name: `faprem${this.name}`,
     *   location: 'eastus',
     *   servicePlanSku: ServicePlanSkus.PremiumEP1,
     *   runtimeVersion: {
     *     dotnetVersion: '5.0',
     *   },
     *   tags: {
     *     "test": "test"
     *   }
     * });
     * ```
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.resourceGroup = this.setupResourceGroup(props);
        this.storageAccount = this.setupStorageAccount(props);
        this.servicePlan = this.setupServicePlan(props);
        this.resourceGroup = this.resourceGroup;
        // Default siteConfig settings for each hosting plan
        let defaultSiteConfig = {
            use32BitWorker: false,
            applicationStack: {
                nodeVersion: "14",
            },
        };
        // Merge user provided siteConfig with defaults
        const siteConfig = { ...defaultSiteConfig, ...props.siteConfig };
        const defaults = {
            httpsOnly: props.httpsOnly || true,
            clientCertificateEnabled: props.clientCertificateEnabled || false,
            clientCertificateMode: props.clientCertificateMode || "Required",
            identity: props.identity || { type: "SystemAssigned" },
            clientCertificateExclusionPaths: props.clientCertificateExclusionPaths || "",
            functionsExtensionVersion: props.functionsExtensionVersion || "~4",
            enabled: props.enabled || true,
            builtinLoggingEnabled: props.builtinLoggingEnabled || true,
            publicNetworkAccessEnabled: props.publicNetworkAccessEnabled || true,
            storageUsesManagedIdentity: props.storageUsesManagedIdentity || true,
            storageAccountAccessKey: undefined || props.storageAccountAccessKey,
        };
        // Create the Function App
        const functionApp = new linux_function_app_1.LinuxFunctionApp(this, "FunctionApp", {
            ...defaults,
            name: props.name,
            location: props.location,
            resourceGroupName: this.resourceGroup.name,
            servicePlanId: this.servicePlan.id,
            storageAccountName: this.storageAccount.name,
            tags: props.tags,
            siteConfig: siteConfig,
            appSettings: props.appSettings,
            authSettings: props.authSettings,
            authSettingsV2: props.authSettingsV2,
            connectionString: props.connectionString,
            virtualNetworkSubnetId: props.virtualNetworkSubnetId,
            zipDeployFile: props.zipDeployFile,
        });
        this.id = functionApp.id;
        this.defaultHostname = functionApp.defaultHostname;
        this.kind = functionApp.kind;
        this.name = functionApp.name;
    }
    setupStorageAccount(props) {
        // Reference or create a new storage account that will be used by the Function App to store files
        if (!props.storageAccount) {
            return new storage_account_1.StorageAccount(this, "sa", {
                name: `${props.name}stacc`,
                resourceGroupName: this.resourceGroup.name,
                location: props.location,
                accountReplicationType: "LRS",
                accountTier: "Standard",
                minTlsVersion: "TLS1_2",
                tags: props.tags,
                publicNetworkAccessEnabled: false,
                networkRules: {
                    bypass: ["AzureServices"],
                    defaultAction: "Deny",
                },
            });
        }
        else {
            return props.storageAccount;
        }
    }
    setupServicePlan(props) {
        const servicePlanSKU = props.servicePlanSku || "Y1";
        // Use an existing App Service Plan if the ID is provided, otherwise create a new one
        if (!props.servicePlan) {
            return new service_plan_1.ServicePlan(this, "AppServicePlan", {
                name: `${props.name}asp`,
                location: props.location,
                resourceGroupName: this.resourceGroup.name,
                skuName: servicePlanSKU,
                osType: "Linux",
                appServiceEnvironmentId: props.servicePlanAppServiceEnvironmentId,
                maximumElasticWorkerCount: props.servicePlanMaximumElasticWorkerCount,
                workerCount: props.servicePlanWorkerCount,
                perSiteScalingEnabled: props.servicePlanPerSiteScalingEnabled,
                zoneBalancingEnabled: props.servicePlanZoneBalancingEnabled,
                tags: props.tags,
            });
        }
        else {
            return props.servicePlan;
        }
    }
}
exports.FunctionAppLinux = FunctionAppLinux;
_a = JSII_RTTI_SYMBOL_1;
FunctionAppLinux[_a] = { fqn: "@microsoft/terraform-cdk-constructs.azure_functionapp.FunctionAppLinux", version: "0.0.3-pre.12" };
//# sourceMappingURL=data:application/json;base64,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