"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServicePlanSkus = void 0;
/**
 * Enum for Azure Service Plan SKUs.
 */
var ServicePlanSkus;
(function (ServicePlanSkus) {
    // Consumption Plan
    /**
     * Consumption Plan: Automatically scales based on demand and billed per execution.
     * No dedicated resources; suitable for event-driven and intermittent workloads.
     */
    ServicePlanSkus["Consumption"] = "Y1";
    // Premium Plan (EP = Elastic Premium)
    /**
     * Premium Plan EP1: Offers more CPU and memory than Consumption Plan with features like VNet.
     */
    ServicePlanSkus["PremiumEP1"] = "EP1";
    /**
     * Premium Plan EP2: Higher CPU and memory, suitable for more demanding workloads.
     */
    ServicePlanSkus["PremiumEP2"] = "EP2";
    /**
     * Premium Plan EP3: Highest available CPU and memory in the Premium tier.
     */
    ServicePlanSkus["PremiumEP3"] = "EP3";
    // App Service Plan - Basic
    /**
     * Basic B1: Basic tier, more compute options than Free, suitable for small-scale production.
     */
    ServicePlanSkus["ASPBasicB1"] = "B1";
    /**
     * Basic B2: Enhanced tier with more CPU and memory.
     */
    ServicePlanSkus["ASPBasicB2"] = "B2";
    /**
     * Basic B3: Highest Basic tier with more CPU and memory.
     */
    ServicePlanSkus["ASPBasicB3"] = "B3";
    // App Service Plan - Standard
    /**
     * Standard S1: Suitable for production workloads with auto-scaling and staging slots.
     */
    ServicePlanSkus["ASPStandardS1"] = "S1";
    /**
     * Standard S2: More CPU and memory than S1, suitable for larger workloads.
     */
    ServicePlanSkus["ASPStandardS2"] = "S2";
    /**
     * Standard S3: Highest Standard tier, offering maximum available CPU and memory.
     */
    ServicePlanSkus["ASPStandardS3"] = "S3";
    // App Service Plan - Premium
    /**
     * Premium P1V2: Enhanced performance features and VNet integration.
     */
    ServicePlanSkus["ASPPremiumP1V2"] = "P1V2";
    /**
     * Premium P2V2: Higher CPU and memory than P1V2.
     */
    ServicePlanSkus["ASPPremiumP2V2"] = "P2V2";
    /**
     * Premium P3V2: Highest CPU and memory in the Premium category.
     */
    ServicePlanSkus["ASPPremiumP3V2"] = "P3V2";
    // App Service Plan - Isolated
    /**
     * Isolated I1: Dedicated environment for highest compliance and security.
     */
    ServicePlanSkus["ASPIsolatedI1"] = "I1";
    /**
     * Isolated I2: Enhanced isolated plan with more resources.
     */
    ServicePlanSkus["ASPIsolatedI2"] = "I2";
    /**
     * Isolated I3: Top-tier isolated plan with maximum resources.
     */
    ServicePlanSkus["ASPIsolatedI3"] = "I3";
})(ServicePlanSkus || (exports.ServicePlanSkus = ServicePlanSkus = {}));
//# sourceMappingURL=data:application/json;base64,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