"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const log_analytics_workspace_1 = require("@cdktf/provider-azurerm/lib/log-analytics-workspace");
const provider_1 = require("@cdktf/provider-azurerm/lib/provider");
const resource_group_1 = require("@cdktf/provider-azurerm/lib/resource-group");
const cdktf_1 = require("cdktf");
const func = require("..");
const testing_1 = require("../../testing");
const randomName_1 = require("../../util/randomName");
require("cdktf/lib/testing/adapters/jest");
const serviceplanskus_1 = require("../serviceplanskus");
describe("Example of deploying a Linux Function App", () => {
    let stack;
    let fullSynthResult;
    const streamOutput = process.env.STREAM_OUTPUT !== "false";
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "test");
        const randomName = (0, randomName_1.generateRandomName)(12);
        new provider_1.AzurermProvider(stack, "azureFeature", {
            features: {
                resourceGroup: {
                    preventDeletionIfContainsResources: false,
                },
            },
        });
        // Create a resource group
        const resourceGroup = new resource_group_1.ResourceGroup(stack, "rg", {
            name: `rg-${randomName}`,
            location: "eastus",
        });
        const logAnalyticsWorkspace = new log_analytics_workspace_1.LogAnalyticsWorkspace(stack, "log_analytics", {
            location: "eastus",
            name: `la-${randomName}`,
            resourceGroupName: resourceGroup.name,
        });
        // Consumption Function
        const consumptionFunctionApp = new func.FunctionAppLinux(stack, "consumptionFA", {
            name: `fa${randomName}`,
            location: "eastus",
            resourceGroup: resourceGroup,
            tags: {
                test: "test",
            },
        });
        new func.FunctionAppLinux(stack, "consumptionFA2", {
            name: `fa${randomName}2`,
            location: "eastus",
            storageAccount: consumptionFunctionApp.storageAccount,
            servicePlan: consumptionFunctionApp.servicePlan,
            resourceGroup: resourceGroup,
            runtimeVersion: {
                pythonVersion: "3.8",
            },
            siteConfig: {
                cors: {
                    allowedOrigins: ["*"],
                },
            },
            tags: {
                test: "test",
            },
        });
        // Premium Function
        new func.FunctionAppLinux(stack, "premiumFA", {
            name: `faprem${randomName}`,
            location: "eastus",
            servicePlanSku: serviceplanskus_1.ServicePlanSkus.PremiumEP1,
            runtimeVersion: {
                dotnetVersion: "5.0",
            },
            tags: {
                test: "test",
            },
        });
        // Service Plan Function
        new func.FunctionAppLinux(stack, "servicePlanFA", {
            name: `fasp${randomName}`,
            location: "eastus",
            servicePlanSku: serviceplanskus_1.ServicePlanSkus.ASPBasicB1,
            runtimeVersion: {
                pythonVersion: "3.8",
            },
            siteConfig: {
                cors: {
                    allowedOrigins: ["*"],
                },
            },
            tags: {
                test: "test",
            },
        });
        //Diag Settings
        consumptionFunctionApp.addDiagSettings({
            name: "diagsettings",
            logAnalyticsWorkspaceId: logAnalyticsWorkspace.id,
            metric: [
                {
                    category: "AllMetrics",
                },
            ],
        });
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    afterEach(() => {
        try {
            (0, testing_1.TerraformDestroy)(fullSynthResult, streamOutput);
        }
        catch (error) {
            console.error("Error during Terraform destroy:", error);
        }
    });
    it("check if stack can be deployed", () => {
        (0, testing_1.TerraformApplyAndCheckIdempotency)(fullSynthResult, streamOutput); // Set to true to stream output
    });
});
//# sourceMappingURL=data:application/json;base64,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