"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CertificateIssuer = exports.SelfSignedCertificate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const key_vault_certificate_1 = require("@cdktf/provider-azurerm/lib/key-vault-certificate"); // Adjust the import path based on the actual module location.
const key_vault_certificate_issuer_1 = require("@cdktf/provider-azurerm/lib/key-vault-certificate-issuer");
const constructs_1 = require("constructs");
class SelfSignedCertificate extends constructs_1.Construct {
    /**
     * Constructs a self-signed certificate within an Azure Key Vault.
     *
     * This class is responsible for the creation and management of a self-signed certificate, making it available
     * within an Azure Key Vault. The certificate can be used for testing or internal secure communications.
     *
     * @param scope - The scope in which to define this construct, usually representing the Cloud Development Kit (CDK) stack.
     * @param id - The unique identifier for this instance of the certificate.
     * @param props - The properties for creating the self-signed certificate as defined in SelfSignedCertificateProps.
     *
     * Example usage:
     * ```typescript
     * new SelfSignedCertificate(this, 'MySelfSignedCert', {
     *   name: 'exampleCert',
     *   subject: 'CN=example.com',
     *   dnsNames: ['example.com', 'www.example.com'],
     *   keyVaultId: myKeyVault,
     *   accessPolicies: [{ userId: 'user123', permissions: ['all'] }],
     *   tags: { project: 'My Project' }
     * });
     * ```
     */
    constructor(scope, id, props) {
        super(scope, id);
        // Provide default values
        const actionType = props.actionType ?? "AutoRenew";
        const daysBeforeExpiry = props.daysBeforeExpiry ?? 45;
        const certificate = new key_vault_certificate_1.KeyVaultCertificate(this, "AzureKeyVaultCertificate", {
            name: props.name,
            keyVaultId: props.keyVaultId.id,
            certificatePolicy: {
                issuerParameters: {
                    name: "Self",
                },
                keyProperties: {
                    keyType: "RSA",
                    keySize: 2048,
                    reuseKey: true,
                    exportable: true,
                },
                lifetimeAction: [
                    {
                        action: {
                            actionType: actionType,
                        },
                        trigger: {
                            daysBeforeExpiry: daysBeforeExpiry,
                        },
                    },
                ],
                secretProperties: {
                    contentType: "application/x-pkcs12",
                },
                x509CertificateProperties: {
                    subject: props.subject,
                    subjectAlternativeNames: {
                        dnsNames: props.dnsNames,
                    },
                    keyUsage: [
                        "cRLSign",
                        "dataEncipherment",
                        "digitalSignature",
                        "keyAgreement",
                        "keyCertSign",
                        "keyEncipherment",
                    ],
                    extendedKeyUsage: ["1.3.6.1.5.5.7.3.1"],
                    validityInMonths: 12,
                },
            },
        });
        this.certificate = certificate;
        this.id = certificate.id;
        this.secretId = certificate.secretId;
        // Accumulate all the fqdn values
        const dependencies = [];
        for (const policy of props.accessPolicies) {
            dependencies.push(policy.fqdn);
        }
        // Add dependency on all access policies
        certificate.addOverride("depends_on", dependencies);
    }
}
exports.SelfSignedCertificate = SelfSignedCertificate;
_a = JSII_RTTI_SYMBOL_1;
SelfSignedCertificate[_a] = { fqn: "@microsoft/terraform-cdk-constructs.azure_keyvault.SelfSignedCertificate", version: "0.0.3-pre.12" };
class CertificateIssuer extends constructs_1.Construct {
    /**
     * Constructs a new Certificate Issuer within an Azure Key Vault.
     *
     * This class is responsible for setting up a certificate issuer in Azure Key Vault. A certificate issuer is an entity
     * that issues digital certificates for use in SSL/TLS and other cryptographic security contexts. By configuring an issuer,
     * you can manage certificate lifecycle (issue, renew, revoke) through Azure Key Vault in conjunction with external certificate
     * authorities (CAs).
     *
     * @param scope - The scope in which to define this construct, usually representing the Cloud Development Kit (CDK) stack.
     * @param id - The unique identifier for this instance of the certificate issuer.
     * @param props - The properties for configuring the certificate issuer as defined in CertificateIssuerProps. These properties include:
     *                - `name`: Required. The name of the issuer as it will appear in Azure Key Vault.
     *                - `providerName`: Required. The name of the provider that will issue the certificates, such as 'DigiCert' or 'GlobalSign'.
     *                - `keyVaultId`: Required. The ID of the Azure Key Vault where the issuer will be configured.
     *                - `accessPolicies`: Required. Access policies defining who can manage this issuer within the Key Vault.
     *                - `username`: Optional. The username required to authenticate with the certificate provider (if applicable).
     *                - `password`: Optional. The password required to authenticate with the certificate provider (if applicable).
     *
     * Example usage:
     * ```typescript
     * new CertificateIssuer(this, 'MyCertIssuer', {
     *   name: 'MyIssuer',
     *   providerName: 'DigiCert',
     *   keyVaultId: myKeyVault,
     *   accessPolicies: [{ userId: 'user123', permissions: ['manageIssuer'] }],
     *   username: 'user@example.com',
     *   password: 'securepassword'
     * });
     * ```
     */
    constructor(scope, id, props) {
        super(scope, id);
        const certificateIssuer = new key_vault_certificate_issuer_1.KeyVaultCertificateIssuer(this, "AzureKeyVaultCertificate", {
            name: props.name,
            keyVaultId: props.keyVaultId.id,
            providerName: props.providerName,
        });
        // Accumulate all the fqdn values
        const dependencies = [];
        for (const policy of props.accessPolicies) {
            dependencies.push(policy.fqdn);
        }
        // Add dependency on all access policies
        certificateIssuer.addOverride("depends_on", dependencies);
    }
}
exports.CertificateIssuer = CertificateIssuer;
_b = JSII_RTTI_SYMBOL_1;
CertificateIssuer[_b] = { fqn: "@microsoft/terraform-cdk-constructs.azure_keyvault.CertificateIssuer", version: "0.0.3-pre.12" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2VydGlmaWNhdGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvYXp1cmUta2V5dmF1bHQvbGliL2NlcnRpZmljYXRlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkZBQXdGLENBQUMsOERBQThEO0FBQ3ZKLDJHQUFxRztBQUNyRywyQ0FBdUM7QUFvRnZDLE1BQWEscUJBQXNCLFNBQVEsc0JBQVM7SUFLbEQ7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztPQXFCRztJQUNILFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBaUM7UUFDekUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQix5QkFBeUI7UUFDekIsTUFBTSxVQUFVLEdBQUcsS0FBSyxDQUFDLFVBQVUsSUFBSSxXQUFXLENBQUM7UUFDbkQsTUFBTSxnQkFBZ0IsR0FBRyxLQUFLLENBQUMsZ0JBQWdCLElBQUksRUFBRSxDQUFDO1FBRXRELE1BQU0sV0FBVyxHQUFHLElBQUksMkNBQW1CLENBQ3pDLElBQUksRUFDSiwwQkFBMEIsRUFDMUI7WUFDRSxJQUFJLEVBQUUsS0FBSyxDQUFDLElBQUk7WUFDaEIsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsRUFBRTtZQUMvQixpQkFBaUIsRUFBRTtnQkFDakIsZ0JBQWdCLEVBQUU7b0JBQ2hCLElBQUksRUFBRSxNQUFNO2lCQUNiO2dCQUNELGFBQWEsRUFBRTtvQkFDYixPQUFPLEVBQUUsS0FBSztvQkFDZCxPQUFPLEVBQUUsSUFBSTtvQkFDYixRQUFRLEVBQUUsSUFBSTtvQkFDZCxVQUFVLEVBQUUsSUFBSTtpQkFDakI7Z0JBQ0QsY0FBYyxFQUFFO29CQUNkO3dCQUNFLE1BQU0sRUFBRTs0QkFDTixVQUFVLEVBQUUsVUFBVTt5QkFDdkI7d0JBQ0QsT0FBTyxFQUFFOzRCQUNQLGdCQUFnQixFQUFFLGdCQUFnQjt5QkFDbkM7cUJBQ0Y7aUJBQ0Y7Z0JBQ0QsZ0JBQWdCLEVBQUU7b0JBQ2hCLFdBQVcsRUFBRSxzQkFBc0I7aUJBQ3BDO2dCQUNELHlCQUF5QixFQUFFO29CQUN6QixPQUFPLEVBQUUsS0FBSyxDQUFDLE9BQU87b0JBQ3RCLHVCQUF1QixFQUFFO3dCQUN2QixRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVE7cUJBQ3pCO29CQUNELFFBQVEsRUFBRTt3QkFDUixTQUFTO3dCQUNULGtCQUFrQjt3QkFDbEIsa0JBQWtCO3dCQUNsQixjQUFjO3dCQUNkLGFBQWE7d0JBQ2IsaUJBQWlCO3FCQUNsQjtvQkFDRCxnQkFBZ0IsRUFBRSxDQUFDLG1CQUFtQixDQUFDO29CQUN2QyxnQkFBZ0IsRUFBRSxFQUFFO2lCQUNyQjthQUNGO1NBQ0YsQ0FDRixDQUFDO1FBQ0YsSUFBSSxDQUFDLFdBQVcsR0FBRyxXQUFXLENBQUM7UUFFL0IsSUFBSSxDQUFDLEVBQUUsR0FBRyxXQUFXLENBQUMsRUFBRSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxRQUFRLEdBQUcsV0FBVyxDQUFDLFFBQVEsQ0FBQztRQUVyQyxpQ0FBaUM7UUFDakMsTUFBTSxZQUFZLEdBQWEsRUFBRSxDQUFDO1FBQ2xDLEtBQUssTUFBTSxNQUFNLElBQUksS0FBSyxDQUFDLGNBQWMsRUFBRTtZQUN6QyxZQUFZLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQztTQUNoQztRQUVELHdDQUF3QztRQUN4QyxXQUFXLENBQUMsV0FBVyxDQUFDLFlBQVksRUFBRSxZQUFZLENBQUMsQ0FBQztJQUN0RCxDQUFDOztBQS9GSCxzREFnR0M7OztBQUVELE1BQWEsaUJBQWtCLFNBQVEsc0JBQVM7SUFDOUM7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O09BNkJHO0lBQ0gsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUE2QjtRQUNyRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLE1BQU0saUJBQWlCLEdBQUcsSUFBSSx3REFBeUIsQ0FDckQsSUFBSSxFQUNKLDBCQUEwQixFQUMxQjtZQUNFLElBQUksRUFBRSxLQUFLLENBQUMsSUFBSTtZQUNoQixVQUFVLEVBQUUsS0FBSyxDQUFDLFVBQVUsQ0FBQyxFQUFFO1lBQy9CLFlBQVksRUFBRSxLQUFLLENBQUMsWUFBWTtTQUNqQyxDQUNGLENBQUM7UUFFRixpQ0FBaUM7UUFDakMsTUFBTSxZQUFZLEdBQWEsRUFBRSxDQUFDO1FBQ2xDLEtBQUssTUFBTSxNQUFNLElBQUksS0FBSyxDQUFDLGNBQWMsRUFBRTtZQUN6QyxZQUFZLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQztTQUNoQztRQUVELHdDQUF3QztRQUN4QyxpQkFBaUIsQ0FBQyxXQUFXLENBQUMsWUFBWSxFQUFFLFlBQVksQ0FBQyxDQUFDO0lBQzVELENBQUM7O0FBcERILDhDQXFEQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEtleVZhdWx0Q2VydGlmaWNhdGUgfSBmcm9tIFwiQGNka3RmL3Byb3ZpZGVyLWF6dXJlcm0vbGliL2tleS12YXVsdC1jZXJ0aWZpY2F0ZVwiOyAvLyBBZGp1c3QgdGhlIGltcG9ydCBwYXRoIGJhc2VkIG9uIHRoZSBhY3R1YWwgbW9kdWxlIGxvY2F0aW9uLlxuaW1wb3J0IHsgS2V5VmF1bHRDZXJ0aWZpY2F0ZUlzc3VlciB9IGZyb20gXCJAY2RrdGYvcHJvdmlkZXItYXp1cmVybS9saWIva2V5LXZhdWx0LWNlcnRpZmljYXRlLWlzc3VlclwiO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSBcImNvbnN0cnVjdHNcIjtcbmltcG9ydCB7IEFjY2Vzc1BvbGljeSB9IGZyb20gXCIuL3BvbGljeVwiO1xuaW1wb3J0IHsgVmF1bHQgfSBmcm9tIFwiLi92YXVsdFwiO1xuXG4vKipcbiAqIFByb3BlcnRpZXMgcmVxdWlyZWQgdG8gY3JlYXRlIGEgc2VsZi1zaWduZWQgY2VydGlmaWNhdGUgd2l0aGluIEF6dXJlIEtleSBWYXVsdC5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTZWxmU2lnbmVkQ2VydGlmaWNhdGVQcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgbmFtZSBvZiB0aGUgY2VydGlmaWNhdGUgdG8gYmUgc3RvcmVkIGluIEF6dXJlIEtleSBWYXVsdC5cbiAgICovXG4gIHJlYWRvbmx5IG5hbWU6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIHN1YmplY3QgbmFtZSBmb3IgdGhlIGNlcnRpZmljYXRlLCB0eXBpY2FsbHkgcmVwcmVzZW50ZWQgaW4gWC41MDkgZGlzdGluZ3Vpc2hlZCBuYW1lIGZvcm1hdC5cbiAgICovXG4gIHJlYWRvbmx5IHN1YmplY3Q6IHN0cmluZztcblxuICAvKipcbiAgICogQWRkaXRpb25hbCBETlMgbmFtZXMgdG8gYmUgaW5jbHVkZWQgaW4gdGhlIGNlcnRpZmljYXRlLiBVc2VmdWwgZm9yIGNyZWF0aW5nIGNlcnRpZmljYXRlcyB2YWxpZCBmb3IgbXVsdGlwbGUgaG9zdG5hbWVzLlxuICAgKi9cbiAgcmVhZG9ubHkgZG5zTmFtZXM6IHN0cmluZ1tdO1xuXG4gIC8qKlxuICAgKiBUaGUgSUQgb2YgdGhlIEF6dXJlIEtleSBWYXVsdCB3aGVyZSB0aGUgY2VydGlmaWNhdGUgd2lsbCBiZSBjcmVhdGVkIGFuZCBzdG9yZWQuXG4gICAqL1xuICByZWFkb25seSBrZXlWYXVsdElkOiBWYXVsdDtcblxuICAvKipcbiAgICogU3BlY2lmaWVzIHRoZSB0eXBlIG9mIGFjdGlvbiB0byBwZXJmb3JtIHdpdGggdGhlIGNlcnRpZmljYXRlLCBzdWNoIGFzICdjcmVhdGUnIG9yICdyZW5ldycuXG4gICAqL1xuICByZWFkb25seSBhY3Rpb25UeXBlPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBTcGVjaWZpZXMgdGhlIG51bWJlciBvZiBkYXlzIGJlZm9yZSBleHBpcnkgd2hlbiBhbiBhY3Rpb24gc2hvdWxkIGJlIHRha2VuIChlLmcuLCByZW5ldyB0aGUgY2VydGlmaWNhdGUpLlxuICAgKi9cbiAgcmVhZG9ubHkgZGF5c0JlZm9yZUV4cGlyeT86IG51bWJlcjtcblxuICAvKipcbiAgICogQWNjZXNzIHBvbGljaWVzIGRlZmluaW5nIHdobyBjYW4gYWNjZXNzIHRoaXMgY2VydGlmaWNhdGUgd2l0aGluIHRoZSBBenVyZSBLZXkgVmF1bHQuXG4gICAqL1xuICByZWFkb25seSBhY2Nlc3NQb2xpY2llczogQWNjZXNzUG9saWN5W107XG5cbiAgLyoqXG4gICAqIFRhZ3MgdG8gYmUgYXNzb2NpYXRlZCB3aXRoIHRoZSBjZXJ0aWZpY2F0ZSBmb3Igb3JnYW5pemF0aW9uYWwgcHVycG9zZXMuXG4gICAqL1xuICByZWFkb25seSB0YWdzPzogeyBba2V5OiBzdHJpbmddOiBzdHJpbmcgfTtcbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIHJlcXVpcmVkIHRvIGNvbmZpZ3VyZSBhIGNlcnRpZmljYXRlIGlzc3VlciB3aXRoaW4gQXp1cmUgS2V5IFZhdWx0LlxuICovXG5leHBvcnQgaW50ZXJmYWNlIENlcnRpZmljYXRlSXNzdWVyUHJvcHMge1xuICAvKipcbiAgICogVGhlIG5hbWUgb2YgdGhlIGNlcnRpZmljYXRlIGlzc3VlciBhcyBpdCB3aWxsIGFwcGVhciBpbiBBenVyZSBLZXkgVmF1bHQuXG4gICAqL1xuICByZWFkb25seSBuYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSBwcm92aWRlciB0aGF0IHdpbGwgaXNzdWUgdGhlIGNlcnRpZmljYXRlLCBzdWNoIGFzICdEaWdpQ2VydCcgb3IgJ0dsb2JhbFNpZ24nLlxuICAgKi9cbiAgcmVhZG9ubHkgcHJvdmlkZXJOYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBJRCBvZiB0aGUgQXp1cmUgS2V5IFZhdWx0IHdoZXJlIHRoZSBpc3N1ZXIgd2lsbCBiZSBjb25maWd1cmVkLlxuICAgKi9cbiAgcmVhZG9ubHkga2V5VmF1bHRJZDogVmF1bHQ7XG5cbiAgLyoqXG4gICAqIEFjY2VzcyBwb2xpY2llcyBkZWZpbmluZyB3aG8gY2FuIG1hbmFnZSB0aGlzIGlzc3VlciBhbmQgdGhlIGNlcnRpZmljYXRlcyBpdCBpc3N1ZXMgd2l0aGluIHRoZSBLZXkgVmF1bHQuXG4gICAqL1xuICByZWFkb25seSBhY2Nlc3NQb2xpY2llczogQWNjZXNzUG9saWN5W107XG5cbiAgLyoqXG4gICAqIFRoZSB1c2VybmFtZSByZXF1aXJlZCB0byBhdXRoZW50aWNhdGUgd2l0aCB0aGUgY2VydGlmaWNhdGUgcHJvdmlkZXIgKGlmIGFwcGxpY2FibGUpLlxuICAgKi9cbiAgcmVhZG9ubHkgdXNlcm5hbWU/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBwYXNzd29yZCByZXF1aXJlZCB0byBhdXRoZW50aWNhdGUgd2l0aCB0aGUgY2VydGlmaWNhdGUgcHJvdmlkZXIgKGlmIGFwcGxpY2FibGUpLlxuICAgKi9cbiAgcmVhZG9ubHkgcGFzc3dvcmQ/OiBzdHJpbmc7XG59XG5cbmV4cG9ydCBjbGFzcyBTZWxmU2lnbmVkQ2VydGlmaWNhdGUgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICBwdWJsaWMgY2VydGlmaWNhdGU6IEtleVZhdWx0Q2VydGlmaWNhdGU7XG4gIHB1YmxpYyBpZDogc3RyaW5nO1xuICBwdWJsaWMgc2VjcmV0SWQ6IHN0cmluZztcblxuICAvKipcbiAgICogQ29uc3RydWN0cyBhIHNlbGYtc2lnbmVkIGNlcnRpZmljYXRlIHdpdGhpbiBhbiBBenVyZSBLZXkgVmF1bHQuXG4gICAqXG4gICAqIFRoaXMgY2xhc3MgaXMgcmVzcG9uc2libGUgZm9yIHRoZSBjcmVhdGlvbiBhbmQgbWFuYWdlbWVudCBvZiBhIHNlbGYtc2lnbmVkIGNlcnRpZmljYXRlLCBtYWtpbmcgaXQgYXZhaWxhYmxlXG4gICAqIHdpdGhpbiBhbiBBenVyZSBLZXkgVmF1bHQuIFRoZSBjZXJ0aWZpY2F0ZSBjYW4gYmUgdXNlZCBmb3IgdGVzdGluZyBvciBpbnRlcm5hbCBzZWN1cmUgY29tbXVuaWNhdGlvbnMuXG4gICAqXG4gICAqIEBwYXJhbSBzY29wZSAtIFRoZSBzY29wZSBpbiB3aGljaCB0byBkZWZpbmUgdGhpcyBjb25zdHJ1Y3QsIHVzdWFsbHkgcmVwcmVzZW50aW5nIHRoZSBDbG91ZCBEZXZlbG9wbWVudCBLaXQgKENESykgc3RhY2suXG4gICAqIEBwYXJhbSBpZCAtIFRoZSB1bmlxdWUgaWRlbnRpZmllciBmb3IgdGhpcyBpbnN0YW5jZSBvZiB0aGUgY2VydGlmaWNhdGUuXG4gICAqIEBwYXJhbSBwcm9wcyAtIFRoZSBwcm9wZXJ0aWVzIGZvciBjcmVhdGluZyB0aGUgc2VsZi1zaWduZWQgY2VydGlmaWNhdGUgYXMgZGVmaW5lZCBpbiBTZWxmU2lnbmVkQ2VydGlmaWNhdGVQcm9wcy5cbiAgICpcbiAgICogRXhhbXBsZSB1c2FnZTpcbiAgICogYGBgdHlwZXNjcmlwdFxuICAgKiBuZXcgU2VsZlNpZ25lZENlcnRpZmljYXRlKHRoaXMsICdNeVNlbGZTaWduZWRDZXJ0Jywge1xuICAgKiAgIG5hbWU6ICdleGFtcGxlQ2VydCcsXG4gICAqICAgc3ViamVjdDogJ0NOPWV4YW1wbGUuY29tJyxcbiAgICogICBkbnNOYW1lczogWydleGFtcGxlLmNvbScsICd3d3cuZXhhbXBsZS5jb20nXSxcbiAgICogICBrZXlWYXVsdElkOiBteUtleVZhdWx0LFxuICAgKiAgIGFjY2Vzc1BvbGljaWVzOiBbeyB1c2VySWQ6ICd1c2VyMTIzJywgcGVybWlzc2lvbnM6IFsnYWxsJ10gfV0sXG4gICAqICAgdGFnczogeyBwcm9qZWN0OiAnTXkgUHJvamVjdCcgfVxuICAgKiB9KTtcbiAgICogYGBgXG4gICAqL1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogU2VsZlNpZ25lZENlcnRpZmljYXRlUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgLy8gUHJvdmlkZSBkZWZhdWx0IHZhbHVlc1xuICAgIGNvbnN0IGFjdGlvblR5cGUgPSBwcm9wcy5hY3Rpb25UeXBlID8/IFwiQXV0b1JlbmV3XCI7XG4gICAgY29uc3QgZGF5c0JlZm9yZUV4cGlyeSA9IHByb3BzLmRheXNCZWZvcmVFeHBpcnkgPz8gNDU7XG5cbiAgICBjb25zdCBjZXJ0aWZpY2F0ZSA9IG5ldyBLZXlWYXVsdENlcnRpZmljYXRlKFxuICAgICAgdGhpcyxcbiAgICAgIFwiQXp1cmVLZXlWYXVsdENlcnRpZmljYXRlXCIsXG4gICAgICB7XG4gICAgICAgIG5hbWU6IHByb3BzLm5hbWUsXG4gICAgICAgIGtleVZhdWx0SWQ6IHByb3BzLmtleVZhdWx0SWQuaWQsXG4gICAgICAgIGNlcnRpZmljYXRlUG9saWN5OiB7XG4gICAgICAgICAgaXNzdWVyUGFyYW1ldGVyczoge1xuICAgICAgICAgICAgbmFtZTogXCJTZWxmXCIsXG4gICAgICAgICAgfSxcbiAgICAgICAgICBrZXlQcm9wZXJ0aWVzOiB7XG4gICAgICAgICAgICBrZXlUeXBlOiBcIlJTQVwiLFxuICAgICAgICAgICAga2V5U2l6ZTogMjA0OCxcbiAgICAgICAgICAgIHJldXNlS2V5OiB0cnVlLFxuICAgICAgICAgICAgZXhwb3J0YWJsZTogdHJ1ZSxcbiAgICAgICAgICB9LFxuICAgICAgICAgIGxpZmV0aW1lQWN0aW9uOiBbXG4gICAgICAgICAgICB7XG4gICAgICAgICAgICAgIGFjdGlvbjoge1xuICAgICAgICAgICAgICAgIGFjdGlvblR5cGU6IGFjdGlvblR5cGUsXG4gICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgIHRyaWdnZXI6IHtcbiAgICAgICAgICAgICAgICBkYXlzQmVmb3JlRXhwaXJ5OiBkYXlzQmVmb3JlRXhwaXJ5LFxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICBdLFxuICAgICAgICAgIHNlY3JldFByb3BlcnRpZXM6IHtcbiAgICAgICAgICAgIGNvbnRlbnRUeXBlOiBcImFwcGxpY2F0aW9uL3gtcGtjczEyXCIsXG4gICAgICAgICAgfSxcbiAgICAgICAgICB4NTA5Q2VydGlmaWNhdGVQcm9wZXJ0aWVzOiB7XG4gICAgICAgICAgICBzdWJqZWN0OiBwcm9wcy5zdWJqZWN0LFxuICAgICAgICAgICAgc3ViamVjdEFsdGVybmF0aXZlTmFtZXM6IHtcbiAgICAgICAgICAgICAgZG5zTmFtZXM6IHByb3BzLmRuc05hbWVzLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIGtleVVzYWdlOiBbXG4gICAgICAgICAgICAgIFwiY1JMU2lnblwiLFxuICAgICAgICAgICAgICBcImRhdGFFbmNpcGhlcm1lbnRcIixcbiAgICAgICAgICAgICAgXCJkaWdpdGFsU2lnbmF0dXJlXCIsXG4gICAgICAgICAgICAgIFwia2V5QWdyZWVtZW50XCIsXG4gICAgICAgICAgICAgIFwia2V5Q2VydFNpZ25cIixcbiAgICAgICAgICAgICAgXCJrZXlFbmNpcGhlcm1lbnRcIixcbiAgICAgICAgICAgIF0sXG4gICAgICAgICAgICBleHRlbmRlZEtleVVzYWdlOiBbXCIxLjMuNi4xLjUuNS43LjMuMVwiXSxcbiAgICAgICAgICAgIHZhbGlkaXR5SW5Nb250aHM6IDEyLFxuICAgICAgICAgIH0sXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgICk7XG4gICAgdGhpcy5jZXJ0aWZpY2F0ZSA9IGNlcnRpZmljYXRlO1xuXG4gICAgdGhpcy5pZCA9IGNlcnRpZmljYXRlLmlkO1xuICAgIHRoaXMuc2VjcmV0SWQgPSBjZXJ0aWZpY2F0ZS5zZWNyZXRJZDtcblxuICAgIC8vIEFjY3VtdWxhdGUgYWxsIHRoZSBmcWRuIHZhbHVlc1xuICAgIGNvbnN0IGRlcGVuZGVuY2llczogc3RyaW5nW10gPSBbXTtcbiAgICBmb3IgKGNvbnN0IHBvbGljeSBvZiBwcm9wcy5hY2Nlc3NQb2xpY2llcykge1xuICAgICAgZGVwZW5kZW5jaWVzLnB1c2gocG9saWN5LmZxZG4pO1xuICAgIH1cblxuICAgIC8vIEFkZCBkZXBlbmRlbmN5IG9uIGFsbCBhY2Nlc3MgcG9saWNpZXNcbiAgICBjZXJ0aWZpY2F0ZS5hZGRPdmVycmlkZShcImRlcGVuZHNfb25cIiwgZGVwZW5kZW5jaWVzKTtcbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgQ2VydGlmaWNhdGVJc3N1ZXIgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICAvKipcbiAgICogQ29uc3RydWN0cyBhIG5ldyBDZXJ0aWZpY2F0ZSBJc3N1ZXIgd2l0aGluIGFuIEF6dXJlIEtleSBWYXVsdC5cbiAgICpcbiAgICogVGhpcyBjbGFzcyBpcyByZXNwb25zaWJsZSBmb3Igc2V0dGluZyB1cCBhIGNlcnRpZmljYXRlIGlzc3VlciBpbiBBenVyZSBLZXkgVmF1bHQuIEEgY2VydGlmaWNhdGUgaXNzdWVyIGlzIGFuIGVudGl0eVxuICAgKiB0aGF0IGlzc3VlcyBkaWdpdGFsIGNlcnRpZmljYXRlcyBmb3IgdXNlIGluIFNTTC9UTFMgYW5kIG90aGVyIGNyeXB0b2dyYXBoaWMgc2VjdXJpdHkgY29udGV4dHMuIEJ5IGNvbmZpZ3VyaW5nIGFuIGlzc3VlcixcbiAgICogeW91IGNhbiBtYW5hZ2UgY2VydGlmaWNhdGUgbGlmZWN5Y2xlIChpc3N1ZSwgcmVuZXcsIHJldm9rZSkgdGhyb3VnaCBBenVyZSBLZXkgVmF1bHQgaW4gY29uanVuY3Rpb24gd2l0aCBleHRlcm5hbCBjZXJ0aWZpY2F0ZVxuICAgKiBhdXRob3JpdGllcyAoQ0FzKS5cbiAgICpcbiAgICogQHBhcmFtIHNjb3BlIC0gVGhlIHNjb3BlIGluIHdoaWNoIHRvIGRlZmluZSB0aGlzIGNvbnN0cnVjdCwgdXN1YWxseSByZXByZXNlbnRpbmcgdGhlIENsb3VkIERldmVsb3BtZW50IEtpdCAoQ0RLKSBzdGFjay5cbiAgICogQHBhcmFtIGlkIC0gVGhlIHVuaXF1ZSBpZGVudGlmaWVyIGZvciB0aGlzIGluc3RhbmNlIG9mIHRoZSBjZXJ0aWZpY2F0ZSBpc3N1ZXIuXG4gICAqIEBwYXJhbSBwcm9wcyAtIFRoZSBwcm9wZXJ0aWVzIGZvciBjb25maWd1cmluZyB0aGUgY2VydGlmaWNhdGUgaXNzdWVyIGFzIGRlZmluZWQgaW4gQ2VydGlmaWNhdGVJc3N1ZXJQcm9wcy4gVGhlc2UgcHJvcGVydGllcyBpbmNsdWRlOlxuICAgKiAgICAgICAgICAgICAgICAtIGBuYW1lYDogUmVxdWlyZWQuIFRoZSBuYW1lIG9mIHRoZSBpc3N1ZXIgYXMgaXQgd2lsbCBhcHBlYXIgaW4gQXp1cmUgS2V5IFZhdWx0LlxuICAgKiAgICAgICAgICAgICAgICAtIGBwcm92aWRlck5hbWVgOiBSZXF1aXJlZC4gVGhlIG5hbWUgb2YgdGhlIHByb3ZpZGVyIHRoYXQgd2lsbCBpc3N1ZSB0aGUgY2VydGlmaWNhdGVzLCBzdWNoIGFzICdEaWdpQ2VydCcgb3IgJ0dsb2JhbFNpZ24nLlxuICAgKiAgICAgICAgICAgICAgICAtIGBrZXlWYXVsdElkYDogUmVxdWlyZWQuIFRoZSBJRCBvZiB0aGUgQXp1cmUgS2V5IFZhdWx0IHdoZXJlIHRoZSBpc3N1ZXIgd2lsbCBiZSBjb25maWd1cmVkLlxuICAgKiAgICAgICAgICAgICAgICAtIGBhY2Nlc3NQb2xpY2llc2A6IFJlcXVpcmVkLiBBY2Nlc3MgcG9saWNpZXMgZGVmaW5pbmcgd2hvIGNhbiBtYW5hZ2UgdGhpcyBpc3N1ZXIgd2l0aGluIHRoZSBLZXkgVmF1bHQuXG4gICAqICAgICAgICAgICAgICAgIC0gYHVzZXJuYW1lYDogT3B0aW9uYWwuIFRoZSB1c2VybmFtZSByZXF1aXJlZCB0byBhdXRoZW50aWNhdGUgd2l0aCB0aGUgY2VydGlmaWNhdGUgcHJvdmlkZXIgKGlmIGFwcGxpY2FibGUpLlxuICAgKiAgICAgICAgICAgICAgICAtIGBwYXNzd29yZGA6IE9wdGlvbmFsLiBUaGUgcGFzc3dvcmQgcmVxdWlyZWQgdG8gYXV0aGVudGljYXRlIHdpdGggdGhlIGNlcnRpZmljYXRlIHByb3ZpZGVyIChpZiBhcHBsaWNhYmxlKS5cbiAgICpcbiAgICogRXhhbXBsZSB1c2FnZTpcbiAgICogYGBgdHlwZXNjcmlwdFxuICAgKiBuZXcgQ2VydGlmaWNhdGVJc3N1ZXIodGhpcywgJ015Q2VydElzc3VlcicsIHtcbiAgICogICBuYW1lOiAnTXlJc3N1ZXInLFxuICAgKiAgIHByb3ZpZGVyTmFtZTogJ0RpZ2lDZXJ0JyxcbiAgICogICBrZXlWYXVsdElkOiBteUtleVZhdWx0LFxuICAgKiAgIGFjY2Vzc1BvbGljaWVzOiBbeyB1c2VySWQ6ICd1c2VyMTIzJywgcGVybWlzc2lvbnM6IFsnbWFuYWdlSXNzdWVyJ10gfV0sXG4gICAqICAgdXNlcm5hbWU6ICd1c2VyQGV4YW1wbGUuY29tJyxcbiAgICogICBwYXNzd29yZDogJ3NlY3VyZXBhc3N3b3JkJ1xuICAgKiB9KTtcbiAgICogYGBgXG4gICAqL1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ2VydGlmaWNhdGVJc3N1ZXJQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBjb25zdCBjZXJ0aWZpY2F0ZUlzc3VlciA9IG5ldyBLZXlWYXVsdENlcnRpZmljYXRlSXNzdWVyKFxuICAgICAgdGhpcyxcbiAgICAgIFwiQXp1cmVLZXlWYXVsdENlcnRpZmljYXRlXCIsXG4gICAgICB7XG4gICAgICAgIG5hbWU6IHByb3BzLm5hbWUsXG4gICAgICAgIGtleVZhdWx0SWQ6IHByb3BzLmtleVZhdWx0SWQuaWQsXG4gICAgICAgIHByb3ZpZGVyTmFtZTogcHJvcHMucHJvdmlkZXJOYW1lLFxuICAgICAgfSxcbiAgICApO1xuXG4gICAgLy8gQWNjdW11bGF0ZSBhbGwgdGhlIGZxZG4gdmFsdWVzXG4gICAgY29uc3QgZGVwZW5kZW5jaWVzOiBzdHJpbmdbXSA9IFtdO1xuICAgIGZvciAoY29uc3QgcG9saWN5IG9mIHByb3BzLmFjY2Vzc1BvbGljaWVzKSB7XG4gICAgICBkZXBlbmRlbmNpZXMucHVzaChwb2xpY3kuZnFkbik7XG4gICAgfVxuXG4gICAgLy8gQWRkIGRlcGVuZGVuY3kgb24gYWxsIGFjY2VzcyBwb2xpY2llc1xuICAgIGNlcnRpZmljYXRlSXNzdWVyLmFkZE92ZXJyaWRlKFwiZGVwZW5kc19vblwiLCBkZXBlbmRlbmNpZXMpO1xuICB9XG59XG4iXX0=