"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Key = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const key_vault_key_1 = require("@cdktf/provider-azurerm/lib/key-vault-key");
const constructs_1 = require("constructs");
class Key extends constructs_1.Construct {
    /**
     * Constructs a new Key resource in Azure Key Vault.
     *
     * This class is responsible for the creation and management of a cryptographic key stored in Azure Key Vault.
     * The key can be used for a variety of cryptographic operations, such as encryption, decryption, signing, or
     * verifying signatures, depending on the permissions granted. It supports different key types and configurations,
     * allowing for customization to meet specific security requirements.
     *
     * @param scope - The scope in which to define this construct, usually representing the Cloud Development Kit (CDK) stack.
     * @param id - The unique identifier for this instance of the Key.
     * @param props - The properties for creating the key as defined in KeyProps. These properties include:
     *                - `name`: Required. The name of the key as it will appear in Azure Key Vault.
     *                - `keyVaultId`: Required. The ID of the Azure Key Vault where the key will be created.
     *                - `keyType`: Required. The type of cryptographic key to create (e.g., RSA, EC).
     *                - `keySize`: Optional. The size of the key, typically specified for RSA keys.
     *                - `keyOpts`: Optional. Additional options or attributes related to the key's capabilities such as encrypt, decrypt, wrapKey, unwrapKey.
     *                - `rotationPolicy`: Optional. The policy settings for rotating the key automatically.
     *                - `expires`: Optional. The expiration date of the key in UTC format (YYYY-MM-DDTHH:MM:SSZ).
     *                - `accessPolicies`: Required. Access policies defining who can access this key within the Key Vault.
     *
     * Example usage:
     * ```typescript
     * new Key(this, 'myKey', {
     *   name: 'encryptionKey',
     *   keyVaultId: myKeyVault,
     *   keyType: 'RSA',
     *   keySize: 2048,
     *   keyOpts: ['encrypt', 'decrypt', 'sign', 'verify'],
     *   rotationPolicy: {
     *     expiryTime: 'P90D'
     *   },
     *   expires: '2030-01-01T00:00:00Z',
     *   accessPolicies: [{ userId: 'user123', permissions: ['get', 'list', 'update'] }]
     * });
     * ```
     */
    constructor(scope, id, props) {
        super(scope, id);
        const key = new key_vault_key_1.KeyVaultKey(this, "AzureKeyVaultKey", {
            name: props.name,
            keyVaultId: props.keyVaultId.id,
            keyType: props.keyType,
            keySize: props.keySize,
            keyOpts: props.keyOpts,
            rotationPolicy: props.rotationPolicy,
            expirationDate: props.expires,
        });
        this.vaultKey = key;
        // Accumulate all the fqdn values
        const dependencies = [];
        for (const policy of props.accessPolicies) {
            dependencies.push(policy.fqdn);
        }
        // Add dependency on all access policies
        key.addOverride("depends_on", dependencies);
    }
}
exports.Key = Key;
_a = JSII_RTTI_SYMBOL_1;
Key[_a] = { fqn: "@microsoft/terraform-cdk-constructs.azure_keyvault.Key", version: "0.0.3-pre.12" };
//# sourceMappingURL=data:application/json;base64,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