"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessPolicy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const key_vault_access_policy_1 = require("@cdktf/provider-azurerm/lib/key-vault-access-policy");
const constructs_1 = require("constructs");
class AccessPolicy extends constructs_1.Construct {
    /**
     * Constructs a new Access Policy for Azure Key Vault.
     *
     * This class is responsible for setting up access policies that define what operations an Azure AD identity
     * can perform on the keys, secrets, certificates, and storage accounts within a specified Azure Key Vault.
     *
     * @param scope - The scope in which to define this construct, usually representing the Cloud Development Kit (CDK) stack.
     * @param id - The unique identifier for this instance of the access policy.
     * @param props - The properties for creating the access policy as defined in AccessPolicyProps. These include:
     *                - `keyVaultId`: The Azure Key Vault identifier where the policy will be set.
     *                - `tenantId`: The tenant ID of the Azure AD tenant where the Key Vault is hosted.
     *                - `objectId`: The object ID of the Azure AD identity (user, group, or service principal).
     *                - `secretPermissions`: Optional list of permissions to secrets within the Key Vault.
     *                - `certificatePermissions`: Optional list of permissions to certificates within the Key Vault.
     *                - `keyPermissions`: Optional list of permissions to keys within the Key Vault.
     *                - `storagePermissions`: Optional list of permissions to storage accounts linked to the Key Vault.
     *
     * Example usage:
     * ```typescript
     * new AccessPolicy(this, 'MyAccessPolicy', {
     *   keyVaultId: myKeyVault,
     *   tenantId: 'my-tenant-id',
     *   objectId: 'user-object-id',
     *   keyPermissions: ['get', 'list', 'update'],
     *   secretPermissions: ['get'],
     *   certificatePermissions: ['get', 'list'],
     *   storagePermissions: ['get', 'list']
     * });
     * ```
     */
    constructor(scope, id, props) {
        super(scope, id);
        const policy = new key_vault_access_policy_1.KeyVaultAccessPolicyA(this, "policy", {
            keyVaultId: props.keyVaultId.id,
            tenantId: props.tenantId,
            objectId: props.objectId,
            secretPermissions: props.secretPermissions,
            certificatePermissions: props.certificatePermissions,
            keyPermissions: props.keyPermissions,
            storagePermissions: props.storagePermissions,
        });
        this.fqdn = "azurerm_key_vault_access_policy." + policy.friendlyUniqueId;
    }
}
exports.AccessPolicy = AccessPolicy;
_a = JSII_RTTI_SYMBOL_1;
AccessPolicy[_a] = { fqn: "@microsoft/terraform-cdk-constructs.azure_keyvault.AccessPolicy", version: "0.0.3-pre.12" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicG9saWN5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2F6dXJlLWtleXZhdWx0L2xpYi9wb2xpY3kudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxpR0FBNEY7QUFDNUYsMkNBQXVDO0FBa0R2QyxNQUFhLFlBQWEsU0FBUSxzQkFBUztJQUd6Qzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7T0E2Qkc7SUFDSCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXdCO1FBQ2hFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsTUFBTSxNQUFNLEdBQUcsSUFBSSwrQ0FBcUIsQ0FBQyxJQUFJLEVBQUUsUUFBUSxFQUFFO1lBQ3ZELFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLEVBQUU7WUFDL0IsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRO1lBQ3hCLFFBQVEsRUFBRSxLQUFLLENBQUMsUUFBUTtZQUN4QixpQkFBaUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCO1lBQzFDLHNCQUFzQixFQUFFLEtBQUssQ0FBQyxzQkFBc0I7WUFDcEQsY0FBYyxFQUFFLEtBQUssQ0FBQyxjQUFjO1lBQ3BDLGtCQUFrQixFQUFFLEtBQUssQ0FBQyxrQkFBa0I7U0FDN0MsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLElBQUksR0FBRyxrQ0FBa0MsR0FBRyxNQUFNLENBQUMsZ0JBQWdCLENBQUM7SUFDM0UsQ0FBQzs7QUEvQ0gsb0NBZ0RDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgS2V5VmF1bHRBY2Nlc3NQb2xpY3lBIH0gZnJvbSBcIkBjZGt0Zi9wcm92aWRlci1henVyZXJtL2xpYi9rZXktdmF1bHQtYWNjZXNzLXBvbGljeVwiO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSBcImNvbnN0cnVjdHNcIjtcbmltcG9ydCB7IFZhdWx0IH0gZnJvbSBcIi4vdmF1bHRcIjtcblxuZXhwb3J0IGludGVyZmFjZSBBY2Nlc3NQb2xpY3lQcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgQXp1cmUgS2V5IFZhdWx0IGluc3RhbmNlIG9yIGl0cyBpZGVudGlmaWVyLlxuICAgKi9cbiAgcmVhZG9ubHkga2V5VmF1bHRJZDogVmF1bHQ7XG5cbiAgLyoqXG4gICAqIFRoZSBBenVyZSBBY3RpdmUgRGlyZWN0b3J5IHRlbmFudCBJRCB3aGVyZSB0aGUgS2V5IFZhdWx0IGlzIGhvc3RlZC5cbiAgICogVGhpcyBpcyB0eXBpY2FsbHkgdGhlIGRpcmVjdG9yeSBJRCBvZiB5b3VyIEF6dXJlIEFELlxuICAgKi9cbiAgcmVhZG9ubHkgdGVuYW50SWQ6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIEF6dXJlIEFjdGl2ZSBEaXJlY3Rvcnkgb2JqZWN0IElEIGZvciB3aGljaCB0aGUgcG9saWN5IHdpbGwgYmUgYXBwbGllZC5cbiAgICogVGhpcyBjYW4gYmUgYSB1c2VyLCBncm91cCwgb3Igc2VydmljZSBwcmluY2lwYWwuXG4gICAqL1xuICByZWFkb25seSBvYmplY3RJZDogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgcGVybWlzc2lvbnMgdG8gc2VjcmV0cyBzdG9yZWQgaW4gdGhlIEtleSBWYXVsdC5cbiAgICogUG9zc2libGUgdmFsdWVzIG1pZ2h0IGluY2x1ZGU6ICdnZXQnLCAnbGlzdCcsICdzZXQnLCAnZGVsZXRlJywgZXRjLlxuICAgKiBJZiBub3QgcHJvdmlkZWQsIG5vIHNlY3JldCBwZXJtaXNzaW9ucyBhcmUgc2V0LlxuICAgKi9cbiAgcmVhZG9ubHkgc2VjcmV0UGVybWlzc2lvbnM/OiBzdHJpbmdbXTtcblxuICAvKipcbiAgICogVGhlIHBlcm1pc3Npb25zIHRvIGNlcnRpZmljYXRlcyBzdG9yZWQgaW4gdGhlIEtleSBWYXVsdC5cbiAgICogUG9zc2libGUgdmFsdWVzIG1pZ2h0IGluY2x1ZGU6ICdnZXQnLCAnbGlzdCcsICdjcmVhdGUnLCAndXBkYXRlJywgZXRjLlxuICAgKiBJZiBub3QgcHJvdmlkZWQsIG5vIGNlcnRpZmljYXRlIHBlcm1pc3Npb25zIGFyZSBzZXQuXG4gICAqL1xuICByZWFkb25seSBjZXJ0aWZpY2F0ZVBlcm1pc3Npb25zPzogc3RyaW5nW107XG5cbiAgLyoqXG4gICAqIFRoZSBwZXJtaXNzaW9ucyB0byBrZXlzIHN0b3JlZCBpbiB0aGUgS2V5IFZhdWx0LlxuICAgKiBQb3NzaWJsZSB2YWx1ZXMgbWlnaHQgaW5jbHVkZTogJ2dldCcsICdsaXN0JywgJ2NyZWF0ZScsICdzaWduJywgZXRjLlxuICAgKiBJZiBub3QgcHJvdmlkZWQsIG5vIGtleSBwZXJtaXNzaW9ucyBhcmUgc2V0LlxuICAgKi9cbiAgcmVhZG9ubHkga2V5UGVybWlzc2lvbnM/OiBzdHJpbmdbXTtcblxuICAvKipcbiAgICogVGhlIHBlcm1pc3Npb25zIHRvIHN0b3JhZ2UgYWNjb3VudHMgbGlua2VkIHRvIHRoZSBLZXkgVmF1bHQuXG4gICAqIFBvc3NpYmxlIHZhbHVlcyBtaWdodCBpbmNsdWRlOiAnZ2V0JywgJ2xpc3QnLCAnZGVsZXRlJywgJ3NldCcsIGV0Yy5cbiAgICogSWYgbm90IHByb3ZpZGVkLCBubyBzdG9yYWdlIHBlcm1pc3Npb25zIGFyZSBzZXQuXG4gICAqL1xuICByZWFkb25seSBzdG9yYWdlUGVybWlzc2lvbnM/OiBzdHJpbmdbXTtcbn1cblxuZXhwb3J0IGNsYXNzIEFjY2Vzc1BvbGljeSBleHRlbmRzIENvbnN0cnVjdCB7XG4gIHB1YmxpYyByZWFkb25seSBmcWRuOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIENvbnN0cnVjdHMgYSBuZXcgQWNjZXNzIFBvbGljeSBmb3IgQXp1cmUgS2V5IFZhdWx0LlxuICAgKlxuICAgKiBUaGlzIGNsYXNzIGlzIHJlc3BvbnNpYmxlIGZvciBzZXR0aW5nIHVwIGFjY2VzcyBwb2xpY2llcyB0aGF0IGRlZmluZSB3aGF0IG9wZXJhdGlvbnMgYW4gQXp1cmUgQUQgaWRlbnRpdHlcbiAgICogY2FuIHBlcmZvcm0gb24gdGhlIGtleXMsIHNlY3JldHMsIGNlcnRpZmljYXRlcywgYW5kIHN0b3JhZ2UgYWNjb3VudHMgd2l0aGluIGEgc3BlY2lmaWVkIEF6dXJlIEtleSBWYXVsdC5cbiAgICpcbiAgICogQHBhcmFtIHNjb3BlIC0gVGhlIHNjb3BlIGluIHdoaWNoIHRvIGRlZmluZSB0aGlzIGNvbnN0cnVjdCwgdXN1YWxseSByZXByZXNlbnRpbmcgdGhlIENsb3VkIERldmVsb3BtZW50IEtpdCAoQ0RLKSBzdGFjay5cbiAgICogQHBhcmFtIGlkIC0gVGhlIHVuaXF1ZSBpZGVudGlmaWVyIGZvciB0aGlzIGluc3RhbmNlIG9mIHRoZSBhY2Nlc3MgcG9saWN5LlxuICAgKiBAcGFyYW0gcHJvcHMgLSBUaGUgcHJvcGVydGllcyBmb3IgY3JlYXRpbmcgdGhlIGFjY2VzcyBwb2xpY3kgYXMgZGVmaW5lZCBpbiBBY2Nlc3NQb2xpY3lQcm9wcy4gVGhlc2UgaW5jbHVkZTpcbiAgICogICAgICAgICAgICAgICAgLSBga2V5VmF1bHRJZGA6IFRoZSBBenVyZSBLZXkgVmF1bHQgaWRlbnRpZmllciB3aGVyZSB0aGUgcG9saWN5IHdpbGwgYmUgc2V0LlxuICAgKiAgICAgICAgICAgICAgICAtIGB0ZW5hbnRJZGA6IFRoZSB0ZW5hbnQgSUQgb2YgdGhlIEF6dXJlIEFEIHRlbmFudCB3aGVyZSB0aGUgS2V5IFZhdWx0IGlzIGhvc3RlZC5cbiAgICogICAgICAgICAgICAgICAgLSBgb2JqZWN0SWRgOiBUaGUgb2JqZWN0IElEIG9mIHRoZSBBenVyZSBBRCBpZGVudGl0eSAodXNlciwgZ3JvdXAsIG9yIHNlcnZpY2UgcHJpbmNpcGFsKS5cbiAgICogICAgICAgICAgICAgICAgLSBgc2VjcmV0UGVybWlzc2lvbnNgOiBPcHRpb25hbCBsaXN0IG9mIHBlcm1pc3Npb25zIHRvIHNlY3JldHMgd2l0aGluIHRoZSBLZXkgVmF1bHQuXG4gICAqICAgICAgICAgICAgICAgIC0gYGNlcnRpZmljYXRlUGVybWlzc2lvbnNgOiBPcHRpb25hbCBsaXN0IG9mIHBlcm1pc3Npb25zIHRvIGNlcnRpZmljYXRlcyB3aXRoaW4gdGhlIEtleSBWYXVsdC5cbiAgICogICAgICAgICAgICAgICAgLSBga2V5UGVybWlzc2lvbnNgOiBPcHRpb25hbCBsaXN0IG9mIHBlcm1pc3Npb25zIHRvIGtleXMgd2l0aGluIHRoZSBLZXkgVmF1bHQuXG4gICAqICAgICAgICAgICAgICAgIC0gYHN0b3JhZ2VQZXJtaXNzaW9uc2A6IE9wdGlvbmFsIGxpc3Qgb2YgcGVybWlzc2lvbnMgdG8gc3RvcmFnZSBhY2NvdW50cyBsaW5rZWQgdG8gdGhlIEtleSBWYXVsdC5cbiAgICpcbiAgICogRXhhbXBsZSB1c2FnZTpcbiAgICogYGBgdHlwZXNjcmlwdFxuICAgKiBuZXcgQWNjZXNzUG9saWN5KHRoaXMsICdNeUFjY2Vzc1BvbGljeScsIHtcbiAgICogICBrZXlWYXVsdElkOiBteUtleVZhdWx0LFxuICAgKiAgIHRlbmFudElkOiAnbXktdGVuYW50LWlkJyxcbiAgICogICBvYmplY3RJZDogJ3VzZXItb2JqZWN0LWlkJyxcbiAgICogICBrZXlQZXJtaXNzaW9uczogWydnZXQnLCAnbGlzdCcsICd1cGRhdGUnXSxcbiAgICogICBzZWNyZXRQZXJtaXNzaW9uczogWydnZXQnXSxcbiAgICogICBjZXJ0aWZpY2F0ZVBlcm1pc3Npb25zOiBbJ2dldCcsICdsaXN0J10sXG4gICAqICAgc3RvcmFnZVBlcm1pc3Npb25zOiBbJ2dldCcsICdsaXN0J11cbiAgICogfSk7XG4gICAqIGBgYFxuICAgKi9cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEFjY2Vzc1BvbGljeVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIGNvbnN0IHBvbGljeSA9IG5ldyBLZXlWYXVsdEFjY2Vzc1BvbGljeUEodGhpcywgXCJwb2xpY3lcIiwge1xuICAgICAga2V5VmF1bHRJZDogcHJvcHMua2V5VmF1bHRJZC5pZCxcbiAgICAgIHRlbmFudElkOiBwcm9wcy50ZW5hbnRJZCxcbiAgICAgIG9iamVjdElkOiBwcm9wcy5vYmplY3RJZCxcbiAgICAgIHNlY3JldFBlcm1pc3Npb25zOiBwcm9wcy5zZWNyZXRQZXJtaXNzaW9ucyxcbiAgICAgIGNlcnRpZmljYXRlUGVybWlzc2lvbnM6IHByb3BzLmNlcnRpZmljYXRlUGVybWlzc2lvbnMsXG4gICAgICBrZXlQZXJtaXNzaW9uczogcHJvcHMua2V5UGVybWlzc2lvbnMsXG4gICAgICBzdG9yYWdlUGVybWlzc2lvbnM6IHByb3BzLnN0b3JhZ2VQZXJtaXNzaW9ucyxcbiAgICB9KTtcblxuICAgIHRoaXMuZnFkbiA9IFwiYXp1cmVybV9rZXlfdmF1bHRfYWNjZXNzX3BvbGljeS5cIiArIHBvbGljeS5mcmllbmRseVVuaXF1ZUlkO1xuICB9XG59XG4iXX0=