"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Secret = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const key_vault_secret_1 = require("@cdktf/provider-azurerm/lib/key-vault-secret");
const constructs_1 = require("constructs");
class Secret extends constructs_1.Construct {
    /**
     * Constructs a new Azure Key Vault Secret within a specified Key Vault.
     *
     * This class facilitates the creation and management of a secret, allowing sensitive information to be stored securely
     * and accessed as needed while maintaining confidentiality and control through defined access policies.
     *
     * @param scope - The scope in which to define this construct, typically representing the Cloud Development Kit (CDK) stack.
     * @param id - The unique identifier for this instance of the secret.
     * @param props - The properties for creating the secret as defined in SecretProps. These include:
     *                - `keyVaultId`: The ID of the Key Vault in which to store the secret.
     *                - `name`: The name of the secret.
     *                - `value`: The confidential data to be stored as the secret.
     *                - `expirationDate`: Optional. The expiration date of the secret.
     *                - `contentType`: Optional. A label hinting at the content type of the secret's value.
     *                - `accessPolicies`: Access policies that dictate permissions for the secret.
     *
     * Example usage:
     * ```typescript
     * new Secret(this, 'mySecret', {
     *   keyVaultId: myKeyVault,
     *   name: 'dbPassword',
     *   value: 'p@ssw0rd!',
     *   expirationDate: '2030-01-01T00:00:00Z',
     *   contentType: 'password',
     *   accessPolicies: [{
     *     objectId: '12345-user-object-id',
     *     permissions: ['get', 'list']
     *   }]
     * });
     * ```
     */
    constructor(scope, id, props) {
        super(scope, id);
        // Logic to add the secret to the provided keyVault instance
        // For example:
        const secret = new key_vault_secret_1.KeyVaultSecret(this, props.name, {
            keyVaultId: props.keyVaultId.id,
            name: props.name,
            value: props.value,
            contentType: props.contentType,
            expirationDate: props.expirationDate,
        });
        this.secretId = secret.id;
        // Accumulate all the fqdn values
        const dependencies = [];
        for (const policy of props.accessPolicies) {
            dependencies.push(policy.fqdn);
        }
        // Add dependency on all access policies
        secret.addOverride("depends_on", dependencies);
    }
}
exports.Secret = Secret;
_a = JSII_RTTI_SYMBOL_1;
Secret[_a] = { fqn: "@microsoft/terraform-cdk-constructs.azure_keyvault.Secret", version: "0.0.3-pre.12" };
//# sourceMappingURL=data:application/json;base64,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