"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cluster = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const kubernetes_cluster_1 = require("@cdktf/provider-azurerm/lib/kubernetes-cluster");
const lib_1 = require("../../core-azure/lib");
/**
 * Class representing the AKS cluster resource.
 */
class Cluster extends lib_1.AzureResource {
    /**
     * Represents an Azure Kubernetes Service (AKS) cluster resource in Azure.
     *
     * This class is responsible for the creation and management of an AKS cluster, allowing for the deployment and orchestration
     * of containerized applications using Kubernetes within the Azure cloud platform.
     *
     * @param scope - The scope in which to define this construct, typically representing the Cloud Development Kit (CDK) stack.
     * @param id - The unique identifier for this instance of the AKS cluster.
     * @param props - The properties required to configure the AKS cluster, as defined in the ClusterProps interface.
     *
     * Example usage:
     * ```typescript
     * new Cluster(this, 'MyAKSCluster', {
     *   name: 'example-cluster',
     *   location: 'East US',
     *   defaultNodePool: {
     *     vmSize: 'Standard_D2_v3',
     *     nodeCount: 3,
     *     type: 'VirtualMachineScaleSets'
     *   },
     *   resourceGroup: existingResourceGroup,
     *   tags: {
     *     environment: 'production'
     *   }
     * });
     * ```
     */
    constructor(scope, id, props) {
        super(scope, id);
        // Setup or reuse the provided resource group.
        this.resourceGroup = this.setupResourceGroup(props);
        // Create the AKS Cluster with the provided properties.
        const aks = new kubernetes_cluster_1.KubernetesCluster(this, "AKS", {
            name: props.name,
            location: props.location,
            resourceGroupName: this.resourceGroup.name,
            defaultNodePool: props.defaultNodePool,
            apiServerAuthorizedIpRanges: props.apiServerAuthorizedIpRanges,
            dnsPrefix: props.name,
            tags: props.tags,
            roleBasedAccessControlEnabled: true,
            azureActiveDirectoryRoleBasedAccessControl: props.azureActiveDirectoryRoleBasedAccessControl,
            identity: props.identity,
        });
        // Assign the AKS cluster ID for external reference.
        this.id = aks.id;
    }
}
exports.Cluster = Cluster;
_a = JSII_RTTI_SYMBOL_1;
Cluster[_a] = { fqn: "@microsoft/terraform-cdk-constructs.azure_kubernetes.Cluster", version: "0.0.3-pre.12" };
//# sourceMappingURL=data:application/json;base64,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