"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const log_analytics_workspace_1 = require("@cdktf/provider-azurerm/lib/log-analytics-workspace");
const provider_1 = require("@cdktf/provider-azurerm/lib/provider");
const resource_group_1 = require("@cdktf/provider-azurerm/lib/resource-group");
const cdktf_1 = require("cdktf");
const aks = require("..");
const testing_1 = require("../../testing");
const randomName_1 = require("../../util/randomName");
require("cdktf/lib/testing/adapters/jest");
describe("Example of deploying a Kubernetes Cluster", () => {
    let stack;
    let fullSynthResult;
    const streamOutput = process.env.STREAM_OUTPUT !== "false";
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "test");
        const randomName = (0, randomName_1.generateRandomName)(12);
        new provider_1.AzurermProvider(stack, "azureFeature", { features: {} });
        // Create a resource group
        const resourceGroup = new resource_group_1.ResourceGroup(stack, "rg", {
            name: `rg-${randomName}`,
            location: "southcentralus",
        });
        const logAnalyticsWorkspace = new log_analytics_workspace_1.LogAnalyticsWorkspace(stack, "log_analytics", {
            location: "southcentralus",
            name: `la-${randomName}`,
            resourceGroupName: resourceGroup.name,
        });
        const aksCluster = new aks.Cluster(stack, "testAksCluster", {
            name: "akstest",
            location: "southcentralus",
            resourceGroup: resourceGroup,
            //apiServerAuthorizedIpRanges: ["0.0.0.0"],
            defaultNodePool: {
                name: "default",
                nodeCount: 1,
                vmSize: "Standard_D2as_v4",
                upgradeSettings: {
                    maxSurge: "10%",
                },
            },
            identity: {
                type: "SystemAssigned",
            },
            azureActiveDirectoryRoleBasedAccessControl: {
                managed: true,
                azureRbacEnabled: true,
            },
        });
        //Diag Settings
        aksCluster.addDiagSettings({
            name: "diagsettings",
            logAnalyticsWorkspaceId: logAnalyticsWorkspace.id,
            metric: [
                {
                    category: "AllMetrics",
                },
            ],
        });
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    afterEach(() => {
        try {
            (0, testing_1.TerraformDestroy)(fullSynthResult, streamOutput);
        }
        catch (error) {
            console.error("Error during Terraform destroy:", error);
        }
    });
    it("check if stack can be deployed", () => {
        (0, testing_1.TerraformApplyAndCheckIdempotency)(fullSynthResult, streamOutput); // Set to true to stream output
    });
});
//# sourceMappingURL=data:application/json;base64,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