"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const provider_1 = require("@cdktf/provider-azurerm/lib/provider");
const cdktf_1 = require("cdktf");
const aks = require("..");
const testing_1 = require("../../testing");
require("cdktf/lib/testing/adapters/jest");
describe("Azure Kubernetes Cluster With Defaults", () => {
    let stack;
    let fullSynthResult;
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "test");
        new provider_1.AzurermProvider(stack, "azureFeature", { features: {} });
        new aks.Cluster(stack, "testAksCluster", {
            name: "akstest",
            location: "eastus",
            defaultNodePool: {
                name: "default",
                nodeCount: 1,
                vmSize: "Standard_B2s",
            },
            identity: {
                type: "SystemAssigned",
            },
        });
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    it("renders an Azure Kubernetes Cluster with defaults and checks snapshot", () => {
        expect(cdktf_1.Testing.synth(stack)).toMatchSnapshot(); // Compare the already prepared stack
    });
    it("check if the produced terraform configuration is valid", () => {
        expect(fullSynthResult).toBeValidTerraform(); // Use the saved result
    });
    it("check if this can be planned", () => {
        (0, testing_1.TerraformPlan)(fullSynthResult); // Use the saved result
    });
});
//# sourceMappingURL=data:application/json;base64,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