"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cluster = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const kusto_cluster_1 = require("@cdktf/provider-azurerm/lib/kusto-cluster");
const compute_specification_1 = require("./compute-specification");
const database_1 = require("./database");
const index_1 = require("../../core-azure/lib/index");
class Cluster extends index_1.AzureResource {
    /**
     * Represents a Kusto (Azure Data Explorer) cluster in Azure.
     *
     * This class is responsible for the creation and management of a Kusto Cluster, which is a highly scalable and secure
     * analytics service for ingesting, storing, and analyzing large volumes of data. The cluster supports various configurations
     * tailored to the needs of specific data workloads and security requirements.
     *
     * @param scope - The scope in which to define this construct, typically representing the Cloud Development Kit (CDK) stack.
     * @param id - The unique identifier for this instance of the cluster.
     * @param props - The properties required to configure the Kusto cluster, as defined in the ClusterProps interface.
     *
     * Example usage:
     * ```typescript
     * new Cluster(this, 'MyKustoCluster', {
     *   name: 'example-cluster',
     *   location: 'West US',
     *   resourceGroup: myResourceGroup,
     *   sku: { tier: 'Standard', name: 'D13_v2', capacity: 2 },
     *   tags: {
     *     project: 'Data Analytics'
     *   }
     * });
     * ```
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.resourceGroup = this.setupResourceGroup(props);
        /**
         * Define default values.
         */
        const sku = props.sku || compute_specification_1.ComputeSpecification.devtestExtraSmallDv2;
        const enableZones = props.enableZones || true;
        const defaults = {
            publicNetworkAccessEnabled: props.publicNetworkAccessEnabled || true,
            autoStopEnabled: props.autoStopEnabled || true,
            streamingIngestionEnabled: props.streamingIngestionEnabled || true,
            purgeEnabled: props.purgeEnabled || false,
            zones: enableZones ? sku.availibleZones : [],
            sku: {
                name: sku.skuName,
                capacity: props.capacity || 2,
            },
            identity: {
                type: "SystemAssigned",
                identityIds: [],
            },
        };
        /**
         * Create Kusto Cluster resource.
         */
        const azurermKustoCluster = new kusto_cluster_1.KustoCluster(this, "Kusto", {
            ...defaults,
            name: props.name,
            location: this.resourceGroup.location,
            resourceGroupName: this.resourceGroup.name,
            tags: props.tags,
        });
        if (props.identityType) {
            azurermKustoCluster.addOverride("identity", {
                type: props.identityType,
                identityIds: props.identityIds,
            });
        }
        if (props.minimumInstances && props.maximumInstances) {
            azurermKustoCluster.addOverride("minimum_instances", props.minimumInstances);
            azurermKustoCluster.addOverride("maximum_instances", props.maximumInstances);
        }
        this.id = azurermKustoCluster.id;
        this.name = azurermKustoCluster.name;
        this.uri = azurermKustoCluster.uri;
        this.kustoCluster = azurermKustoCluster;
        // Outputs
        // const cdktfTerraformOutputKustoId = new cdktf.TerraformOutput(
        //   this,
        //   "Kusto_id",
        //   {
        //     value: azurermKustoCluster.id,
        //   },
        // );
        // const cdktfTerraformOutputKustoUri = new cdktf.TerraformOutput(
        //   this,
        //   "Kusto_uri",
        //   {
        //     value: azurermKustoCluster.uri,
        //   },
        // );
        // const cdktfTerraformOutputDataIngestionUri = new cdktf.TerraformOutput(
        //   this,
        //   "Kusto_data_ingestion_uri",
        //   {
        //     value: azurermKustoCluster.dataIngestionUri,
        //   },
        // );
        // const cdktfTerraformOutputKustoIdentity = new cdktf.TerraformOutput(
        //   this,
        //   "Kusto_identity",
        //   {
        //     value: azurermKustoCluster.identity,
        //     sensitive: true,
        //   },
        // );
        /*This allows the Terraform resource name to match the original name. You can remove the call if you don't need them to match.*/
        // cdktfTerraformOutputKustoId.overrideLogicalId("Kusto_id");
        // cdktfTerraformOutputKustoUri.overrideLogicalId("Kusto_uri");
        // cdktfTerraformOutputDataIngestionUri.overrideLogicalId(
        //   "Kusto_data_ingestion_uri",
        // );
        // cdktfTerraformOutputKustoIdentity.overrideLogicalId("Kusto_identity");
    }
    /**
     * Adds a new database to the Azure Kusto Cluster.
     *
     * This method creates a database within the Azure Data Explorer (Kusto) cluster, defined by the properties provided.
     * A database in Kusto serves as a logical group to manage various tables and store data. It is essential for performing
     * data analytics and running queries. The database configuration can include settings like hot cache and soft delete periods,
     * which optimize query performance and manage data lifecycle according to specific requirements.
     *
     * @param databaseProps - The properties required to create the database. These properties should include:
     *                        - `kusto`: Reference to the Kusto cluster to which the database will be added.
     *                        - `name`: The name of the database, which must be unique within the cluster.
     *                        - `hotCachePeriod`: Optional. Specifies the duration that data should be kept in cache for faster query access.
     *                        - `softDeletePeriod`: Optional. Specifies the duration that data should be retained before it stops being accessible to queries.
     *                          Both the hot cache and soft delete periods should be specified in ISO 8601 duration format.
     *
     * @returns A `Database` object representing the newly created database within the Kusto cluster.
     *
     * Example usage:
     * ```typescript
     * const myDatabase = myCluster.addDatabase({
     *   kusto: myKustoCluster,
     *   name: 'OperationalData',
     *   hotCachePeriod: 'P14D', // 14 days
     *   softDeletePeriod: 'P365D' // 1 year
     * });
     * ```
     * This method facilitates the efficient setup and scaling of databases within an Azure Kusto cluster, allowing
     * for complex data analytics operations across large datasets.
     */
    addDatabase(databaseProps) {
        return new database_1.Database(this, databaseProps.name, {
            kustoCluster: this.kustoCluster,
            name: databaseProps.name,
            hotCachePeriod: databaseProps.hotCachePeriod,
            softDeletePeriod: databaseProps.softDeletePeriod,
        });
    }
}
exports.Cluster = Cluster;
_a = JSII_RTTI_SYMBOL_1;
Cluster[_a] = { fqn: "@microsoft/terraform-cdk-constructs.azure_kusto.Cluster", version: "0.0.3-pre.12" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2x1c3Rlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9henVyZS1rdXN0by9saWIvY2x1c3Rlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDZFQUF5RTtBQUd6RSxtRUFHaUM7QUFDakMseUNBQXFEO0FBQ3JELHNEQUEyRDtBQXdFM0QsTUFBYSxPQUFRLFNBQVEscUJBQWE7SUFReEM7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O09BdUJHO0lBQ0gsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFtQjtRQUMzRCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO1FBQ25CLElBQUksQ0FBQyxhQUFhLEdBQUcsSUFBSSxDQUFDLGtCQUFrQixDQUFDLEtBQUssQ0FBQyxDQUFDO1FBRXBEOztXQUVHO1FBQ0gsTUFBTSxHQUFHLEdBQUcsS0FBSyxDQUFDLEdBQUcsSUFBSSw0Q0FBb0IsQ0FBQyxvQkFBb0IsQ0FBQztRQUNuRSxNQUFNLFdBQVcsR0FBRyxLQUFLLENBQUMsV0FBVyxJQUFJLElBQUksQ0FBQztRQUU5QyxNQUFNLFFBQVEsR0FBRztZQUNmLDBCQUEwQixFQUFFLEtBQUssQ0FBQywwQkFBMEIsSUFBSSxJQUFJO1lBQ3BFLGVBQWUsRUFBRSxLQUFLLENBQUMsZUFBZSxJQUFJLElBQUk7WUFDOUMseUJBQXlCLEVBQUUsS0FBSyxDQUFDLHlCQUF5QixJQUFJLElBQUk7WUFDbEUsWUFBWSxFQUFFLEtBQUssQ0FBQyxZQUFZLElBQUksS0FBSztZQUN6QyxLQUFLLEVBQUUsV0FBVyxDQUFDLENBQUMsQ0FBQyxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxFQUFFO1lBQzVDLEdBQUcsRUFBRTtnQkFDSCxJQUFJLEVBQUUsR0FBRyxDQUFDLE9BQU87Z0JBQ2pCLFFBQVEsRUFBRSxLQUFLLENBQUMsUUFBUSxJQUFJLENBQUM7YUFDOUI7WUFDRCxRQUFRLEVBQUU7Z0JBQ1IsSUFBSSxFQUFFLGdCQUFnQjtnQkFDdEIsV0FBVyxFQUFFLEVBQUU7YUFDaEI7U0FDRixDQUFDO1FBRUY7O1dBRUc7UUFDSCxNQUFNLG1CQUFtQixHQUFHLElBQUksNEJBQVksQ0FBQyxJQUFJLEVBQUUsT0FBTyxFQUFFO1lBQzFELEdBQUcsUUFBUTtZQUNYLElBQUksRUFBRSxLQUFLLENBQUMsSUFBSTtZQUNoQixRQUFRLEVBQUUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxRQUFRO1lBQ3JDLGlCQUFpQixFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsSUFBSTtZQUMxQyxJQUFJLEVBQUUsS0FBSyxDQUFDLElBQUk7U0FDakIsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxLQUFLLENBQUMsWUFBWSxFQUFFO1lBQ3RCLG1CQUFtQixDQUFDLFdBQVcsQ0FBQyxVQUFVLEVBQUU7Z0JBQzFDLElBQUksRUFBRSxLQUFLLENBQUMsWUFBWTtnQkFDeEIsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO2FBQy9CLENBQUMsQ0FBQztTQUNKO1FBRUQsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLElBQUksS0FBSyxDQUFDLGdCQUFnQixFQUFFO1lBQ3BELG1CQUFtQixDQUFDLFdBQVcsQ0FDN0IsbUJBQW1CLEVBQ25CLEtBQUssQ0FBQyxnQkFBZ0IsQ0FDdkIsQ0FBQztZQUNGLG1CQUFtQixDQUFDLFdBQVcsQ0FDN0IsbUJBQW1CLEVBQ25CLEtBQUssQ0FBQyxnQkFBZ0IsQ0FDdkIsQ0FBQztTQUNIO1FBRUQsSUFBSSxDQUFDLEVBQUUsR0FBRyxtQkFBbUIsQ0FBQyxFQUFFLENBQUM7UUFDakMsSUFBSSxDQUFDLElBQUksR0FBRyxtQkFBbUIsQ0FBQyxJQUFJLENBQUM7UUFDckMsSUFBSSxDQUFDLEdBQUcsR0FBRyxtQkFBbUIsQ0FBQyxHQUFHLENBQUM7UUFDbkMsSUFBSSxDQUFDLFlBQVksR0FBRyxtQkFBbUIsQ0FBQztRQUV4QyxVQUFVO1FBQ1YsaUVBQWlFO1FBQ2pFLFVBQVU7UUFDVixnQkFBZ0I7UUFDaEIsTUFBTTtRQUNOLHFDQUFxQztRQUNyQyxPQUFPO1FBQ1AsS0FBSztRQUNMLGtFQUFrRTtRQUNsRSxVQUFVO1FBQ1YsaUJBQWlCO1FBQ2pCLE1BQU07UUFDTixzQ0FBc0M7UUFDdEMsT0FBTztRQUNQLEtBQUs7UUFDTCwwRUFBMEU7UUFDMUUsVUFBVTtRQUNWLGdDQUFnQztRQUNoQyxNQUFNO1FBQ04sbURBQW1EO1FBQ25ELE9BQU87UUFDUCxLQUFLO1FBQ0wsdUVBQXVFO1FBQ3ZFLFVBQVU7UUFDVixzQkFBc0I7UUFDdEIsTUFBTTtRQUNOLDJDQUEyQztRQUMzQyx1QkFBdUI7UUFDdkIsT0FBTztRQUNQLEtBQUs7UUFFTCxnSUFBZ0k7UUFDaEksNkRBQTZEO1FBQzdELCtEQUErRDtRQUMvRCwwREFBMEQ7UUFDMUQsZ0NBQWdDO1FBQ2hDLEtBQUs7UUFDTCx5RUFBeUU7SUFDM0UsQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O09BNEJHO0lBQ0ksV0FBVyxDQUFDLGFBQTRCO1FBQzdDLE9BQU8sSUFBSSxtQkFBUSxDQUFDLElBQUksRUFBRSxhQUFhLENBQUMsSUFBSSxFQUFFO1lBQzVDLFlBQVksRUFBRSxJQUFJLENBQUMsWUFBWTtZQUMvQixJQUFJLEVBQUUsYUFBYSxDQUFDLElBQUk7WUFDeEIsY0FBYyxFQUFFLGFBQWEsQ0FBQyxjQUFjO1lBQzVDLGdCQUFnQixFQUFFLGFBQWEsQ0FBQyxnQkFBZ0I7U0FDakQsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUF6S0gsMEJBMEtDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgS3VzdG9DbHVzdGVyIH0gZnJvbSBcIkBjZGt0Zi9wcm92aWRlci1henVyZXJtL2xpYi9rdXN0by1jbHVzdGVyXCI7XG5pbXBvcnQgeyBSZXNvdXJjZUdyb3VwIH0gZnJvbSBcIkBjZGt0Zi9wcm92aWRlci1henVyZXJtL2xpYi9yZXNvdXJjZS1ncm91cFwiO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSBcImNvbnN0cnVjdHNcIjtcbmltcG9ydCB7XG4gIENvbXB1dGVTcGVjaWZpY2F0aW9uLFxuICBJQ29tcHV0ZVNwZWNpZmljYXRpb24sXG59IGZyb20gXCIuL2NvbXB1dGUtc3BlY2lmaWNhdGlvblwiO1xuaW1wb3J0IHsgRGF0YWJhc2UsIERhdGFiYXNlUHJvcHMgfSBmcm9tIFwiLi9kYXRhYmFzZVwiO1xuaW1wb3J0IHsgQXp1cmVSZXNvdXJjZSB9IGZyb20gXCIuLi8uLi9jb3JlLWF6dXJlL2xpYi9pbmRleFwiO1xuXG5leHBvcnQgaW50ZXJmYWNlIENsdXN0ZXJQcm9wcyB7XG4gIC8qKlxuICAgKiBBbiBvcHRpb25hbCByZWZlcmVuY2UgdG8gdGhlIHJlc291cmNlIGdyb3VwIGluIHdoaWNoIHRvIGRlcGxveSB0aGUgS3VzdG8gQ2x1c3Rlci5cbiAgICogSWYgbm90IHByb3ZpZGVkLCB0aGUgS3VzdG8gQ2x1c3RlciB3aWxsIGJlIGRlcGxveWVkIGluIHRoZSBkZWZhdWx0IHJlc291cmNlIGdyb3VwLlxuICAgKi9cbiAgcmVhZG9ubHkgcmVzb3VyY2VHcm91cD86IFJlc291cmNlR3JvdXA7XG4gIC8qKlxuICAgKiBUaGUgbmFtZSBvZiB0aGUgS3VzdG8gQ2x1c3RlciB0byBjcmVhdGUuXG4gICAqIE9ubHkgNC0yMiBsb3dlcmNhc2UgYWxwaGFudW1lcmljIGNoYXJhY3RlcnMgYWxsb3dlZCwgc3RhcnRpbmcgd2l0aCBhIGxldHRlci5cbiAgICovXG4gIHJlYWRvbmx5IG5hbWU6IHN0cmluZztcbiAgLyoqXG4gICAqIFRoZSBTS1Ugb2YgdGhlIEt1c3RvIENsdXN0ZXIuIEFsbCB0aGUgYWxsb3dlZCB2YWx1ZXMgYXJlIGRlZmluZWQgaW4gdGhlIENvbXB1dGVTcGVjaWZpY2F0aW9uIGNsYXNzLlxuICAgKiBAZGVmYXVsdCBkZXZ0ZXN0RXh0cmFTbWFsbER2MlxuICAgKi9cbiAgcmVhZG9ubHkgc2t1PzogSUNvbXB1dGVTcGVjaWZpY2F0aW9uO1xuICAvKipcbiAgICogVGhlIG5vZGUgY291bnQgZm9yIHRoZSBjbHVzdGVyLlxuICAgKiBAZGVmYXVsdCAyXG4gICAqL1xuICByZWFkb25seSBjYXBhY2l0eT86IG51bWJlcjtcbiAgLyoqXG4gICAqIFRoZSB0eXBlIG9mIE1hbmFnZWQgU2VydmljZSBJZGVudGl0eS5cbiAgICogQGRlZmF1bHQgXCJTeXN0ZW1Bc3NpZ25lZFwiXG4gICAqL1xuICByZWFkb25seSBpZGVudGl0eVR5cGU/OiBzdHJpbmc7XG4gIC8qKlxuICAgKiBBIGxpc3Qgb2YgVXNlciBBc3NpZ25lZCBNYW5hZ2VkIElkZW50aXR5IElEcyB0byBiZSBhc3NpZ25lZCB0byB0aGlzIEt1c3RvIENsdXN0ZXIuXG4gICAqL1xuICByZWFkb25seSBpZGVudGl0eUlkcz86IHN0cmluZ1tdO1xuICAvKipcbiAgICogSXMgdGhlIHB1YmxpYyBuZXR3b3JrIGFjY2VzcyBlbmFibGVkP1xuICAgKiBAZGVmYXVsdCB0cnVlXG4gICAqL1xuICByZWFkb25seSBwdWJsaWNOZXR3b3JrQWNjZXNzRW5hYmxlZD86IGJvb2xlYW47XG4gIC8qKlxuICAgKiBTcGVjaWZpZXMgaWYgdGhlIGNsdXN0ZXIgY291bGQgYmUgYXV0b21hdGljYWxseSBzdG9wcGVkLlxuICAgKiAoZHVlIHRvIGxhY2sgb2YgZGF0YSBvciBubyBhY3Rpdml0eSBmb3IgbWFueSBkYXlzKS5cbiAgICogQGRlZmF1bHQgdHJ1ZVxuICAgKi9cbiAgcmVhZG9ubHkgYXV0b1N0b3BFbmFibGVkPzogYm9vbGVhbjtcbiAgLyoqXG4gICAqIFNwZWNpZmllcyBpZiB0aGUgc3RyZWFtaW5nIGluZ2VzdCBpcyBlbmFibGVkLlxuICAgKiBAZGVmYXVsdCB0cnVlXG4gICAqL1xuICByZWFkb25seSBzdHJlYW1pbmdJbmdlc3Rpb25FbmFibGVkPzogYm9vbGVhbjtcbiAgLyoqXG4gICAqIFNwZWNpZmllcyBpZiB0aGUgcHVyZ2Ugb3BlcmF0aW9ucyBhcmUgZW5hYmxlZC5cbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IHB1cmdlRW5hYmxlZD86IGJvb2xlYW47XG4gIC8qKlxuICAgKiBTcGVjaWZpZXMgaWYgdGhlIHB1cmdlIG9wZXJhdGlvbnMgYXJlIGVuYWJsZWQuIEJhc2VkIG9uIHRoZSBTS1UsIHRoZSBudW1iZXIgb2Ygem9uZXMgYWxsb3dlZCBhcmUgZGlmZmVyZW50LlxuICAgKiBAZGVmYXVsdCB0cnVlXG4gICAqL1xuICByZWFkb25seSBlbmFibGVab25lcz86IGJvb2xlYW47XG4gIC8qKlxuICAgKiBUaGUgbWluaW11bSBudW1iZXIgb2YgYWxsb3dlZCBpbnN0YW5jZXMuIE11c3QgYmV0d2VlbiAwIGFuZCAxMDAwLlxuICAgKi9cbiAgcmVhZG9ubHkgbWluaW11bUluc3RhbmNlcz86IG51bWJlcjtcbiAgLyoqXG4gICAqIFRoZSBtYXhpbXVtIG51bWJlciBvZiBhbGxvd2VkIGluc3RhbmNlcy4gTXVzdCBiZXR3ZWVuIDAgYW5kIDEwMDAuXG4gICAqL1xuICByZWFkb25seSBtYXhpbXVtSW5zdGFuY2VzPzogbnVtYmVyO1xuICAvKipcbiAgICogQSBtYXBwaW5nIG9mIHRhZ3MgdG8gYXNzaWduIHRvIHRoZSBLdXN0by5cbiAgICovXG4gIHJlYWRvbmx5IHRhZ3M/OiB7IFtrZXk6IHN0cmluZ106IHN0cmluZyB9O1xufVxuXG5leHBvcnQgY2xhc3MgQ2x1c3RlciBleHRlbmRzIEF6dXJlUmVzb3VyY2Uge1xuICByZWFkb25seSBwcm9wczogQ2x1c3RlclByb3BzO1xuICBwdWJsaWMga3VzdG9DbHVzdGVyOiBLdXN0b0NsdXN0ZXI7XG4gIHB1YmxpYyBpZDogc3RyaW5nO1xuICBwdWJsaWMgcmVzb3VyY2VHcm91cDogUmVzb3VyY2VHcm91cDtcbiAgcHVibGljIG5hbWU6IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IHVyaTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBSZXByZXNlbnRzIGEgS3VzdG8gKEF6dXJlIERhdGEgRXhwbG9yZXIpIGNsdXN0ZXIgaW4gQXp1cmUuXG4gICAqXG4gICAqIFRoaXMgY2xhc3MgaXMgcmVzcG9uc2libGUgZm9yIHRoZSBjcmVhdGlvbiBhbmQgbWFuYWdlbWVudCBvZiBhIEt1c3RvIENsdXN0ZXIsIHdoaWNoIGlzIGEgaGlnaGx5IHNjYWxhYmxlIGFuZCBzZWN1cmVcbiAgICogYW5hbHl0aWNzIHNlcnZpY2UgZm9yIGluZ2VzdGluZywgc3RvcmluZywgYW5kIGFuYWx5emluZyBsYXJnZSB2b2x1bWVzIG9mIGRhdGEuIFRoZSBjbHVzdGVyIHN1cHBvcnRzIHZhcmlvdXMgY29uZmlndXJhdGlvbnNcbiAgICogdGFpbG9yZWQgdG8gdGhlIG5lZWRzIG9mIHNwZWNpZmljIGRhdGEgd29ya2xvYWRzIGFuZCBzZWN1cml0eSByZXF1aXJlbWVudHMuXG4gICAqXG4gICAqIEBwYXJhbSBzY29wZSAtIFRoZSBzY29wZSBpbiB3aGljaCB0byBkZWZpbmUgdGhpcyBjb25zdHJ1Y3QsIHR5cGljYWxseSByZXByZXNlbnRpbmcgdGhlIENsb3VkIERldmVsb3BtZW50IEtpdCAoQ0RLKSBzdGFjay5cbiAgICogQHBhcmFtIGlkIC0gVGhlIHVuaXF1ZSBpZGVudGlmaWVyIGZvciB0aGlzIGluc3RhbmNlIG9mIHRoZSBjbHVzdGVyLlxuICAgKiBAcGFyYW0gcHJvcHMgLSBUaGUgcHJvcGVydGllcyByZXF1aXJlZCB0byBjb25maWd1cmUgdGhlIEt1c3RvIGNsdXN0ZXIsIGFzIGRlZmluZWQgaW4gdGhlIENsdXN0ZXJQcm9wcyBpbnRlcmZhY2UuXG4gICAqXG4gICAqIEV4YW1wbGUgdXNhZ2U6XG4gICAqIGBgYHR5cGVzY3JpcHRcbiAgICogbmV3IENsdXN0ZXIodGhpcywgJ015S3VzdG9DbHVzdGVyJywge1xuICAgKiAgIG5hbWU6ICdleGFtcGxlLWNsdXN0ZXInLFxuICAgKiAgIGxvY2F0aW9uOiAnV2VzdCBVUycsXG4gICAqICAgcmVzb3VyY2VHcm91cDogbXlSZXNvdXJjZUdyb3VwLFxuICAgKiAgIHNrdTogeyB0aWVyOiAnU3RhbmRhcmQnLCBuYW1lOiAnRDEzX3YyJywgY2FwYWNpdHk6IDIgfSxcbiAgICogICB0YWdzOiB7XG4gICAqICAgICBwcm9qZWN0OiAnRGF0YSBBbmFseXRpY3MnXG4gICAqICAgfVxuICAgKiB9KTtcbiAgICogYGBgXG4gICAqL1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ2x1c3RlclByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIHRoaXMucHJvcHMgPSBwcm9wcztcbiAgICB0aGlzLnJlc291cmNlR3JvdXAgPSB0aGlzLnNldHVwUmVzb3VyY2VHcm91cChwcm9wcyk7XG5cbiAgICAvKipcbiAgICAgKiBEZWZpbmUgZGVmYXVsdCB2YWx1ZXMuXG4gICAgICovXG4gICAgY29uc3Qgc2t1ID0gcHJvcHMuc2t1IHx8IENvbXB1dGVTcGVjaWZpY2F0aW9uLmRldnRlc3RFeHRyYVNtYWxsRHYyO1xuICAgIGNvbnN0IGVuYWJsZVpvbmVzID0gcHJvcHMuZW5hYmxlWm9uZXMgfHwgdHJ1ZTtcblxuICAgIGNvbnN0IGRlZmF1bHRzID0ge1xuICAgICAgcHVibGljTmV0d29ya0FjY2Vzc0VuYWJsZWQ6IHByb3BzLnB1YmxpY05ldHdvcmtBY2Nlc3NFbmFibGVkIHx8IHRydWUsXG4gICAgICBhdXRvU3RvcEVuYWJsZWQ6IHByb3BzLmF1dG9TdG9wRW5hYmxlZCB8fCB0cnVlLFxuICAgICAgc3RyZWFtaW5nSW5nZXN0aW9uRW5hYmxlZDogcHJvcHMuc3RyZWFtaW5nSW5nZXN0aW9uRW5hYmxlZCB8fCB0cnVlLFxuICAgICAgcHVyZ2VFbmFibGVkOiBwcm9wcy5wdXJnZUVuYWJsZWQgfHwgZmFsc2UsXG4gICAgICB6b25lczogZW5hYmxlWm9uZXMgPyBza3UuYXZhaWxpYmxlWm9uZXMgOiBbXSxcbiAgICAgIHNrdToge1xuICAgICAgICBuYW1lOiBza3Uuc2t1TmFtZSxcbiAgICAgICAgY2FwYWNpdHk6IHByb3BzLmNhcGFjaXR5IHx8IDIsXG4gICAgICB9LFxuICAgICAgaWRlbnRpdHk6IHtcbiAgICAgICAgdHlwZTogXCJTeXN0ZW1Bc3NpZ25lZFwiLFxuICAgICAgICBpZGVudGl0eUlkczogW10sXG4gICAgICB9LFxuICAgIH07XG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgS3VzdG8gQ2x1c3RlciByZXNvdXJjZS5cbiAgICAgKi9cbiAgICBjb25zdCBhenVyZXJtS3VzdG9DbHVzdGVyID0gbmV3IEt1c3RvQ2x1c3Rlcih0aGlzLCBcIkt1c3RvXCIsIHtcbiAgICAgIC4uLmRlZmF1bHRzLFxuICAgICAgbmFtZTogcHJvcHMubmFtZSxcbiAgICAgIGxvY2F0aW9uOiB0aGlzLnJlc291cmNlR3JvdXAubG9jYXRpb24sXG4gICAgICByZXNvdXJjZUdyb3VwTmFtZTogdGhpcy5yZXNvdXJjZUdyb3VwLm5hbWUsXG4gICAgICB0YWdzOiBwcm9wcy50YWdzLFxuICAgIH0pO1xuICAgIGlmIChwcm9wcy5pZGVudGl0eVR5cGUpIHtcbiAgICAgIGF6dXJlcm1LdXN0b0NsdXN0ZXIuYWRkT3ZlcnJpZGUoXCJpZGVudGl0eVwiLCB7XG4gICAgICAgIHR5cGU6IHByb3BzLmlkZW50aXR5VHlwZSxcbiAgICAgICAgaWRlbnRpdHlJZHM6IHByb3BzLmlkZW50aXR5SWRzLFxuICAgICAgfSk7XG4gICAgfVxuXG4gICAgaWYgKHByb3BzLm1pbmltdW1JbnN0YW5jZXMgJiYgcHJvcHMubWF4aW11bUluc3RhbmNlcykge1xuICAgICAgYXp1cmVybUt1c3RvQ2x1c3Rlci5hZGRPdmVycmlkZShcbiAgICAgICAgXCJtaW5pbXVtX2luc3RhbmNlc1wiLFxuICAgICAgICBwcm9wcy5taW5pbXVtSW5zdGFuY2VzLFxuICAgICAgKTtcbiAgICAgIGF6dXJlcm1LdXN0b0NsdXN0ZXIuYWRkT3ZlcnJpZGUoXG4gICAgICAgIFwibWF4aW11bV9pbnN0YW5jZXNcIixcbiAgICAgICAgcHJvcHMubWF4aW11bUluc3RhbmNlcyxcbiAgICAgICk7XG4gICAgfVxuXG4gICAgdGhpcy5pZCA9IGF6dXJlcm1LdXN0b0NsdXN0ZXIuaWQ7XG4gICAgdGhpcy5uYW1lID0gYXp1cmVybUt1c3RvQ2x1c3Rlci5uYW1lO1xuICAgIHRoaXMudXJpID0gYXp1cmVybUt1c3RvQ2x1c3Rlci51cmk7XG4gICAgdGhpcy5rdXN0b0NsdXN0ZXIgPSBhenVyZXJtS3VzdG9DbHVzdGVyO1xuXG4gICAgLy8gT3V0cHV0c1xuICAgIC8vIGNvbnN0IGNka3RmVGVycmFmb3JtT3V0cHV0S3VzdG9JZCA9IG5ldyBjZGt0Zi5UZXJyYWZvcm1PdXRwdXQoXG4gICAgLy8gICB0aGlzLFxuICAgIC8vICAgXCJLdXN0b19pZFwiLFxuICAgIC8vICAge1xuICAgIC8vICAgICB2YWx1ZTogYXp1cmVybUt1c3RvQ2x1c3Rlci5pZCxcbiAgICAvLyAgIH0sXG4gICAgLy8gKTtcbiAgICAvLyBjb25zdCBjZGt0ZlRlcnJhZm9ybU91dHB1dEt1c3RvVXJpID0gbmV3IGNka3RmLlRlcnJhZm9ybU91dHB1dChcbiAgICAvLyAgIHRoaXMsXG4gICAgLy8gICBcIkt1c3RvX3VyaVwiLFxuICAgIC8vICAge1xuICAgIC8vICAgICB2YWx1ZTogYXp1cmVybUt1c3RvQ2x1c3Rlci51cmksXG4gICAgLy8gICB9LFxuICAgIC8vICk7XG4gICAgLy8gY29uc3QgY2RrdGZUZXJyYWZvcm1PdXRwdXREYXRhSW5nZXN0aW9uVXJpID0gbmV3IGNka3RmLlRlcnJhZm9ybU91dHB1dChcbiAgICAvLyAgIHRoaXMsXG4gICAgLy8gICBcIkt1c3RvX2RhdGFfaW5nZXN0aW9uX3VyaVwiLFxuICAgIC8vICAge1xuICAgIC8vICAgICB2YWx1ZTogYXp1cmVybUt1c3RvQ2x1c3Rlci5kYXRhSW5nZXN0aW9uVXJpLFxuICAgIC8vICAgfSxcbiAgICAvLyApO1xuICAgIC8vIGNvbnN0IGNka3RmVGVycmFmb3JtT3V0cHV0S3VzdG9JZGVudGl0eSA9IG5ldyBjZGt0Zi5UZXJyYWZvcm1PdXRwdXQoXG4gICAgLy8gICB0aGlzLFxuICAgIC8vICAgXCJLdXN0b19pZGVudGl0eVwiLFxuICAgIC8vICAge1xuICAgIC8vICAgICB2YWx1ZTogYXp1cmVybUt1c3RvQ2x1c3Rlci5pZGVudGl0eSxcbiAgICAvLyAgICAgc2Vuc2l0aXZlOiB0cnVlLFxuICAgIC8vICAgfSxcbiAgICAvLyApO1xuXG4gICAgLypUaGlzIGFsbG93cyB0aGUgVGVycmFmb3JtIHJlc291cmNlIG5hbWUgdG8gbWF0Y2ggdGhlIG9yaWdpbmFsIG5hbWUuIFlvdSBjYW4gcmVtb3ZlIHRoZSBjYWxsIGlmIHlvdSBkb24ndCBuZWVkIHRoZW0gdG8gbWF0Y2guKi9cbiAgICAvLyBjZGt0ZlRlcnJhZm9ybU91dHB1dEt1c3RvSWQub3ZlcnJpZGVMb2dpY2FsSWQoXCJLdXN0b19pZFwiKTtcbiAgICAvLyBjZGt0ZlRlcnJhZm9ybU91dHB1dEt1c3RvVXJpLm92ZXJyaWRlTG9naWNhbElkKFwiS3VzdG9fdXJpXCIpO1xuICAgIC8vIGNka3RmVGVycmFmb3JtT3V0cHV0RGF0YUluZ2VzdGlvblVyaS5vdmVycmlkZUxvZ2ljYWxJZChcbiAgICAvLyAgIFwiS3VzdG9fZGF0YV9pbmdlc3Rpb25fdXJpXCIsXG4gICAgLy8gKTtcbiAgICAvLyBjZGt0ZlRlcnJhZm9ybU91dHB1dEt1c3RvSWRlbnRpdHkub3ZlcnJpZGVMb2dpY2FsSWQoXCJLdXN0b19pZGVudGl0eVwiKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgbmV3IGRhdGFiYXNlIHRvIHRoZSBBenVyZSBLdXN0byBDbHVzdGVyLlxuICAgKlxuICAgKiBUaGlzIG1ldGhvZCBjcmVhdGVzIGEgZGF0YWJhc2Ugd2l0aGluIHRoZSBBenVyZSBEYXRhIEV4cGxvcmVyIChLdXN0bykgY2x1c3RlciwgZGVmaW5lZCBieSB0aGUgcHJvcGVydGllcyBwcm92aWRlZC5cbiAgICogQSBkYXRhYmFzZSBpbiBLdXN0byBzZXJ2ZXMgYXMgYSBsb2dpY2FsIGdyb3VwIHRvIG1hbmFnZSB2YXJpb3VzIHRhYmxlcyBhbmQgc3RvcmUgZGF0YS4gSXQgaXMgZXNzZW50aWFsIGZvciBwZXJmb3JtaW5nXG4gICAqIGRhdGEgYW5hbHl0aWNzIGFuZCBydW5uaW5nIHF1ZXJpZXMuIFRoZSBkYXRhYmFzZSBjb25maWd1cmF0aW9uIGNhbiBpbmNsdWRlIHNldHRpbmdzIGxpa2UgaG90IGNhY2hlIGFuZCBzb2Z0IGRlbGV0ZSBwZXJpb2RzLFxuICAgKiB3aGljaCBvcHRpbWl6ZSBxdWVyeSBwZXJmb3JtYW5jZSBhbmQgbWFuYWdlIGRhdGEgbGlmZWN5Y2xlIGFjY29yZGluZyB0byBzcGVjaWZpYyByZXF1aXJlbWVudHMuXG4gICAqXG4gICAqIEBwYXJhbSBkYXRhYmFzZVByb3BzIC0gVGhlIHByb3BlcnRpZXMgcmVxdWlyZWQgdG8gY3JlYXRlIHRoZSBkYXRhYmFzZS4gVGhlc2UgcHJvcGVydGllcyBzaG91bGQgaW5jbHVkZTpcbiAgICogICAgICAgICAgICAgICAgICAgICAgICAtIGBrdXN0b2A6IFJlZmVyZW5jZSB0byB0aGUgS3VzdG8gY2x1c3RlciB0byB3aGljaCB0aGUgZGF0YWJhc2Ugd2lsbCBiZSBhZGRlZC5cbiAgICogICAgICAgICAgICAgICAgICAgICAgICAtIGBuYW1lYDogVGhlIG5hbWUgb2YgdGhlIGRhdGFiYXNlLCB3aGljaCBtdXN0IGJlIHVuaXF1ZSB3aXRoaW4gdGhlIGNsdXN0ZXIuXG4gICAqICAgICAgICAgICAgICAgICAgICAgICAgLSBgaG90Q2FjaGVQZXJpb2RgOiBPcHRpb25hbC4gU3BlY2lmaWVzIHRoZSBkdXJhdGlvbiB0aGF0IGRhdGEgc2hvdWxkIGJlIGtlcHQgaW4gY2FjaGUgZm9yIGZhc3RlciBxdWVyeSBhY2Nlc3MuXG4gICAqICAgICAgICAgICAgICAgICAgICAgICAgLSBgc29mdERlbGV0ZVBlcmlvZGA6IE9wdGlvbmFsLiBTcGVjaWZpZXMgdGhlIGR1cmF0aW9uIHRoYXQgZGF0YSBzaG91bGQgYmUgcmV0YWluZWQgYmVmb3JlIGl0IHN0b3BzIGJlaW5nIGFjY2Vzc2libGUgdG8gcXVlcmllcy5cbiAgICogICAgICAgICAgICAgICAgICAgICAgICAgIEJvdGggdGhlIGhvdCBjYWNoZSBhbmQgc29mdCBkZWxldGUgcGVyaW9kcyBzaG91bGQgYmUgc3BlY2lmaWVkIGluIElTTyA4NjAxIGR1cmF0aW9uIGZvcm1hdC5cbiAgICpcbiAgICogQHJldHVybnMgQSBgRGF0YWJhc2VgIG9iamVjdCByZXByZXNlbnRpbmcgdGhlIG5ld2x5IGNyZWF0ZWQgZGF0YWJhc2Ugd2l0aGluIHRoZSBLdXN0byBjbHVzdGVyLlxuICAgKlxuICAgKiBFeGFtcGxlIHVzYWdlOlxuICAgKiBgYGB0eXBlc2NyaXB0XG4gICAqIGNvbnN0IG15RGF0YWJhc2UgPSBteUNsdXN0ZXIuYWRkRGF0YWJhc2Uoe1xuICAgKiAgIGt1c3RvOiBteUt1c3RvQ2x1c3RlcixcbiAgICogICBuYW1lOiAnT3BlcmF0aW9uYWxEYXRhJyxcbiAgICogICBob3RDYWNoZVBlcmlvZDogJ1AxNEQnLCAvLyAxNCBkYXlzXG4gICAqICAgc29mdERlbGV0ZVBlcmlvZDogJ1AzNjVEJyAvLyAxIHllYXJcbiAgICogfSk7XG4gICAqIGBgYFxuICAgKiBUaGlzIG1ldGhvZCBmYWNpbGl0YXRlcyB0aGUgZWZmaWNpZW50IHNldHVwIGFuZCBzY2FsaW5nIG9mIGRhdGFiYXNlcyB3aXRoaW4gYW4gQXp1cmUgS3VzdG8gY2x1c3RlciwgYWxsb3dpbmdcbiAgICogZm9yIGNvbXBsZXggZGF0YSBhbmFseXRpY3Mgb3BlcmF0aW9ucyBhY3Jvc3MgbGFyZ2UgZGF0YXNldHMuXG4gICAqL1xuICBwdWJsaWMgYWRkRGF0YWJhc2UoZGF0YWJhc2VQcm9wczogRGF0YWJhc2VQcm9wcykge1xuICAgIHJldHVybiBuZXcgRGF0YWJhc2UodGhpcywgZGF0YWJhc2VQcm9wcy5uYW1lLCB7XG4gICAgICBrdXN0b0NsdXN0ZXI6IHRoaXMua3VzdG9DbHVzdGVyLFxuICAgICAgbmFtZTogZGF0YWJhc2VQcm9wcy5uYW1lLFxuICAgICAgaG90Q2FjaGVQZXJpb2Q6IGRhdGFiYXNlUHJvcHMuaG90Q2FjaGVQZXJpb2QsXG4gICAgICBzb2Z0RGVsZXRlUGVyaW9kOiBkYXRhYmFzZVByb3BzLnNvZnREZWxldGVQZXJpb2QsXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==