export interface IComputeSpecification {
    skuName: string;
    workload: string;
    series: string;
    size: string;
    vCPU: number;
    memory: number;
    cache: number;
    availibleZones: string[];
}
export declare class ComputeSpecification {
    static devtestExtraSmallDv2: IComputeSpecification;
    static devtestExtraSmallEav4: IComputeSpecification;
    static computeOptimizedLargeD14v2: IComputeSpecification;
    static computeOptimizedExtraSmallD11v2: IComputeSpecification;
    static computeOptimizedLargeD16dv5: IComputeSpecification;
    static computeOptimizedMediumD13v2: IComputeSpecification;
    static computeOptimizedSmallD12v2: IComputeSpecification;
    static storageOptimizedLargeStandardDS14v24TBPS: IComputeSpecification;
    static storageOptimizedStandardDS14v23TBPS: IComputeSpecification;
    static storageOptimizedMediumStandardDS13v21TBPS: IComputeSpecification;
    static storageOptimizedMediumStandardDS13v22TBPS: IComputeSpecification;
    static computeOptimizedExtraLargeStandardD32dv5: IComputeSpecification;
    static computeOptimizedExtraLargeStandardD32dv4: IComputeSpecification;
    static storageOptimizedMediumStandardEC8adsv5: IComputeSpecification;
    static storageOptimizedMediumStandardEC8asv51TBPS: IComputeSpecification;
    static storageOptimizedMediumStandardEC8asv52TBPS: IComputeSpecification;
    static storageOptimizedLargeStandardEC16adsv5: IComputeSpecification;
    static storageOptimizedLargeStandardEC16asv54TBPS: IComputeSpecification;
    static storageOptimizedLargeStandardEC16asv53TBPS: IComputeSpecification;
    static computeOptimizedIsolatedStandardE80idsv4: IComputeSpecification;
    static computeOptimizedMediumStandardE8av4: IComputeSpecification;
    static computeOptimizedMediumStandardE8adsv5: IComputeSpecification;
    static storageOptimizedMediumStandardE8asv51TBPS: IComputeSpecification;
    static storageOptimizedMediumStandardE8asv52TBPS: IComputeSpecification;
    static storageOptimizedMediumStandardE8asv41TBPS: IComputeSpecification;
    static storageOptimizedMediumStandardE8asv42TBPS: IComputeSpecification;
    static computeOptimizedMediumStandardE8dv5: IComputeSpecification;
    static computeOptimizedMediumStandardE8dv4: IComputeSpecification;
    static storageOptimizedMediumStandardE8sv51TBPS: IComputeSpecification;
    static storageOptimizedMediumStandardE8sv52TBPS: IComputeSpecification;
    static storageOptimizedMediumSStandardE8sv41TBPS: IComputeSpecification;
    static storageOptimizedMediumStandardE8sv42TBPS: IComputeSpecification;
    static computeOptimizedSmallStandardE4av4: IComputeSpecification;
    static computeOptimizedSmallStandardE4adsv5: IComputeSpecification;
    static computeOptimizedSmallStandardE4dv5: IComputeSpecification;
    static computeOptimizedSmallStandardE4dv4: IComputeSpecification;
    static computeOptimizedLargeStandardE16av4: IComputeSpecification;
    static computeOptimizedLargeStandardE16adsv5: IComputeSpecification;
    static storageOptimizedLargeStandardE16asv54TBPS: IComputeSpecification;
    static storageOptimizedLargeStandardE16asv53TBPS: IComputeSpecification;
    static standardE16asv44TBPS: IComputeSpecification;
    static storageOptimizedLargeStandardE16asv43TBPS: IComputeSpecification;
    static computeOptimizedLargeStandardE16dv5: IComputeSpecification;
    static computeOptimizedLargeStandardE16dv4: IComputeSpecification;
    static standardE16sv54TBPS: IComputeSpecification;
    static storageOptimizedLargestorageOptimizedLargeStandardE16sv53TBPS: IComputeSpecification;
    static storageOptimizedLargeStandardE16sv44TBPS: IComputeSpecification;
    static storageOptimizedLargeStandardE16sv43TBPS: IComputeSpecification;
    static computeOptimizedIsolatedStandardE64iv3: IComputeSpecification;
    static computeOptimizedExtraSmallStandardE2av4: IComputeSpecification;
    static computeOptimizedExtraSmallStandardE2adsv5: IComputeSpecification;
    static computeOptimizedExtraSmallStandardE2dv5: IComputeSpecification;
    static computeOptimizedExtraSmallStandardE2dv4: IComputeSpecification;
    static storageOptimizedMediumStandardL8asv3: IComputeSpecification;
    static storageOptimizedMediumStandardL8sv3: IComputeSpecification;
    static storageOptimizedLargeStandardL16asv3: IComputeSpecification;
    static storageOptimizedLargeStandardL16sv3: IComputeSpecification;
    static storageOptimizedExtraLargeStandardL32asv3: IComputeSpecification;
    static storageOptimizedExtraLargeStandardL32sv3: IComputeSpecification;
}
