"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComputeSpecification = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
class ComputeSpecification {
}
exports.ComputeSpecification = ComputeSpecification;
_a = JSII_RTTI_SYMBOL_1;
ComputeSpecification[_a] = { fqn: "@microsoft/terraform-cdk-constructs.azure_kusto.ComputeSpecification", version: "0.0.3-pre.12" };
ComputeSpecification.devtestExtraSmallDv2 = {
    skuName: "Dev(No SLA)_Standard_D11_v2",
    workload: "dev/test",
    series: "Dv2/DSv2 Series",
    size: "Extra Small",
    vCPU: 2,
    memory: 14,
    cache: 78,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.devtestExtraSmallEav4 = {
    skuName: "Dev(No SLA)_Standard_E2a_v4",
    workload: "dev/test",
    series: "Ev4/Edv4 Series",
    size: "Extra Small",
    vCPU: 2,
    memory: 16,
    cache: 24,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.computeOptimizedLargeD14v2 = {
    skuName: "Standard_D14_v2",
    workload: "Compute optimized",
    series: "Dv2/DSv2 Series",
    size: "Large",
    vCPU: 16,
    memory: 112,
    cache: 680,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.computeOptimizedExtraSmallD11v2 = {
    skuName: "Standard_D11_v2",
    workload: "Compute optimized",
    series: "Dv2/DSv2 Series",
    size: "Extra Small",
    vCPU: 2,
    memory: 14,
    cache: 78,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.computeOptimizedLargeD16dv5 = {
    skuName: "Standard_D16d_v5",
    workload: "Compute optimized",
    series: "Ddv5 Series",
    size: "Large",
    vCPU: 16,
    memory: 64,
    cache: 485,
    availibleZones: [],
};
ComputeSpecification.computeOptimizedMediumD13v2 = {
    skuName: "Standard_D13_v2",
    workload: "Compute optimized",
    series: "Dv2/DSv2 Series",
    size: "Medium",
    vCPU: 8,
    memory: 56,
    cache: 335,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.computeOptimizedSmallD12v2 = {
    skuName: "Standard_D12_v2",
    workload: "Compute optimized",
    series: "Dv2/DSv2 Series",
    size: "Small",
    vCPU: 4,
    memory: 28,
    cache: 162,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.storageOptimizedLargeStandardDS14v24TBPS = {
    skuName: "Standard_DS14_v2+4TB_PS",
    workload: "Storage optimized",
    series: "Dv2/DSv2 Series",
    size: "Large",
    vCPU: 16,
    memory: 112,
    cache: 4096,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.storageOptimizedStandardDS14v23TBPS = {
    skuName: "Standard_DS14_v2+3TB_PS",
    workload: "Storage optimized",
    series: "Dv2/DSv2 Series",
    size: "Large",
    vCPU: 16,
    memory: 112,
    cache: 3072,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.storageOptimizedMediumStandardDS13v21TBPS = {
    skuName: "Standard_DS13_v2+1TB_PS",
    workload: "Storage optimized",
    series: "Dv2/DSv2 Series",
    size: "Medium",
    vCPU: 8,
    memory: 56,
    cache: 1024,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.storageOptimizedMediumStandardDS13v22TBPS = {
    skuName: "Standard_DS13_v2+2TB_PS",
    workload: "Storage optimized",
    series: "Dv2/DSv2 Series",
    size: "Medium",
    vCPU: 8,
    memory: 56,
    cache: 2048,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.computeOptimizedExtraLargeStandardD32dv5 = {
    skuName: "Standard_D32d_v5",
    workload: "Compute optimized",
    series: "Ddv5 Series",
    size: "Extra Large",
    vCPU: 32,
    memory: 128,
    cache: 976,
    availibleZones: [],
};
ComputeSpecification.computeOptimizedExtraLargeStandardD32dv4 = {
    skuName: "Standard_D32d_v4",
    workload: "Compute optimized",
    series: "Ddv4 Series",
    size: "Extra Large",
    vCPU: 32,
    memory: 128,
    cache: 976,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.storageOptimizedMediumStandardEC8adsv5 = {
    skuName: "Standard_EC8ads_v5",
    workload: "Storage optimized",
    series: "ECadsv5 Series",
    size: "Medium",
    vCPU: 8,
    memory: 64,
    cache: 240,
    availibleZones: ["1", "3"],
};
ComputeSpecification.storageOptimizedMediumStandardEC8asv51TBPS = {
    skuName: "Standard_EC8as_v5+1TB_PS",
    workload: "Storage optimized",
    series: "ECasv5 Series",
    size: "Medium",
    vCPU: 8,
    memory: 64,
    cache: 1024,
    availibleZones: ["1", "3"],
};
ComputeSpecification.storageOptimizedMediumStandardEC8asv52TBPS = {
    skuName: "Standard_EC8as_v5+2TB_PS",
    workload: "Storage optimized",
    series: "ECasv5 Series",
    size: "Medium",
    vCPU: 8,
    memory: 64,
    cache: 2048,
    availibleZones: ["1", "3"],
};
ComputeSpecification.storageOptimizedLargeStandardEC16adsv5 = {
    skuName: "Standard_EC16ads_v5",
    workload: "Storage optimized",
    series: "ECadsv5 Series",
    size: "Large",
    vCPU: 16,
    memory: 128,
    cache: 485,
    availibleZones: ["1", "3"],
};
ComputeSpecification.storageOptimizedLargeStandardEC16asv54TBPS = {
    skuName: "Standard_EC16as_v5+4TB_PS",
    workload: "Storage optimized",
    series: "ECasv5 Series",
    size: "Large",
    vCPU: 16,
    memory: 128,
    cache: 4096,
    availibleZones: ["1", "3"],
};
ComputeSpecification.storageOptimizedLargeStandardEC16asv53TBPS = {
    skuName: "Standard_EC16as_v5+3TB_PS",
    workload: "Storage optimized",
    series: "ECasv5 Series",
    size: "Large",
    vCPU: 16,
    memory: 128,
    cache: 3072,
    availibleZones: ["1", "3"],
};
ComputeSpecification.computeOptimizedIsolatedStandardE80idsv4 = {
    skuName: "Standard_E80ids_v4",
    workload: "Compute optimized",
    series: "Eidsv4 Series",
    size: "Isolated",
    vCPU: 80,
    memory: 504,
    cache: 32670,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.computeOptimizedMediumStandardE8av4 = {
    skuName: "Standard_E8a_v4",
    workload: "Compute optimized",
    series: "Eav4/Easv4 Series",
    size: "Medium",
    vCPU: 8,
    memory: 64,
    cache: 140,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.computeOptimizedMediumStandardE8adsv5 = {
    skuName: "Standard_E8ads_v5",
    workload: "Compute optimized",
    series: "Eadsv5 Series",
    size: "Medium",
    vCPU: 8,
    memory: 64,
    cache: 240,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.storageOptimizedMediumStandardE8asv51TBPS = {
    skuName: "Standard_E8as_v5+1TB_PS",
    workload: "Storage optimized",
    series: "Easv5 Series",
    size: "Medium",
    vCPU: 8,
    memory: 64,
    cache: 1024,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.storageOptimizedMediumStandardE8asv52TBPS = {
    skuName: "Standard_E8as_v5+2TB_PS",
    workload: "Storage optimized",
    series: "Easv5 Series",
    size: "Medium",
    vCPU: 8,
    memory: 64,
    cache: 2048,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.storageOptimizedMediumStandardE8asv41TBPS = {
    skuName: "Standard_E8as_v4+1TB_PS",
    workload: "Storage optimized",
    series: "Eav4/Easv4 Series",
    size: "Medium",
    vCPU: 8,
    memory: 64,
    cache: 1024,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.storageOptimizedMediumStandardE8asv42TBPS = {
    skuName: "Standard_E8as_v4+2TB_PS",
    workload: "Storage optimized",
    series: "Eav4/Easv4 Series",
    size: "Medium",
    vCPU: 8,
    memory: 64,
    cache: 2048,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.computeOptimizedMediumStandardE8dv5 = {
    skuName: "Standard_E8d_v5",
    workload: "Compute optimized",
    series: "Edv5 Series",
    size: "Medium",
    vCPU: 8,
    memory: 64,
    cache: 240,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.computeOptimizedMediumStandardE8dv4 = {
    skuName: "Standard_E8d_v4",
    workload: "Compute optimized",
    series: "Edv4 Series",
    size: "Medium",
    vCPU: 8,
    memory: 64,
    cache: 240,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.storageOptimizedMediumStandardE8sv51TBPS = {
    skuName: "Standard_E8s_v5+1TB_PS",
    workload: "Storage optimized",
    series: "Esv5 Series",
    size: "Medium",
    vCPU: 8,
    memory: 64,
    cache: 1024,
    availibleZones: [],
};
ComputeSpecification.storageOptimizedMediumStandardE8sv52TBPS = {
    skuName: "Standard_E8s_v5+2TB_PS",
    workload: "Storage optimized",
    series: "Esv5 Series",
    size: "Medium",
    vCPU: 8,
    memory: 64,
    cache: 2048,
    availibleZones: [],
};
ComputeSpecification.storageOptimizedMediumSStandardE8sv41TBPS = {
    skuName: "Standard_E8s_v4+1TB_PS",
    workload: "Storage optimized",
    series: "Esv4 Series",
    size: "Medium",
    vCPU: 8,
    memory: 64,
    cache: 1024,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.storageOptimizedMediumStandardE8sv42TBPS = {
    skuName: "Standard_E8s_v4+2TB_PS",
    workload: "Storage optimized",
    series: "Esv4 Series",
    size: "Medium",
    vCPU: 8,
    memory: 64,
    cache: 2048,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.computeOptimizedSmallStandardE4av4 = {
    skuName: "Standard_E4a_v4",
    workload: "Compute optimized",
    series: "Eav4/Easv4 Series",
    size: "Small",
    vCPU: 4,
    memory: 32,
    cache: 66,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.computeOptimizedSmallStandardE4adsv5 = {
    skuName: "Standard_E4ads_v5",
    workload: "Compute optimized",
    series: "Eadsv5 Series",
    size: "Small",
    vCPU: 4,
    memory: 32,
    cache: 116,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.computeOptimizedSmallStandardE4dv5 = {
    skuName: "Standard_E4d_v5",
    workload: "Compute optimized",
    series: "Edv5 Series",
    size: "Small",
    vCPU: 4,
    memory: 32,
    cache: 116,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.computeOptimizedSmallStandardE4dv4 = {
    skuName: "Standard_E4d_v4",
    workload: "Compute optimized",
    series: "Edv4 Series",
    size: "Small",
    vCPU: 4,
    memory: 32,
    cache: 116,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.computeOptimizedLargeStandardE16av4 = {
    skuName: "Standard_E16a_v4",
    workload: "Compute optimized",
    series: "Eav4/Easv4 Series",
    size: "Large",
    vCPU: 16,
    memory: 128,
    cache: 285,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.computeOptimizedLargeStandardE16adsv5 = {
    skuName: "Standard_E16ads_v5",
    workload: "Compute optimized",
    series: "Eadsv5 Series",
    size: "Large",
    vCPU: 16,
    memory: 128,
    cache: 485,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.storageOptimizedLargeStandardE16asv54TBPS = {
    skuName: "Standard_E16as_v5+4TB_PS",
    workload: "Storage optimized",
    series: "Easv5 Series",
    size: "Large",
    vCPU: 16,
    memory: 128,
    cache: 4096,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.storageOptimizedLargeStandardE16asv53TBPS = {
    skuName: "Standard_E16as_v5+3TB_PS",
    workload: "Storage optimized",
    series: "Easv5 Series",
    size: "Large",
    vCPU: 16,
    memory: 128,
    cache: 3072,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.standardE16asv44TBPS = {
    skuName: "Standard_E16as_v4+4TB_PS",
    workload: "Storage optimized",
    series: "Eav4/Easv4 Series",
    size: "Large",
    vCPU: 16,
    memory: 128,
    cache: 4096,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.storageOptimizedLargeStandardE16asv43TBPS = {
    skuName: "Standard_E16as_v4+3TB_PS",
    workload: "Storage optimized",
    series: "Eav4/Easv4 Series",
    size: "Large",
    vCPU: 16,
    memory: 128,
    cache: 3072,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.computeOptimizedLargeStandardE16dv5 = {
    skuName: "Standard_E16d_v5",
    workload: "Compute optimized",
    series: "Edv5 Series",
    size: "Large",
    vCPU: 16,
    memory: 128,
    cache: 485,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.computeOptimizedLargeStandardE16dv4 = {
    skuName: "Standard_E16d_v4",
    workload: "Compute optimized",
    series: "Edv4 Series",
    size: "Large",
    vCPU: 16,
    memory: 128,
    cache: 485,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.standardE16sv54TBPS = {
    skuName: "Standard_E16s_v5+4TB_PS",
    workload: "Storage optimized",
    series: "Esv5 Series",
    size: "Large",
    vCPU: 16,
    memory: 128,
    cache: 4096,
    availibleZones: [],
};
ComputeSpecification.storageOptimizedLargestorageOptimizedLargeStandardE16sv53TBPS = {
    skuName: "Standard_E16s_v5+3TB_PS",
    workload: "Storage optimized",
    series: "Esv5 Series",
    size: "Large",
    vCPU: 16,
    memory: 128,
    cache: 3072,
    availibleZones: [],
};
ComputeSpecification.storageOptimizedLargeStandardE16sv44TBPS = {
    skuName: "Standard_E16s_v4+4TB_PS",
    workload: "Storage optimized",
    series: "Esv4 Series",
    size: "Large",
    vCPU: 16,
    memory: 128,
    cache: 4096,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.storageOptimizedLargeStandardE16sv43TBPS = {
    skuName: "Standard_E16s_v4+3TB_PS",
    workload: "Storage optimized",
    series: "Esv4 Series",
    size: "Large",
    vCPU: 16,
    memory: 128,
    cache: 3072,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.computeOptimizedIsolatedStandardE64iv3 = {
    skuName: "Standard_E64i_v3",
    workload: "Compute optimized",
    series: "Eiv3 Series",
    size: "Isolated",
    vCPU: 64,
    memory: 432,
    cache: 1126,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.computeOptimizedExtraSmallStandardE2av4 = {
    skuName: "Standard_E2a_v4",
    workload: "Compute optimized",
    series: "Eav4/Easv4 Series",
    size: "Extra Small",
    vCPU: 2,
    memory: 16,
    cache: 30,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.computeOptimizedExtraSmallStandardE2adsv5 = {
    skuName: "Standard_E2ads_v5",
    workload: "Compute optimized",
    series: "Eadsv5 Series",
    size: "Extra Small",
    vCPU: 2,
    memory: 16,
    cache: 55,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.computeOptimizedExtraSmallStandardE2dv5 = {
    skuName: "Standard_E2d_v5",
    workload: "Compute optimized",
    series: "Edv5 Series",
    size: "Extra Small",
    vCPU: 2,
    memory: 16,
    cache: 55,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.computeOptimizedExtraSmallStandardE2dv4 = {
    skuName: "Standard_E2d_v4",
    workload: "Compute optimized",
    series: "Edv4 Series",
    size: "Extra Small",
    vCPU: 2,
    memory: 16,
    cache: 55,
    availibleZones: ["1", "2", "3"],
};
ComputeSpecification.storageOptimizedMediumStandardL8asv3 = {
    skuName: "Standard_L8as_v3",
    workload: "Storage optimized",
    series: "Lasv3 Series",
    size: "Medium",
    vCPU: 8,
    memory: 64,
    cache: 1750,
    availibleZones: [],
};
// static storageOptimizedMediumStandardL8s: IComputeSpecification = {
//   skuName: "Standard_L8s",
//   workload: "Storage optimized",
//   series: "Lasv3 Series",
//   size: "Medium",
//   vCPU: 8,
//   memory: 64,
//   cache: 1750,
//   availibleZones: [],
// }
ComputeSpecification.storageOptimizedMediumStandardL8sv3 = {
    skuName: "Standard_L8s_v3",
    workload: "Storage optimized",
    series: "Lasv3 Series",
    size: "Medium",
    vCPU: 8,
    memory: 64,
    cache: 1750,
    availibleZones: [],
};
// static StandardL8sv2: IComputeSpecification = {
//   skuName: "Standard_L8s_v2",
//   workload: "Storage optimized",
//   series: "Lasv2 Series",
//   size: "Medium",
//   vCPU: 8,
//   memory: 64,
//   cache: 1750,
//   availibleZones: [],
// }
// static StandardL4s: IComputeSpecification = {
//   skuName: "Standard_L4s",
//   workload: "Storage optimized",
//   series: "Lasv2 Series",
//   size: "Small",
//   vCPU: 4,
//   memory: 32,
//   cache: 850,
//   availibleZones: [],
// }
ComputeSpecification.storageOptimizedLargeStandardL16asv3 = {
    skuName: "Standard_L16as_v3",
    workload: "Storage optimized",
    series: "Lasv3 Series",
    size: "Large",
    vCPU: 16,
    memory: 128,
    cache: 3500,
    availibleZones: [],
};
// static StandardL16s: IComputeSpecification = {
//   skuName: "Standard_L16s",
//   workload: "Storage optimized",
//   series: "Lasv2 Series",
//   size: "Large",
//   vCPU: 16,
//   memory: 128,
//   cache: 3500,
//   availibleZones: [],
// }
ComputeSpecification.storageOptimizedLargeStandardL16sv3 = {
    skuName: "Standard_L16s_v3",
    workload: "Storage optimized",
    series: "Lasv3 Series",
    size: "Large",
    vCPU: 16,
    memory: 128,
    cache: 3500,
    availibleZones: [],
};
// static StandardL16sv2: IComputeSpecification = {
//   skuName: "Standard_L16s_v2",
//   workload: "Storage optimized",
//   series: "Lasv2 Series",
//   size: "Large",
//   vCPU: 16,
//   memory: 128,
//   cache: 3500,
//   availibleZones: [],
// }
ComputeSpecification.storageOptimizedExtraLargeStandardL32asv3 = {
    skuName: "Standard_L32as_v3",
    workload: "Storage optimized",
    series: "Lasv3 Series",
    size: "Extra Large",
    vCPU: 32,
    memory: 256,
    cache: 7000,
    availibleZones: [],
};
ComputeSpecification.storageOptimizedExtraLargeStandardL32sv3 = {
    skuName: "Standard_L32s_v3",
    workload: "Storage optimized",
    series: "Lasv3 Series",
    size: "Extra Large",
    vCPU: 32,
    memory: 256,
    cache: 7000,
    availibleZones: [],
};
//# sourceMappingURL=data:application/json;base64,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