"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const data_azurerm_client_config_1 = require("@cdktf/provider-azurerm/lib/data-azurerm-client-config");
const provider_1 = require("@cdktf/provider-azurerm/lib/provider");
const resource_group_1 = require("@cdktf/provider-azurerm/lib/resource-group");
const cdktf_1 = require("cdktf");
const kusto = require("..");
const testing_1 = require("../../testing");
const randomName_1 = require("../../util/randomName");
require("cdktf/lib/testing/adapters/jest");
const compute_specification_1 = require("../lib/compute-specification");
describe("Example of deploying a Kusto Cluster", () => {
    let stack;
    let fullSynthResult;
    const streamOutput = process.env.STREAM_OUTPUT !== "false";
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "test");
        const randomName = (0, randomName_1.generateRandomName)(12);
        const clientConfig = new data_azurerm_client_config_1.DataAzurermClientConfig(stack, "CurrentClientConfig", {});
        new provider_1.AzurermProvider(stack, "azureFeature", { features: {} });
        // Create a resource group
        const resourceGroup = new resource_group_1.ResourceGroup(stack, "rg", {
            name: `rg-${randomName}`,
            location: "eastus",
        });
        // Create Kusto Cluster
        const kustoCluster = new kusto.Cluster(stack, "kusto", {
            resourceGroup: resourceGroup,
            name: `kusto${randomName}`,
            sku: compute_specification_1.ComputeSpecification.devtestExtraSmallEav4,
            identityIds: [],
            capacity: 1,
        });
        // Add RBAC to Kusto Cluster
        kustoCluster.addAccess(clientConfig.objectId, "Contributor");
        // Create Database
        const testDB1 = kustoCluster.addDatabase({
            kustoCluster: kustoCluster.kustoCluster,
            name: "testDB1",
            hotCachePeriod: "P7D",
            softDeletePeriod: "P31D",
        });
        // Create Table in Kusto Database
        testDB1.addTable("MyTestTable", [
            {
                columnName: "Timestamp",
                columnType: "datetime",
            },
            {
                columnName: "User",
                columnType: "string",
            },
            {
                columnName: "Value",
                columnType: "int32",
            },
        ]);
        testDB1.addScript("MyTestScript", ".create table MyTestTable2 ( Timestamp:datetime, User:string, Value:int32 )");
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    afterEach(() => {
        try {
            (0, testing_1.TerraformDestroy)(fullSynthResult, streamOutput);
        }
        catch (error) {
            console.error("Error during Terraform destroy:", error);
        }
    });
    it("check if stack can be deployed", () => {
        (0, testing_1.TerraformApplyAndCheckIdempotency)(fullSynthResult, streamOutput); // Set to true to stream output
    });
});
//# sourceMappingURL=data:application/json;base64,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