"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const provider_1 = require("@cdktf/provider-azurerm/lib/provider");
const cdktf_1 = require("cdktf");
require("cdktf/lib/testing/adapters/jest");
const kusto = require("..");
const testing_1 = require("../../testing");
describe("Kusto With Defaults", () => {
    let stack;
    let fullSynthResult;
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "test");
        new provider_1.AzurermProvider(stack, "azureFeature", { features: {} });
        new kusto.Cluster(stack, "testAzureKustoDefaults", {
            name: "kustotest",
            sku: kusto.ComputeSpecification.devtestExtraSmallEav4,
        });
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    it("renders an Kusto with defaults and checks snapshot", () => {
        expect(cdktf_1.Testing.synth(stack)).toMatchSnapshot(); // Compare the already prepared stack
    });
    it("check if the produced terraform configuration is valid", () => {
        expect(fullSynthResult).toBeValidTerraform(); // Use the saved result
    });
    it("check if this can be planned", () => {
        (0, testing_1.TerraformPlan)(fullSynthResult); // Use the saved result
    });
});
//# sourceMappingURL=data:application/json;base64,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