"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Workspace = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const log_analytics_data_export_rule_1 = require("@cdktf/provider-azurerm/lib/log-analytics-data-export-rule");
const log_analytics_saved_search_1 = require("@cdktf/provider-azurerm/lib/log-analytics-saved-search");
const log_analytics_workspace_1 = require("@cdktf/provider-azurerm/lib/log-analytics-workspace");
const cdktf = require("cdktf");
const lib_1 = require("../../core-azure/lib");
class Workspace extends lib_1.AzureResourceWithAlert {
    /**
     * Represents an Azure Log Analytics Workspace.
     *
     * This class is responsible for the creation and configuration of a Log Analytics Workspace in Azure. A Log Analytics Workspace
     * is a unique environment for Azure Monitor data, where data is collected, aggregated, and serves as the administrative boundary.
     * Within a workspace, data is collected from various sources and is used for analysis, visualization, and alerting. Configurations
     * can include data export rules, saved queries, and custom functions to enhance data analytics capabilities.
     *
     * @param scope - The scope in which to define this construct, typically representing the Cloud Development Kit (CDK) stack.
     * @param id - The unique identifier for this instance of the Log Analytics workspace.
     * @param props - The properties required to configure the Log Analytics workspace, as defined in the WorkspaceProps interface. These include:
     *                - `location`: The Azure region where the workspace will be deployed.
     *                - `name`: The name of the workspace, which must be globally unique.
     *                - `resourceGroup`: Optional. Reference to the resource group for deployment.
     *                - `sku`: Optional. The SKU of the workspace, affecting pricing and features.
     *                - `retention`: Optional. The number of days data will be retained in the workspace.
     *                - `tags`: Optional. Tags to assign to the workspace for organizational purposes.
     *                - `dataExport`: Optional. Configurations for exporting data to other Azure resources.
     *                - `functions`: Optional. Custom functions defined within the workspace for query operations.
     *                - `queries`: Optional. Saved queries that can be used for data analysis or visualizations.
     *
     * Example usage:
     * ```typescript
     * new Workspace(this, 'MyLogAnalyticsWorkspace', {
     *   location: 'East US',
     *   name: 'myWorkspace',
     *   resourceGroup: myResourceGroup,
     *   sku: 'PerGB2018',
     *   retention: 60,
     *   tags: { department: 'IT' },
     *   functions: [{
     *     name: 'ErrorCount',
     *     displayName: 'Error Count',
     *     query: 'AzureActivity | summarize count() by bin(timestamp, 1h), type',
     *     functionAlias: 'error_count',
     *     functionParameters: 'timestamp, type'
     *   }],
     *   queries: [{
     *     name: 'HighCPUUsage',
     *     category: 'Performance',
     *     displayName: 'High CPU Usage',
     *     query: 'Perf | where CounterName == "% Processor Time" and CounterValue > 80'
     *   }]
     * });
     * ```
     * This class sets up the workspace and applies configurations, providing a centralized environment for monitoring and analytics.
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.resourceGroup = this.setupResourceGroup(props);
        // Provide default values
        const sku = props.sku ?? "PerGB2018";
        const retention = props.retention ?? 30;
        const azurermLogAnalyticsWorkspaceLogAnalytics = new log_analytics_workspace_1.LogAnalyticsWorkspace(this, "log_analytics", {
            location: props.location,
            name: props.name,
            resourceGroupName: this.resourceGroup.name,
            retentionInDays: retention,
            sku: sku,
            tags: props.tags,
        });
        this.id = azurermLogAnalyticsWorkspaceLogAnalytics.id;
        this.logAnalyticsWorkspace = azurermLogAnalyticsWorkspaceLogAnalytics;
        props.dataExport?.forEach((v, k) => {
            new log_analytics_data_export_rule_1.LogAnalyticsDataExportRule(this, `export-${k}`, {
                destinationResourceId: v.exportDestinationId,
                enabled: v.enabled,
                name: v.name,
                resourceGroupName: this.resourceGroup.name,
                tableNames: v.tableNames,
                workspaceResourceId: azurermLogAnalyticsWorkspaceLogAnalytics.id,
            });
        });
        props.functions?.forEach((v, k) => {
            new log_analytics_saved_search_1.LogAnalyticsSavedSearch(this, `function-${k}`, {
                category: "Function",
                displayName: v.displayName,
                functionAlias: v.functionAlias,
                functionParameters: v.functionParameters,
                logAnalyticsWorkspaceId: azurermLogAnalyticsWorkspaceLogAnalytics.id,
                name: v.name,
                query: v.query,
            });
        });
        props.queries?.forEach((v, k) => {
            new log_analytics_saved_search_1.LogAnalyticsSavedSearch(this, `function-${k}`, {
                category: v.category,
                displayName: v.displayName,
                functionParameters: [],
                logAnalyticsWorkspaceId: azurermLogAnalyticsWorkspaceLogAnalytics.id,
                name: v.name,
                query: v.query,
            });
        });
        // Terraform Outputs
        const cdktfTerraformOutputLaID = new cdktf.TerraformOutput(this, "log_analytics_id", {
            value: azurermLogAnalyticsWorkspaceLogAnalytics.id,
        });
        const cdktfTerraformOutputLaSharedKey = new cdktf.TerraformOutput(this, "log_analytics_primary_shared_key", {
            value: azurermLogAnalyticsWorkspaceLogAnalytics.primarySharedKey,
            sensitive: true,
        });
        const cdktfTerraformOutputLaWorkspaceID = new cdktf.TerraformOutput(this, "log_analytics_workspace_id", {
            value: azurermLogAnalyticsWorkspaceLogAnalytics.workspaceId,
        });
        /*This allows the Terraform resource name to match the original name. You can remove the call if you don't need them to match.*/
        cdktfTerraformOutputLaID.overrideLogicalId("log_analytics_id");
        cdktfTerraformOutputLaSharedKey.overrideLogicalId("log_analytics_primary_shared_key");
        cdktfTerraformOutputLaWorkspaceID.overrideLogicalId("log_analytics_workspace_id");
    }
}
exports.Workspace = Workspace;
_a = JSII_RTTI_SYMBOL_1;
Workspace[_a] = { fqn: "@microsoft/terraform-cdk-constructs.azure_loganalytics.Workspace", version: "0.0.3-pre.12" };
//# sourceMappingURL=data:application/json;base64,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