"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const provider_1 = require("@cdktf/provider-azurerm/lib/provider");
const cdktf_1 = require("cdktf");
const la = require("..");
const testing_1 = require("../../testing");
require("cdktf/lib/testing/adapters/jest");
describe("Log Analytics Workspace With Defaults", () => {
    let stack;
    let fullSynthResult;
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "test");
        new provider_1.AzurermProvider(stack, "azureFeature", { features: {} });
        new la.Workspace(stack, "testAzureLogAnalyticsDefaults", {
            name: "la-test",
            location: "eastus",
        });
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    it("renders a Log Analytics Workspace with defaults and checks snapshot", () => {
        expect(cdktf_1.Testing.synth(stack)).toMatchSnapshot(); // Compare the already prepared stack
    });
    it("check if the produced terraform configuration is valid", () => {
        expect(fullSynthResult).toBeValidTerraform(); // Use the saved result
    });
    it("check if this can be planned", () => {
        (0, testing_1.TerraformPlan)(fullSynthResult); // Use the saved result
    });
});
//# sourceMappingURL=data:application/json;base64,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