"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetricAlert = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const monitor_metric_alert_1 = require("@cdktf/provider-azurerm/lib/monitor-metric-alert");
const cdktf = require("cdktf");
const constructs_1 = require("constructs");
const moment = require("moment");
const model = require("../model");
class MetricAlert extends constructs_1.Construct {
    /**
     * Represents a Metric Alert in Azure Monitor, which is used to automatically monitor metrics across Azure services and trigger actions when certain conditions are met.
     *
     * This class encapsulates the configuration and management of a Metric Alert, allowing users to define alert rules based on the metrics from their Azure resources. Metric Alerts can help in proactively managing the health, performance, and availability of Azure services.
     *
     * Properties:
     * - `name`: The name of the Metric Alert, which must be unique within the resource group.
     * - `description`: Optional. A description of what the Metric Alert monitors and potential impact or remediation.
     * - `enabled`: Indicates whether the alert rule is enabled. Disabled rules will not fire.
     * - `autoMitigate`: Specifies whether the alert should attempt auto-mitigation actions when triggered.
     * - `frequency`: The frequency of evaluation for the alert rule, determining how often the rule is checked.
     * - `severity`: The severity level assigned to the alert. This helps in categorizing the urgency of the alert.
     * - `targetResourceType`: Specifies the type of Azure resource the alert rule applies to, necessary for scoping the alert.
     * - `targetResourceLocation`: Specifies the location of the target resource, required when the alert rule covers resources in multiple locations.
     * - `windowSize`: The period over which data is collected for analysis, which must be greater than the frequency of evaluation.
     * - `tags`: User-defined tags to help organize and identify resources within Azure.
     * - `criteria`: The conditions that trigger the alert. This can be static or dynamic, based on the behavior of the monitored metric over time.
     * - `dynamicCriteria`: Advanced configurations for criteria that dynamically adjust thresholds based on historical data.
     * - `scopes`: The specific resources that the Metric Alert is scoped to monitor.
     * - `resourceGroup`: The Azure Resource Group in which this Metric Alert is defined.
     *
     * Example usage:
     * ```typescript
     * const cpuAlertProps: IMetricAlertProps = {
     *   name: 'High CPU Usage Alert',
     *   resourceGroup: resourceGroupInstance,
     *   scopes: [vm.id],
     *   criteria: [
     *     {
     *       metricName: 'Percentage CPU',
     *       operator: 'GreaterThan',
     *       threshold: 80,
     *       aggregation: 'Average'
     *     }
     *   ],
     *   frequency: 'PT1M',
     *   windowSize: 'PT5M',
     *   severity: 3,
     *   enabled: true
     * };
     *
     * const cpuAlert = new MetricAlert(this, 'cpuUsageAlert', cpuAlertProps);
     * ```
     *
     * This configuration defines a Metric Alert that monitors CPU usage across specified virtual machines, triggering an alert if the CPU usage exceeds 80% over a 5-minute window, evaluated every minute.
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        // Setup default values
        this.props.enabled = props.enabled ?? true;
        this.props.automitigate = props.automitigate ?? true;
        this.props.frequency = props.frequency ?? "PT5M";
        this.props.severity = props.severity ?? 3;
        this.props.windowSize = props.windowSize ?? props.frequency ?? "PT5M";
        // Properties validation
        this.ValidatePropsFrequency();
        this.ValidatePropsWindowSize();
        this.ValidatePropsWindowSizeGreaterThanFrequency();
        // Create Metric Alert
        const metricAlert = new monitor_metric_alert_1.MonitorMetricAlert(this, "metricAlert", {
            name: props.name,
            resourceGroupName: props.resourceGroup.name,
            scopes: props.scopes,
            description: props.description,
            targetResourceType: props.targetResourceType,
            targetResourceLocation: props.targetResourceLocation,
            action: cdktf.listMapper(model.monitorMetricAlertActionToTerraform, true)(this.props.action),
            tags: props.tags,
            enabled: this.props.enabled,
            autoMitigate: this.props.automitigate,
            frequency: this.props.frequency,
            severity: this.props.severity,
            windowSize: this.props.windowSize,
            criteria: cdktf.listMapper(model.monitorMetricAlertCriteriaToTerraform, true)(this.props.criteria),
            dynamicCriteria: cdktf.listMapper(model.monitorMetricAlertDynamicCriteriaToTerraform, true)(this.props.dynamicCriteria),
        });
        // Output properties
        this.id = metricAlert.id;
        const cdktfTerraformOutputMetricAlertId = new cdktf.TerraformOutput(this, "id", {
            value: metricAlert.id,
        });
        cdktfTerraformOutputMetricAlertId.overrideLogicalId("id");
    }
    ValidatePropsFrequency() {
        const frequencyOptions = ["PT1M", "PT5M", "PT15M", "PT30M", "PT1H"];
        if (!frequencyOptions.includes(this.props.frequency ?? "NotSet")) {
            throw new Error(`frequency must be one of ${frequencyOptions}`);
        }
    }
    ValidatePropsWindowSize() {
        const windowSizeOptions = [
            "PT1M",
            "PT5M",
            "PT15M",
            "PT30M",
            "PT1H",
            "PT6H",
            "PT12H",
            "P1D",
        ];
        if (!windowSizeOptions.includes(this.props.windowSize ?? "NotSet")) {
            throw new Error(`windowSize must be one of ${windowSizeOptions}`);
        }
    }
    ValidatePropsWindowSizeGreaterThanFrequency() {
        const f = moment.duration(this.props.frequency);
        const w = moment.duration(this.props.windowSize);
        if (w < f) {
            throw new Error("windowSize must be greater than frequency");
        }
    }
}
exports.MetricAlert = MetricAlert;
_a = JSII_RTTI_SYMBOL_1;
MetricAlert[_a] = { fqn: "@microsoft/terraform-cdk-constructs.azure_metricalert.MetricAlert", version: "0.0.3-pre.12" };
//# sourceMappingURL=data:application/json;base64,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