import { MetricAlertActionProp } from "./action-props";
import { MetricAlertCriteriaDimensionProp } from "./criteria-dimension-props";
import { MetricAlertCriteriaProp } from "./criteria-props";
import { MetricAlertDynamicCritiriaProps } from "./dynamic-criteria-props";
/**
 * Generate a dynamic block of action properties for a Metric Alert.
 * @param props The action properties.
 * @returns The dynamic criteria properties for a Metric Alert.
 */
export declare function monitorMetricAlertActionToTerraform(props?: MetricAlertActionProp): any;
/**
 * Generate a dynamic block of dimension properties for a Metric Alert.
 * @param props The dimension properties.
 * @returns The dynamic dimension properties for a Metric Alert.
 */
export declare function monitorMetricAlertCriteriaDimensionToTerraform(props?: MetricAlertCriteriaDimensionProp): any;
/**
 * Generate a dynamic block of criteria properties for a Metric Alert.
 * @param props The criteria properties.
 * @returns The dynamic criteria properties for a Metric Alert.
 */
export declare function monitorMetricAlertCriteriaToTerraform(props?: MetricAlertCriteriaProp): any;
/**
 * Generate a dynamic block of dynamic criteria properties for a Metric Alert.
 * @param props The dynamic criteria properties.
 * @returns The dynamic criteria properties for a Metric Alert.
 */
export declare function monitorMetricAlertDynamicCriteriaToTerraform(props?: MetricAlertDynamicCritiriaProps): any;
