"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.monitorMetricAlertDynamicCriteriaToTerraform = exports.monitorMetricAlertCriteriaToTerraform = exports.monitorMetricAlertCriteriaDimensionToTerraform = exports.monitorMetricAlertActionToTerraform = void 0;
const cdktf = require("cdktf");
/**
 * Generate a dynamic block of action properties for a Metric Alert.
 * @param props The action properties.
 * @returns The dynamic criteria properties for a Metric Alert.
 */
function monitorMetricAlertActionToTerraform(props) {
    if (!cdktf.canInspect(props)) {
        return props;
    }
    return {
        actionGroupId: props.actionGroupId,
    };
}
exports.monitorMetricAlertActionToTerraform = monitorMetricAlertActionToTerraform;
/**
 * Generate a dynamic block of dimension properties for a Metric Alert.
 * @param props The dimension properties.
 * @returns The dynamic dimension properties for a Metric Alert.
 */
function monitorMetricAlertCriteriaDimensionToTerraform(props) {
    if (!cdktf.canInspect(props)) {
        return props;
    }
    return {
        name: props.name,
        operator: props.operator,
        values: props.values,
    };
}
exports.monitorMetricAlertCriteriaDimensionToTerraform = monitorMetricAlertCriteriaDimensionToTerraform;
/**
 * Generate a dynamic block of criteria properties for a Metric Alert.
 * @param props The criteria properties.
 * @returns The dynamic criteria properties for a Metric Alert.
 */
function monitorMetricAlertCriteriaToTerraform(props) {
    if (!cdktf.canInspect(props)) {
        return props;
    }
    return {
        metricName: props.metricName,
        metricNamespace: props.metricNamespace,
        aggregation: props.aggregation,
        operator: props.operator,
        skipMetricValidation: props.skipMetricValidation || false,
        threshold: props.threshold,
        dimension: cdktf.listMapper(monitorMetricAlertCriteriaDimensionToTerraform, true)(props.dimension),
    };
}
exports.monitorMetricAlertCriteriaToTerraform = monitorMetricAlertCriteriaToTerraform;
/**
 * Generate a dynamic block of dynamic criteria properties for a Metric Alert.
 * @param props The dynamic criteria properties.
 * @returns The dynamic criteria properties for a Metric Alert.
 */
function monitorMetricAlertDynamicCriteriaToTerraform(props) {
    if (!cdktf.canInspect(props)) {
        return props;
    }
    return {
        metricName: props.metricName,
        metricNamespace: props.metricNamespace,
        aggregation: props.aggregation,
        operator: props.operator,
        skipMetricValidation: props.skipMetricValidation || false,
        alertSensitivity: props.alertSensitivity,
        evaluationTotalCount: props.evaluationTotalCount || 4,
        evaluationFailureCount: props.evaluationFailureCount || 4,
        ignoreDataBefore: props.ignoreDataBefore,
        dimension: cdktf.listMapper(monitorMetricAlertCriteriaDimensionToTerraform, true)(props.dimension),
    };
}
exports.monitorMetricAlertDynamicCriteriaToTerraform = monitorMetricAlertDynamicCriteriaToTerraform;
//# sourceMappingURL=data:application/json;base64,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