"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const log_analytics_workspace_1 = require("@cdktf/provider-azurerm/lib/log-analytics-workspace");
const provider_1 = require("@cdktf/provider-azurerm/lib/provider");
const resource_group_1 = require("@cdktf/provider-azurerm/lib/resource-group");
const cdktf_1 = require("cdktf");
const metricalert = require("../../azure-metricalert");
const testing_1 = require("../../testing");
const randomName_1 = require("../../util/randomName");
require("cdktf/lib/testing/adapters/jest");
describe("Example of deploying a Metric Alert", () => {
    let stack;
    let fullSynthResult;
    const streamOutput = process.env.STREAM_OUTPUT !== "false";
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "test");
        const randomName = (0, randomName_1.generateRandomName)(12);
        new provider_1.AzurermProvider(stack, "azureFeature", { features: {} });
        // Create a resource group
        const resourceGroup = new resource_group_1.ResourceGroup(stack, "rg", {
            name: `rg-${randomName}`,
            location: "eastus",
        });
        const logAnalyticsWorkspace = new log_analytics_workspace_1.LogAnalyticsWorkspace(stack, "la", {
            location: "eastus",
            name: `la-${randomName}`,
            resourceGroupName: resourceGroup.name,
        });
        // Create Metric Alert
        new metricalert.MetricAlert(stack, "metricAlert1", {
            name: `metricalert1-${randomName}`,
            resourceGroup: resourceGroup,
            scopes: [logAnalyticsWorkspace.id],
            criteria: [
                {
                    metricName: "Heartbeat",
                    metricNamespace: "Microsoft.operationalinsights/workspaces",
                    aggregation: "Average",
                    operator: "LessThan",
                    threshold: 0,
                    dimension: [
                        {
                            name: "OSType",
                            operator: "Include",
                            values: ["*"],
                        },
                        {
                            name: "Version",
                            operator: "Include",
                            values: ["*"],
                        },
                    ],
                },
            ],
        });
        new metricalert.MetricAlert(stack, "metricAlert2", {
            name: `metricalert2-${randomName}`,
            resourceGroup: resourceGroup,
            scopes: [logAnalyticsWorkspace.id],
            criteria: [
                {
                    metricName: "Heartbeat",
                    metricNamespace: "Microsoft.operationalinsights/workspaces",
                    aggregation: "Average",
                    operator: "LessThan",
                    threshold: 0,
                },
            ],
        });
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    afterEach(() => {
        try {
            (0, testing_1.TerraformDestroy)(fullSynthResult, streamOutput);
        }
        catch (error) {
            console.error("Error during Terraform destroy:", error);
        }
    });
    it("check if stack can be deployed", () => {
        (0, testing_1.TerraformApplyAndCheckIdempotency)(fullSynthResult, streamOutput); // Set to true to stream output
    });
});
//# sourceMappingURL=data:application/json;base64,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