"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const provider_1 = require("@cdktf/provider-azurerm/lib/provider");
const resource_group_1 = require("@cdktf/provider-azurerm/lib/resource-group");
const cdktf_1 = require("cdktf");
const metricalert = require("../../azure-metricalert");
const testing_1 = require("../../testing");
require("cdktf/lib/testing/adapters/jest");
describe("Azure Metric Alert With Defaults", () => {
    let stack;
    let fullSynthResult;
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "test");
        new provider_1.AzurermProvider(stack, "azureQueryRuleAlert", { features: {} });
        const rg = new resource_group_1.ResourceGroup(stack, "MyResourceGroup", {
            name: "rg-test",
            location: "eastus",
        });
        new metricalert.MetricAlert(stack, "testAzureQueryRuleAlert", {
            name: "metric alert test",
            resourceGroup: rg,
            scopes: ["/subscriptions/00000000-0000-0000-0000-000000000000"],
            criteria: [
                {
                    metricName: "Heartbeat",
                    metricNamespace: "Microsoft.operationalinsights/workspaces",
                    aggregation: "Average",
                    operator: "LessThan",
                    threshold: 0,
                },
            ],
        });
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    it("renders an Azure Metric Alert with defaults and checks snapshot", () => {
        expect(cdktf_1.Testing.synth(stack)).toMatchSnapshot(); // Compare the already prepared stack
    });
    it("check if the produced terraform configuration is valid", () => {
        expect(fullSynthResult).toBeValidTerraform(); // Use the saved result
    });
    it("check if this can be planned", () => {
        (0, testing_1.TerraformPlan)(fullSynthResult); // Use the saved result
    });
});
//# sourceMappingURL=data:application/json;base64,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