import { RuleConfig } from ".";
/**
 * Properties for defining overrides for a rule in an Azure Network Security Group.
 */
export interface RuleOverrides {
    /**
     * Optional source address prefix to be matched for the rule. This can be an IP address or a range of IP addresses.
     * If not specified, the default behavior is to match any source address.
     */
    readonly sourceAddressPrefix?: string;
    /**
     * Optional destination address prefix to be matched for the rule. Similar to the source address prefix,
     * this can be a specific IP address or a range. If not provided, it defaults to matching any destination address.
     */
    readonly destinationAddressPrefix?: string;
    /**
     * Optional priority for the rule. Rules are processed in the order of their priority,
     * with lower numbers processed before higher numbers. If not provided, a default priority will be assigned.
     */
    readonly priority?: number;
}
export declare class PreconfiguredRules {
    static activeDirectoryAllowADReplication: RuleConfig;
    static activeDirectoryAllowADReplicationSSL: RuleConfig;
    static activeDirectoryAllowADGCReplication: RuleConfig;
    static activeDirectoryAllowADGCReplicationSSL: RuleConfig;
    static activeDirectoryAllowDNS: RuleConfig;
    static activeDirectoryAllowKerberosAuthentication: RuleConfig;
    static activeDirectoryAllowADReplicationTrust: RuleConfig;
    static activeDirectoryAllowSMTPReplication: RuleConfig;
    static activeDirectoryAllowRPCReplication: RuleConfig;
    static activeDirectoryAllowFileReplication: RuleConfig;
    static activeDirectoryAllowWindowsTime: RuleConfig;
    static activeDirectoryAllowPasswordChangeKerberes: RuleConfig;
    static activeDirectoryAllowDFSGroupPolicy: RuleConfig;
    static activeDirectoryAllowADDSWebServices: RuleConfig;
    static activeDirectoryAllowNETBIOSAuthentication: RuleConfig;
    static activeDirectoryAllowNETBIOSReplication: RuleConfig;
    static cassandra: RuleConfig;
    static cassandraJmx: RuleConfig;
    static cassandraThrift: RuleConfig;
    static couchDb: RuleConfig;
    static couchDbHttps: RuleConfig;
    static dnsTcp: RuleConfig;
    static dnsUdp: RuleConfig;
    static dynamicPorts: RuleConfig;
    static elasticSearch: RuleConfig;
    static ftp: RuleConfig;
    static httpTcp: RuleConfig;
    static httpUdp: RuleConfig;
    static https: RuleConfig;
    static imap: RuleConfig;
    static imaps: RuleConfig;
    static kestrel: RuleConfig;
    static ldap: RuleConfig;
    static mongoDB: RuleConfig;
    static memcached: RuleConfig;
    static mssql: RuleConfig;
    static mySQL: RuleConfig;
    static neo4J: RuleConfig;
    static pop3: RuleConfig;
    static pop3s: RuleConfig;
    static postgreSQL: RuleConfig;
    static rabbitMQ: RuleConfig;
    static rdp: RuleConfig;
    static redis: RuleConfig;
    static riak: RuleConfig;
    static riakJMX: RuleConfig;
    static smtp: RuleConfig;
    static smtps: RuleConfig;
    static ssh: RuleConfig;
    static winRM: RuleConfig;
    static applyRuleOverrides(baseRule: RuleConfig, overrides: RuleOverrides): RuleConfig;
    static addSourceAddress(rule: RuleConfig, sourceAddressPrefix: string): RuleConfig;
    static addDestinationAddress(rule: RuleConfig, destinationAddressPrefix: string): RuleConfig;
    static addPriority(rule: RuleConfig, priority: number): RuleConfig;
}
