"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PreconfiguredRules = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
class PreconfiguredRules {
    static applyRuleOverrides(baseRule, overrides) {
        return {
            ...baseRule,
            ...overrides,
        };
    }
    static addSourceAddress(rule, sourceAddressPrefix) {
        return { ...rule, sourceAddressPrefix };
    }
    static addDestinationAddress(rule, destinationAddressPrefix) {
        return { ...rule, destinationAddressPrefix };
    }
    static addPriority(rule, priority) {
        return { ...rule, priority };
    }
}
exports.PreconfiguredRules = PreconfiguredRules;
_a = JSII_RTTI_SYMBOL_1;
PreconfiguredRules[_a] = { fqn: "@microsoft/terraform-cdk-constructs.azure_networksecuritygroup.PreconfiguredRules", version: "0.0.3-pre.12" };
// Active Directory
PreconfiguredRules.activeDirectoryAllowADReplication = {
    direction: "Inbound",
    access: "Allow",
    protocol: "*",
    sourcePortRange: "*",
    destinationPortRange: "389",
    name: "AllowADReplication",
    priority: 601,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
PreconfiguredRules.activeDirectoryAllowADReplicationSSL = {
    direction: "Inbound",
    access: "Allow",
    protocol: "*",
    sourcePortRange: "*",
    destinationPortRange: "636",
    name: "AllowADReplicationSSL",
    priority: 602,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
PreconfiguredRules.activeDirectoryAllowADGCReplication = {
    direction: "Inbound",
    access: "Allow",
    protocol: "*",
    sourcePortRange: "*",
    destinationPortRange: "3268",
    name: "AllowADGCReplication",
    priority: 603,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
PreconfiguredRules.activeDirectoryAllowADGCReplicationSSL = {
    direction: "Inbound",
    access: "Allow",
    protocol: "*",
    sourcePortRange: "*",
    destinationPortRange: "3269",
    name: "AllowADGCReplicationSSL",
    priority: 604,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
PreconfiguredRules.activeDirectoryAllowDNS = {
    direction: "Inbound",
    access: "Allow",
    protocol: "*",
    sourcePortRange: "*",
    destinationPortRange: "53",
    name: "AllowDNS",
    priority: 605,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
PreconfiguredRules.activeDirectoryAllowKerberosAuthentication = {
    direction: "Inbound",
    access: "Allow",
    protocol: "*",
    sourcePortRange: "*",
    destinationPortRange: "88",
    name: "AllowKerberosAuthentication",
    priority: 606,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
PreconfiguredRules.activeDirectoryAllowADReplicationTrust = {
    direction: "Inbound",
    access: "Allow",
    protocol: "*",
    sourcePortRange: "*",
    destinationPortRange: "445",
    name: "AllowADReplicationTrust",
    priority: 607,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
PreconfiguredRules.activeDirectoryAllowSMTPReplication = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "25",
    name: "AllowSMTPReplication",
    priority: 608,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
PreconfiguredRules.activeDirectoryAllowRPCReplication = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "135",
    name: "AllowRPCReplication",
    priority: 609,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
PreconfiguredRules.activeDirectoryAllowFileReplication = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "5722",
    name: "AllowFileReplication",
    priority: 610,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
PreconfiguredRules.activeDirectoryAllowWindowsTime = {
    direction: "Inbound",
    access: "Allow",
    protocol: "UDP",
    sourcePortRange: "*",
    destinationPortRange: "123",
    name: "AllowWindowsTime",
    priority: 611,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
PreconfiguredRules.activeDirectoryAllowPasswordChangeKerberes = {
    direction: "Inbound",
    access: "Allow",
    protocol: "*",
    sourcePortRange: "*",
    destinationPortRange: "464",
    name: "AllowPasswordChangeKerberes",
    priority: 612,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
PreconfiguredRules.activeDirectoryAllowDFSGroupPolicy = {
    direction: "Inbound",
    access: "Allow",
    protocol: "UDP",
    sourcePortRange: "*",
    destinationPortRange: "138",
    name: "AllowDFSGroupPolicy",
    priority: 613,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
PreconfiguredRules.activeDirectoryAllowADDSWebServices = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "9389",
    name: "AllowADDSWebServices",
    priority: 614,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
PreconfiguredRules.activeDirectoryAllowNETBIOSAuthentication = {
    direction: "Inbound",
    access: "Allow",
    protocol: "UDP",
    sourcePortRange: "*",
    destinationPortRange: "137",
    name: "AllowNETBIOSAuthentication",
    priority: 615,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
PreconfiguredRules.activeDirectoryAllowNETBIOSReplication = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "139",
    name: "AllowNETBIOSReplication",
    priority: 616,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// Cassandra
PreconfiguredRules.cassandra = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "9042",
    name: "Cassandra",
    priority: 551,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
PreconfiguredRules.cassandraJmx = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "7199",
    name: "Cassandra-JMX",
    priority: 552,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
PreconfiguredRules.cassandraThrift = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "9160",
    name: "Cassandra-Thrift",
    priority: 553,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// CouchDB
PreconfiguredRules.couchDb = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "5984",
    name: "CouchDB",
    priority: 554,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
PreconfiguredRules.couchDbHttps = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "6984",
    name: "CouchDB-HTTPS",
    priority: 555,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// DNS-Tcp
PreconfiguredRules.dnsTcp = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "53",
    name: "DNS-Tcp",
    priority: 520,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// DNS-UDP
PreconfiguredRules.dnsUdp = {
    direction: "Inbound",
    access: "Allow",
    protocol: "UDP",
    sourcePortRange: "*",
    destinationPortRange: "53",
    name: "DNS-UDP",
    priority: 521,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// DynamicPorts
PreconfiguredRules.dynamicPorts = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "49152-65535",
    name: "DynamicPorts",
    priority: 650,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// ElasticSearch
PreconfiguredRules.elasticSearch = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "9200-9300",
    name: "ElasticSearch",
    priority: 556,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// FTP
PreconfiguredRules.ftp = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "21",
    name: "FTP",
    priority: 512,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// HTTP-Tcp
PreconfiguredRules.httpTcp = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "80",
    name: "HTTP",
    priority: 513,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// HTTP-UDP
PreconfiguredRules.httpUdp = {
    direction: "Inbound",
    access: "Allow",
    protocol: "UDP",
    sourcePortRange: "*",
    destinationPortRange: "80",
    name: "HTTP",
    priority: 514,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// HTTPS-Tcp
PreconfiguredRules.https = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "443",
    name: "HTTPS",
    priority: 515,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// IMAP
PreconfiguredRules.imap = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "143",
    name: "IMAP",
    priority: 516,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// IMAPS
PreconfiguredRules.imaps = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "993",
    name: "IMAPS",
    priority: 516,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// Kestrel
PreconfiguredRules.kestrel = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "22133",
    name: "Kestrel",
    priority: 517,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// LDAP
PreconfiguredRules.ldap = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "389",
    name: "LDAP",
    priority: 558,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// MongoDB
PreconfiguredRules.mongoDB = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "27017",
    name: "MongoDB",
    priority: 559,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// Memcached
PreconfiguredRules.memcached = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "11211",
    name: "Memcached",
    priority: 560,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// MSSQL
PreconfiguredRules.mssql = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "1433",
    name: "MSSQL",
    priority: 561,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// MySQL
PreconfiguredRules.mySQL = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "3306",
    name: "MySQL",
    priority: 562,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// Neo4J
PreconfiguredRules.neo4J = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "7474",
    name: "Neo4J",
    priority: 563,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// POP3
PreconfiguredRules.pop3 = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "110",
    name: "POP3",
    priority: 564,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// POP3S
PreconfiguredRules.pop3s = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "995",
    name: "POP3S",
    priority: 565,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// PostgreSQL
PreconfiguredRules.postgreSQL = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "5432",
    name: "PostgreSQL",
    priority: 566,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// RabbitMQ
PreconfiguredRules.rabbitMQ = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "5672",
    name: "RabbitMQ",
    priority: 567,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// RDP
PreconfiguredRules.rdp = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "3389",
    name: "RDP",
    priority: 505,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// Redis
PreconfiguredRules.redis = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "6379",
    name: "Redis",
    priority: 568,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// Riak
PreconfiguredRules.riak = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "8093",
    name: "Riak",
    priority: 568,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// RiakJMX
PreconfiguredRules.riakJMX = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "8985",
    name: "Riak-JMX",
    priority: 569,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// SMTP
PreconfiguredRules.smtp = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "25",
    name: "SMTP",
    priority: 570,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// SMTPS
PreconfiguredRules.smtps = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "465",
    name: "SMTPS",
    priority: 571,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// SSH
PreconfiguredRules.ssh = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "22",
    name: "SSH",
    priority: 501,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
// WinRM
PreconfiguredRules.winRM = {
    direction: "Inbound",
    access: "Allow",
    protocol: "Tcp",
    sourcePortRange: "*",
    destinationPortRange: "5986",
    name: "WinRM",
    priority: 502,
    sourceAddressPrefix: "*",
    destinationAddressPrefix: "*",
};
//# sourceMappingURL=data:application/json;base64,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