"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const data_azurerm_client_config_1 = require("@cdktf/provider-azurerm/lib/data-azurerm-client-config");
const provider_1 = require("@cdktf/provider-azurerm/lib/provider");
const resource_group_1 = require("@cdktf/provider-azurerm/lib/resource-group");
const subnet_1 = require("@cdktf/provider-azurerm/lib/subnet");
const virtual_network_1 = require("@cdktf/provider-azurerm/lib/virtual-network");
const cdktf_1 = require("cdktf");
const network = require("..");
const testing_1 = require("../../testing");
const randomName_1 = require("../../util/randomName");
const preconfigured_rules_1 = require("../lib/preconfigured-rules");
require("cdktf/lib/testing/adapters/jest");
describe("Example of deploying a Network Security Group", () => {
    let stack;
    let fullSynthResult;
    const streamOutput = process.env.STREAM_OUTPUT !== "false";
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "test");
        const randomName = (0, randomName_1.generateRandomName)(12);
        const clientConfig = new data_azurerm_client_config_1.DataAzurermClientConfig(stack, "CurrentClientConfig", {});
        new provider_1.AzurermProvider(stack, "azureFeature", { features: {} });
        // Create a resource group
        const resourceGroup = new resource_group_1.ResourceGroup(stack, "rg", {
            name: `rg-${randomName}`,
            location: "eastus",
        });
        const vnet = new virtual_network_1.VirtualNetwork(stack, "vnet", {
            name: `vnet-${randomName}`,
            location: resourceGroup.location,
            resourceGroupName: resourceGroup.name,
            addressSpace: ["10.0.0.0/16"],
        });
        const subnet = new subnet_1.Subnet(stack, "subnet1", {
            name: "subnet1",
            resourceGroupName: resourceGroup.name,
            virtualNetworkName: vnet.name,
            addressPrefixes: ["10.0.1.0/24"],
        });
        const subnet2 = new subnet_1.Subnet(stack, "subnet2", {
            name: "subnet2",
            resourceGroupName: resourceGroup.name,
            virtualNetworkName: vnet.name,
            addressPrefixes: ["10.0.2.0/24"],
        });
        const nsg = new network.SecurityGroup(stack, "nsg", {
            name: `nsg-${randomName}`,
            location: "eastus",
            resourceGroup: resourceGroup,
            rules: [
                {
                    name: "SSH",
                    priority: 1001,
                    direction: "Inbound",
                    access: "Allow",
                    protocol: "Tcp",
                    sourcePortRange: "*",
                    destinationPortRange: "22",
                    sourceAddressPrefix: "10.23.15.38",
                    destinationAddressPrefix: "VirtualNetwork",
                },
                preconfigured_rules_1.PreconfiguredRules.addSourceAddress(preconfigured_rules_1.PreconfiguredRules.rdp, "10.0.0.0/24"),
            ],
        });
        //RBAC
        nsg.addAccess(clientConfig.objectId, "Contributor");
        // associate the nsg to the subnet
        nsg.associateToSubnet(subnet);
        nsg.associateToSubnet(subnet2);
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    afterEach(() => {
        try {
            (0, testing_1.TerraformDestroy)(fullSynthResult, streamOutput);
        }
        catch (error) {
            console.error("Error during Terraform destroy:", error);
        }
    });
    it("check if stack can be deployed", () => {
        (0, testing_1.TerraformApplyAndCheckIdempotency)(fullSynthResult, streamOutput); // Set to true to stream output
    });
});
//# sourceMappingURL=data:application/json;base64,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