"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const provider_1 = require("@cdktf/provider-azurerm/lib/provider");
const cdktf_1 = require("cdktf");
const network = require("..");
const testing_1 = require("../../testing");
require("cdktf/lib/testing/adapters/jest");
describe("Azure Network Security Group With Defaults", () => {
    let stack;
    let fullSynthResult;
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "test");
        new provider_1.AzurermProvider(stack, "azureFeature", { features: {} });
        // Create a network security group with the defined rules
        new network.SecurityGroup(stack, "testAzureNetworkSecurityGroupDefaults", {
            name: "my-nsg",
            location: "eastus",
            rules: [
                network.PreconfiguredRules.addSourceAddress(network.PreconfiguredRules.ssh, "10.0.0.0/24"),
            ],
        });
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    it("renders an Azure Network Security Group with defaults and checks snapshot", () => {
        expect(cdktf_1.Testing.synth(stack)).toMatchSnapshot(); // Compare the already prepared stack
    });
    it("check if the produced terraform configuration is valid", () => {
        expect(fullSynthResult).toBeValidTerraform(); // Use the saved result
    });
    it("check if this can be planned", () => {
        (0, testing_1.TerraformPlan)(fullSynthResult); // Use the saved result
    });
});
//# sourceMappingURL=data:application/json;base64,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