"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const log_analytics_workspace_1 = require("@cdktf/provider-azurerm/lib/log-analytics-workspace");
const provider_1 = require("@cdktf/provider-azurerm/lib/provider");
const resource_group_1 = require("@cdktf/provider-azurerm/lib/resource-group");
const cdktf_1 = require("cdktf");
const queryalert = require("../../azure-queryrulealert");
const testing_1 = require("../../testing");
const randomName_1 = require("../../util/randomName");
require("cdktf/lib/testing/adapters/jest");
describe("Example of deploying a Query Alert", () => {
    let stack;
    let fullSynthResult;
    const streamOutput = process.env.STREAM_OUTPUT !== "false";
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "test");
        const randomName = (0, randomName_1.generateRandomName)(12);
        new provider_1.AzurermProvider(stack, "azureFeature", { features: {} });
        // Create a resource group
        const resourceGroup = new resource_group_1.ResourceGroup(stack, "rg", {
            name: `rg-${randomName}`,
            location: "eastus",
        });
        const logAnalyticsWorkspace = new log_analytics_workspace_1.LogAnalyticsWorkspace(stack, "log_analytics", {
            location: "eastus",
            name: `la-${randomName}`,
            resourceGroupName: resourceGroup.name,
        });
        // Query Rule Alert
        new queryalert.QueryRuleAlert(stack, "queryRuleAlert", {
            name: `qra-${randomName}`,
            resourceGroup: resourceGroup,
            location: "eastus",
            criteriaOperator: "GreaterThan",
            criteriaQuery: `
AppExceptions 
| where Message has "file can not be reloaded"
`,
            criteriaThreshold: 100,
            criteriatimeAggregationMethod: "Count",
            evaluationFrequency: "PT5M",
            windowDuration: "PT30M",
            scopes: [logAnalyticsWorkspace.id],
            severity: 4,
            criteriaFailMinimumFailingPeriodsToTriggerAlert: 1,
            criteriaFailNumberOfEvaluationPeriods: 1,
        });
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    afterEach(() => {
        try {
            (0, testing_1.TerraformDestroy)(fullSynthResult, streamOutput);
        }
        catch (error) {
            console.error("Error during Terraform destroy:", error);
        }
    });
    it("check if stack can be deployed", () => {
        (0, testing_1.TerraformApplyAndCheckIdempotency)(fullSynthResult, streamOutput); // Set to true to stream output
    });
});
//# sourceMappingURL=data:application/json;base64,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