"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const provider_1 = require("@cdktf/provider-azurerm/lib/provider");
const resource_group_1 = require("@cdktf/provider-azurerm/lib/resource-group");
const cdktf_1 = require("cdktf");
const queryalert = require("../../azure-queryrulealert");
const testing_1 = require("../../testing");
require("cdktf/lib/testing/adapters/jest");
describe("Azure Query Rule Alert With Defaults", () => {
    let stack;
    let fullSynthResult;
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "test");
        new provider_1.AzurermProvider(stack, "azureQueryRuleAlert", { features: {} });
        const rg = new resource_group_1.ResourceGroup(stack, "MyResourceGroup", {
            name: "rg-test",
            location: "eastus",
        });
        new queryalert.QueryRuleAlert(stack, "testAzureQueryRuleAlert", {
            name: "alert test",
            resourceGroup: rg,
            location: "eastus",
            criteriaOperator: "GreaterThan",
            criteriaQuery: `
AppExceptions 
| where Message has "file can not be reloaded"
`,
            criteriaThreshold: 100,
            criteriatimeAggregationMethod: "Count",
            evaluationFrequency: "PT5M",
            windowDuration: "PT30M",
            scopes: ["/subscriptions/00000000-0000-0000-0000-000000000000"],
            severity: 3,
            criteriaFailMinimumFailingPeriodsToTriggerAlert: 1,
            criteriaFailNumberOfEvaluationPeriods: 1,
        });
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    it("renders an Azure Query Rule Alert with defaults and checks snapshot", () => {
        expect(cdktf_1.Testing.synth(stack)).toMatchSnapshot(); // Compare the already prepared stack
    });
    it("check if the produced terraform configuration is valid", () => {
        expect(fullSynthResult).toBeValidTerraform(); // Use the saved result
    });
    it("check if this can be planned", () => {
        (0, testing_1.TerraformPlan)(fullSynthResult); // Use the saved result
    });
});
//# sourceMappingURL=data:application/json;base64,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