"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Group = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const resource_group_1 = require("@cdktf/provider-azurerm/lib/resource-group");
const cdktf = require("cdktf");
const lib_1 = require("../../core-azure/lib");
class Group extends lib_1.AzureResource {
    /**
     * Represents an Azure Resource Group.
     *
     * This class is responsible for the creation and management of an Azure Resource Group, which is a container that holds
     * related resources for an Azure solution. A resource group includes those resources that you want to manage as a group.
     * You decide how to allocate resources to resource groups based on what makes the most sense for your organization.
     *
     * @param scope - The scope in which to define this construct, typically representing the Cloud Development Kit (CDK) stack.
     * @param id - The unique identifier for this instance of the Resource Group.
     * @param props - Optional properties for configuring the Resource Group. These can include:
     *                - `location`: The Azure region where the Resource Group will be created.
     *                - `name`: The name of the Resource Group, which must be unique within your Azure subscription.
     *                - `tags`: A dictionary of tags to apply to the Resource Group for organizational, billing, or other purposes.
     *                - `ignoreChanges`: A list of properties which should be ignored if changes are made after initial deployment,
     *                  useful in certain scenarios where properties are externally managed or should not trigger updates.
     *
     * Example usage:
     * ```typescript
     * new Group(this, 'MyResourceGroup', {
     *   location: 'East US',
     *   name: 'ApplicationResources',
     *   tags: {
     *     environment: 'production'
     *   }
     * });
     * ```
     * This class sets up the resource group and applies any specified configurations, making it ready to hold other Azure resources.
     */
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.props = props;
        const defaults = {
            name: props.name || `rg-${this.node.path.split("/")[0]}`,
            location: props.location || "eastus",
        };
        const azurermResourceGroupRg = new resource_group_1.ResourceGroup(this, "rg", {
            ...defaults,
            tags: props.tags,
        });
        azurermResourceGroupRg.addOverride("lifecycle", [
            {
                ignore_changes: props.ignoreChanges || [],
            },
        ]);
        this.id = azurermResourceGroupRg.id;
        this.name = azurermResourceGroupRg.name;
        this.location = azurermResourceGroupRg.location;
        this.resourceGroup = azurermResourceGroupRg;
        // Terraform Outputs
        this.idOutput = new cdktf.TerraformOutput(this, "id", {
            value: azurermResourceGroupRg.id,
        });
        this.locationOutput = new cdktf.TerraformOutput(this, "location", {
            value: azurermResourceGroupRg.location,
        });
        this.nameOutput = new cdktf.TerraformOutput(this, "name", {
            value: azurermResourceGroupRg.name,
        });
        /*This allows the Terraform resource name to match the original name. You can remove the call if you don't need them to match.*/
        this.locationOutput.overrideLogicalId("location");
        this.nameOutput.overrideLogicalId("name");
        this.idOutput.overrideLogicalId("id");
    }
}
exports.Group = Group;
_a = JSII_RTTI_SYMBOL_1;
Group[_a] = { fqn: "@microsoft/terraform-cdk-constructs.azure_resourcegroup.Group", version: "0.0.3-pre.12" };
//# sourceMappingURL=data:application/json;base64,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