"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const provider_1 = require("@cdktf/provider-azurerm/lib/provider");
const cdktf_1 = require("cdktf");
const rg = require("..");
const testing_1 = require("../../testing");
const randomName_1 = require("../../util/randomName");
require("cdktf/lib/testing/adapters/jest");
describe("Resource Group With Defaults", () => {
    let stack;
    let fullSynthResult;
    const streamOutput = process.env.STREAM_OUTPUT !== "false";
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "test");
        const randomName = (0, randomName_1.generateRandomName)(12);
        new provider_1.AzurermProvider(stack, "azureFeature", { features: {} });
        new rg.Group(stack, "testRG", {
            name: `rg-${randomName}`,
            location: "eastus",
            tags: {
                name: "test",
                Env: "NonProd",
            },
            ignoreChanges: ['tags["Environment"]', 'tags["SkipSecurity"]'],
        });
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    afterEach(() => {
        try {
            (0, testing_1.TerraformDestroy)(fullSynthResult, streamOutput);
        }
        catch (error) {
            console.error("Error during Terraform destroy:", error);
        }
    });
    it("check if this can be deployed", () => {
        (0, testing_1.TerraformApplyAndCheckIdempotency)(fullSynthResult, streamOutput); // Set to true to stream output
    });
});
//# sourceMappingURL=data:application/json;base64,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