"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.File = exports.FileShare = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const storage_share_1 = require("@cdktf/provider-azurerm/lib/storage-share");
const storage_share_file_1 = require("@cdktf/provider-azurerm/lib/storage-share-file");
const constructs_1 = require("constructs");
class FileShare extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.files = new Map();
        const share = new storage_share_1.StorageShare(this, "share", {
            name: props.name,
            storageAccountName: props.storageAccountName,
            quota: props.quota,
            accessTier: props.accessTier,
            enabledProtocol: props.enabledProtocol,
            acl: props.acl,
            metadata: props.metadata,
        });
        this.name = share.name;
        this.storageAccountName = share.storageAccountName;
        this.storageShareName = share.name;
        this.id = share.id;
    }
    /**
     * Adds a file to the Azure Storage File Share.
     *
     * @param fileName The name of the file to be added.
     * @param fileSource Optional path or URL to the source of the file's content.
     * @param props Optional configuration properties for the file, such as content type, encoding, and metadata.
     * @returns The created AzureStorageShareFile instance.
     *
     * This method allows you to add a file to your Azure Storage File Share, optionally specifying
     * the file's content source and other properties like content type, encoding, and metadata.
     * If `fileSource` is provided, the content of the file is sourced from this location.
     * The `props` parameter allows for further customization of the file, such as setting the content type
     * (default is 'application/octet-stream') and adding metadata.
     *
     * Example usage:
     * ```typescript
     * const storageShareFile = storageShare.addFile('example.txt', './path/to/local/file.txt', {
     *   contentType: 'text/plain',
     *   metadata: { customKey: 'customValue' }
     * });
     * ```
     *
     * In this example, a text file named 'example.txt' is added to the storage share. The content of the file
     * is sourced from a local file, and the content type is specified as 'text/plain' with custom metadata.
     */
    addFile(fileName, fileSource, props) {
        const newStorageFile = new File(this, "file", {
            name: fileName,
            storageShareId: this.id,
            contentDisposition: props?.contentDisposition,
            contentEncoding: props?.contentEncoding,
            contentMd5: props?.contentMd5,
            source: fileSource,
            contentType: props?.contentType || "application/octet-stream",
            metadata: props?.metadata || {},
        });
        this.files.set(fileName, newStorageFile);
        return newStorageFile;
    }
}
exports.FileShare = FileShare;
_a = JSII_RTTI_SYMBOL_1;
FileShare[_a] = { fqn: "@microsoft/terraform-cdk-constructs.azure_storageaccount.FileShare", version: "0.0.3-pre.12" };
class File extends constructs_1.Construct {
    /**
     * Represents a file within an Azure Storage Share.
     *
     * This class is responsible for the creation and management of a file in an Azure Storage Share, which allows for cloud file storage
     * that can be accessed and managed like a file system. The File class enables detailed configuration of file properties including
     * content type, encoding, and metadata, making it suitable for storing and accessing various types of data.
     *
     * @param scope - The scope in which to define this construct, typically representing the Cloud Development Kit (CDK) stack.
     * @param id - The unique identifier for this instance of the file.
     * @param props - Configuration properties for the Azure Storage Share File. These properties include:
     *                - `name`: The name of the file within the storage share.
     *                - `storageShareId`: The identifier for the storage share in which this file is located.
     *                - `source`: The source of the file's content, which can be a path to a local file or a URL.
     *                - `contentType`: The MIME type of the file's content, helping clients handle the file appropriately when downloaded.
     *                - `contentEncoding`: The encoding format of the file's content (e.g., 'gzip').
     *                - `contentDisposition`: Provides instructions on how the content should be displayed or handled.
     *                - `contentMd5`: An MD5 hash of the file content for verifying the integrity of the file upon transfer.
     *                - `metadata`: A dictionary of key-value pairs to store as metadata with the file. Metadata is typically used to store additional
     *                  details about the file such as tags, descriptions, or other attributes.
     *
     * Example usage:
     * ```typescript
     * const myFile = new File(this, 'MyFile', {
     *   name: 'examplefile.txt',
     *   storageShareId: 'share123',
     *   source: './path/to/local/file.txt',
     *   contentType: 'text/plain',
     *   contentEncoding: 'utf-8',
     *   metadata: {
     *     createdBy: 'John Doe'
     *   }
     * });
     * ```
     * This class initializes a file with the specified configurations and handles the uploading of content from the specified source, providing
     * a way to manage file storage in Azure efficiently.
     */
    constructor(scope, id, props) {
        super(scope, id);
        const file = new storage_share_file_1.StorageShareFile(this, "file", {
            name: props.name,
            storageShareId: props.storageShareId,
            source: props.source,
            contentType: props.contentType,
            contentEncoding: props.contentEncoding,
            contentDisposition: props.contentDisposition,
            contentMd5: props.contentMd5,
            metadata: props.metadata,
        });
        this.name = props.name;
        this.id = file.id;
    }
}
exports.File = File;
_b = JSII_RTTI_SYMBOL_1;
File[_b] = { fqn: "@microsoft/terraform-cdk-constructs.azure_storageaccount.File", version: "0.0.3-pre.12" };
//# sourceMappingURL=data:application/json;base64,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