"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Queue = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const storage_queue_1 = require("@cdktf/provider-azurerm/lib/storage-queue");
const constructs_1 = require("constructs");
class Queue extends constructs_1.Construct {
    /**
     * Represents an Azure Storage Queue within a specific Azure Storage Account.
     *
     * This class is responsible for the creation and management of an Azure Storage Queue, which is a service for storing large numbers
     * of messages that can be accessed from anywhere in the world via authenticated calls using HTTP or HTTPS. A single queue message
     * can be up to 64 KB in size, and a queue can contain millions of messages, up to the total capacity limit of a storage account.
     * This class provides a way to manage messages in a scalable and secure manner.
     *
     * @param scope - The scope in which to define this construct, typically representing the Cloud Development Kit (CDK) stack.
     * @param id - The unique identifier for this instance of the queue.
     * @param props - Configuration properties for the Azure Storage Queue. These properties may include:
     *                - `name`: The name of the queue, which must be unique within the storage account.
     *                - `storageAccountName`: The name of the storage account in which this queue is being created.
     *                - `metadata`: A dictionary of strings that represents metadata to associate with the queue.
     *                - `timeouts`: Custom timeout settings for CRUD operations on the queue to manage operation durations and retries.
     *
     * Example usage:
     * ```typescript
     * const myQueue = new Queue(this, 'MyQueue', {
     *   name: 'taskqueue',
     *   storageAccountName: 'mystorageaccount',
     *   metadata: {
     *     department: 'IT'
     *   }
     * });
     * ```
     * This class initializes a storage queue with the specified configurations. It can be used to enqueue and process messages as needed
     * within applications, providing a reliable messaging solution for asynchronous communication and coordination of tasks across systems.
     */
    constructor(scope, id, props) {
        super(scope, id);
        // Create a storage container
        const newQueue = new storage_queue_1.StorageQueue(this, "Queue", {
            name: props.name,
            storageAccountName: props.storageAccountName,
            metadata: props.metadata,
        });
        this.name = newQueue.name;
    }
}
exports.Queue = Queue;
_a = JSII_RTTI_SYMBOL_1;
Queue[_a] = { fqn: "@microsoft/terraform-cdk-constructs.azure_storageaccount.Queue", version: "0.0.3-pre.12" };
//# sourceMappingURL=data:application/json;base64,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