"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Table = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const storage_table_1 = require("@cdktf/provider-azurerm/lib/storage-table");
const constructs_1 = require("constructs");
class Table extends constructs_1.Construct {
    /**
     * Represents an Azure Storage Table within a specific Azure Storage Account.
     *
     * This class is responsible for the creation and management of an Azure Storage Table, which provides a NoSQL key-attribute data store
     * that can massively scale. It is suitable for storing structured, non-relational data, allowing rapid development and fast access to large
     * quantities of data. The class facilitates creating and configuring storage tables including setting up access control lists (ACLs).
     *
     * @param scope - The scope in which to define this construct, typically representing the Cloud Development Kit (CDK) stack.
     * @param id - The unique identifier for this instance of the table.
     * @param props - Configuration properties for the Azure Storage Table. These properties include:
     *                - `name`: The name of the table, which must be unique within the storage account.
     *                - `storageAccountName`: The name of the storage account in which this table is being created.
     *                - `acl`: An optional list of access control entries that define permissions for accessing the table.
     *                - `timeouts`: Optional timeout settings for create/read/update/delete operations on the table.
     *
     * Example usage:
     * ```typescript
     * const storageTable = new Table(this, 'MyTable', {
     *   name: 'tasktable',
     *   storageAccountName: 'mystorageaccount',
     *   acl: [{
     *     id: 'myacl',
     *     permissions: 'rwdl',
     *     start: '2020-01-01T01:00:00Z',
     *     expiry: '2030-01-01T01:00:00Z',
     *     policy: 'mypolicy'
     *   }]
     * });
     * ```
     * This class initializes a storage table with the specified configurations and provides an interface to manage access controls and
     * other properties. It is ideal for applications that require structured, scalable, and fast access to data.
     */
    constructor(scope, id, props) {
        super(scope, id);
        // Create a storage container
        const table = new storage_table_1.StorageTable(this, "table", {
            name: props.name,
            storageAccountName: props.storageAccountName,
            acl: props.acl,
        });
        this.name = table.name;
    }
}
exports.Table = Table;
_a = JSII_RTTI_SYMBOL_1;
Table[_a] = { fqn: "@microsoft/terraform-cdk-constructs.azure_storageaccount.Table", version: "0.0.3-pre.12" };
//# sourceMappingURL=data:application/json;base64,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