"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const data_azurerm_client_config_1 = require("@cdktf/provider-azurerm/lib/data-azurerm-client-config");
const provider_1 = require("@cdktf/provider-azurerm/lib/provider");
const resource_group_1 = require("@cdktf/provider-azurerm/lib/resource-group");
const cdktf_1 = require("cdktf");
const storage = require("..");
const testing_1 = require("../../testing");
const randomName_1 = require("../../util/randomName");
require("cdktf/lib/testing/adapters/jest");
describe("Example of deploying a Storage Account", () => {
    let stack;
    let fullSynthResult;
    const streamOutput = process.env.STREAM_OUTPUT !== "false";
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "test");
        const randomName = (0, randomName_1.generateRandomName)(12);
        const clientConfig = new data_azurerm_client_config_1.DataAzurermClientConfig(stack, "CurrentClientConfig", {});
        new provider_1.AzurermProvider(stack, "azureFeature", {
            features: {},
            storageUseAzuread: true,
        });
        // Create a resource group
        const resourceGroup = new resource_group_1.ResourceGroup(stack, "rg", {
            name: `rg-${randomName}`,
            location: "eastus",
        });
        const storageAccount = new storage.Account(stack, "storageaccount", {
            name: `sta${randomName}8898`,
            resourceGroup: resourceGroup,
            location: "eastus",
            accountReplicationType: "LRS",
            accountTier: "Standard",
            enableHttpsTrafficOnly: true,
            accessTier: "Hot",
            isHnsEnabled: true,
            minTlsVersion: "TLS1_2",
            publicNetworkAccessEnabled: true,
        });
        //RBAC
        storageAccount.addAccess(clientConfig.objectId, "Storage Blob Data Contributor");
        storageAccount.addAccess(clientConfig.objectId, "Storage Queue Data Contributor");
        storageAccount.addAccess(clientConfig.objectId, "Storage Table Data Contributor");
        storageAccount.addAccess(clientConfig.objectId, "Storage File Data SMB Share Contributor");
        // Metric Alert
        storageAccount.addMetricAlert({
            name: "testalert",
            criteria: [
                {
                    metricName: "Availability",
                    metricNamespace: "Microsoft.Storage/storageAccounts",
                    aggregation: "Average",
                    operator: "LessThan",
                    threshold: 0,
                },
            ],
        });
        storageAccount.addNetworkRules({
            bypass: ["AzureServices"],
            defaultAction: "Deny",
            ipRules: ["0.0.0.0/0"],
        });
        // Storage Methods
        storageAccount.addContainer("testcontainer");
        storageAccount.addContainer("testcontainer2");
        storageAccount.addFileShare("testshare");
        storageAccount.addTable("testtable");
        storageAccount.addQueue("testqueue");
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    afterEach(() => {
        try {
            (0, testing_1.TerraformDestroy)(fullSynthResult, streamOutput);
        }
        catch (error) {
            console.error("Error during Terraform destroy:", error);
        }
    });
    it("check if stack can be deployed", () => {
        (0, testing_1.TerraformApplyAndCheckIdempotency)(fullSynthResult, streamOutput);
    });
});
//# sourceMappingURL=data:application/json;base64,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