"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const provider_1 = require("@cdktf/provider-azurerm/lib/provider");
const cdktf_1 = require("cdktf");
const storage = require("..");
const testing_1 = require("../../testing");
require("cdktf/lib/testing/adapters/jest");
describe("Azure Storage Account With Defaults", () => {
    let stack;
    let fullSynthResult;
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "test");
        new provider_1.AzurermProvider(stack, "azureFeature", { features: {} });
        // Create a Storage Account with the defined rules
        new storage.Account(stack, "storageaccount", {
            name: "test42348808",
            location: "eastus",
        });
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    it("renders an Azure Storage Account with defaults and checks snapshot", () => {
        expect(cdktf_1.Testing.synth(stack)).toMatchSnapshot(); // Compare the already prepared stack
    });
    it("check if the produced terraform configuration is valid", () => {
        expect(fullSynthResult).toBeValidTerraform(); // Use the saved result
    });
    it("check if this can be planned", () => {
        (0, testing_1.TerraformPlan)(fullSynthResult); // Use the saved result
    });
});
//# sourceMappingURL=data:application/json;base64,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