import { LinuxVirtualMachineSourceImageReference, LinuxVirtualMachineOsDisk, LinuxVirtualMachineAdminSshKey, LinuxVirtualMachineIdentity, LinuxVirtualMachineSecret, LinuxVirtualMachineAdditionalCapabilities } from "@cdktf/provider-azurerm/lib/linux-virtual-machine";
import { ResourceGroup } from "@cdktf/provider-azurerm/lib/resource-group";
import { Subnet } from "@cdktf/provider-azurerm/lib/subnet";
import { WindowsVirtualMachineOsDisk, WindowsVirtualMachineSourceImageReference } from "@cdktf/provider-azurerm/lib/windows-virtual-machine";
import * as cdktf from "cdktf";
import { Construct } from "constructs";
import { AzureResource } from "../../core-azure/lib";
export interface WindowsVMProps {
    /**
     * The Azure location where the virtual machine should be created.
     * @default "eastus"
     */
    readonly location?: string;
    /**
     * The name of the virtual machine.
     * @default - Uses the name derived from the construct path.
     */
    readonly name?: string;
    /**
     * An optional reference to the resource group in which to deploy the Virtual Machine.
     * If not provided, the Virtual Machine will be deployed in the default resource group.
     */
    readonly resourceGroup?: ResourceGroup;
    /**
     * The size of the virtual machine.
     * @default "Standard_B2s"
     */
    readonly size?: string;
    /**
     * The admin username for the virtual machine.
     */
    readonly adminUsername: string;
    /**
     * The admin password for the virtual machine.
     */
    readonly adminPassword: string;
    /**
     * The source image reference for the virtual machine.
     * @default - Uses WindowsServer2022DatacenterCore.
     */
    readonly sourceImageReference?: WindowsVirtualMachineSourceImageReference;
    /**
     * The ID of the source image for the virtual machine.
     */
    readonly sourceImageId?: string;
    /**
     * Tags to apply to the virtual machine.
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * The OS disk configuration for the virtual machine.
     * @default - Uses a disk with caching set to "ReadWrite" and storage account type "Standard_LRS".
     */
    readonly osDisk?: WindowsVirtualMachineOsDisk;
    /**
     * The subnet in which the virtual machine will be placed.
     * @default - Uses the default subnet from a new virtual network.
     */
    readonly subnet?: Subnet;
    /**
     * The allocation method for the public IP.
     */
    readonly publicIPAllocationMethod?: string;
    /**
     * Custom data to pass to the virtual machine upon creation.
     */
    readonly customData?: string;
    /**
     * Custom data to bootstrap the virtual machine. Automatically triggers Azure Custom Script extension to deploy code in custom data.
     */
    readonly boostrapCustomData?: string;
    /**
     * Bootdiagnostics settings for the VM.
     */
    readonly bootDiagnosticsStorageURI?: string;
    /**
     * Lifecycle settings for the Terraform resource.
     *
     * @remarks
     * This property specifies the lifecycle customizations for the Terraform resource,
     * allowing you to define specific actions to be taken during the lifecycle of the
     * resource. It can include settings such as create before destroy, prevent destroy,
     * ignore changes, etc.
     *
     */
    readonly lifecycle?: cdktf.TerraformMetaArguments["lifecycle"];
}
export declare class WindowsVM extends AzureResource {
    readonly props: WindowsVMProps;
    resourceGroup: ResourceGroup;
    id: string;
    readonly name: string;
    readonly publicIp?: string;
    /**
     * Represents a Windows-based Virtual Machine (VM) within Microsoft Azure.
     *
     * This class is designed to provision and manage a Windows VM in Azure, allowing for detailed configuration including
     * the VM's size, the operating system image, network settings, and administrative credentials. It supports customization
     * of the OS disk, networking setup, and optional features like custom data scripts and boot diagnostics.
     *
     * @param scope - The scope in which to define this construct, typically representing the Cloud Development Kit (CDK) application.
     * @param id - The unique identifier for this instance of the Windows VM, used within the scope for reference.
     * @param props - Configuration properties for the Windows Virtual Machine, derived from the WindowsVMProps interface. These include:
     *                - `location`: The geographic location where the VM will be hosted (e.g., "eastus").
     *                - `name`: The name of the VM, which must be unique within the resource group.
     *                - `resourceGroup`: Optional. Reference to the resource group for deployment.
     *                - `size`: The size specification of the VM (e.g., "Standard_B2s").
     *                - `adminUsername`: The administrator username for accessing the VM.
     *                - `adminPassword`: The administrator password for accessing the VM.
     *                - `sourceImageReference`: A reference to the specific Windows image to be used for the VM.
     *                - `sourceImageId`: The identifier for a custom image to use for the VM.
     *                - `tags`: Key-value pairs for resource tagging.
     *                - `osDisk`: Configuration for the VM's operating system disk.
     *                - `subnet`: Specifies the subnet within which the VM will be placed.
     *                - `publicIPAllocationMethod`: The method used to allocate a public IP address to the VM.
     *                - `customData`: Scripts or commands passed to the VM at startup.
     *                - `bootstrapCustomData`: Custom data used to trigger the Azure Custom Script Extension for VM setup tasks.
     *                - `bootDiagnosticsStorageURI`: URI for storage where VM boot diagnostics are collected.
     *
     * Example usage:
     * ```typescript
     * const vm = new WindowsVM(this, 'MyWindowsVM', {
     *   resourceGroup: myResourceGroup,
     *   name: 'myVM',
     *   size: 'Standard_DS1_v2',
     *   adminUsername: 'adminuser',
     *   adminPassword: 'securepassword123',
     *   sourceImageReference: { publisher: 'MicrosoftWindowsServer', offer: 'WindowsServer', sku: '2019-Datacenter', version: 'latest' },
     *   osDisk: { caching: 'ReadWrite', storageAccountType: 'Standard_LRS' },
     *   subnet: mySubnet,
     *   tags: { environment: 'production' }
     * });
     * ```
     * This class initializes a Windows VM with the specified configurations, handling details like network setup, OS installation,
     * and security settings, thus providing a robust infrastructure for hosting applications on Windows Server environments.
     */
    constructor(scope: Construct, id: string, props: WindowsVMProps);
}
export interface LinuxVMProps {
    /**
     * The Azure location where the virtual machine should be created.
     * @default "eastus"
     */
    readonly location?: string;
    /**
     * The name of the virtual machine.
     * @default - Uses the name derived from the construct path.
     */
    readonly name?: string;
    /**
     * An optional reference to the resource group in which to deploy the Virtual Machine.
     * If not provided, the Virtual Machine will be deployed in the default resource group.
     */
    readonly resourceGroup?: ResourceGroup;
    /**
     * The size of the virtual machine.
     * @default "Standard_B2s"
     */
    readonly size?: string;
    /**
     * The ID of the availability set in which the VM should be placed.
     */
    readonly availabilitySetId?: string;
    /**
     * Custom data to pass to the virtual machine upon creation.
     */
    readonly userData?: string;
    /**
     * An array of SSH keys for the admin user.
     */
    readonly adminSshKey?: LinuxVirtualMachineAdminSshKey[] | cdktf.IResolvable;
    /**
     * The availability zone in which the VM should be placed.
     */
    readonly zone?: string;
    /**
     * Managed identity settings for the VM.
     */
    readonly identity?: LinuxVirtualMachineIdentity;
    /**
     * Additional capabilities like Ultra Disk compatibility.
     */
    readonly additionalCapabilities?: LinuxVirtualMachineAdditionalCapabilities;
    /**
     * An array of secrets to be passed to the VM.
     */
    readonly secret?: LinuxVirtualMachineSecret[];
    /**
     * The admin username for the virtual machine.
     */
    readonly adminUsername?: string;
    /**
     * The admin password for the virtual machine.
     */
    readonly adminPassword?: string;
    /**
     * The source image reference for the virtual machine.
     * @default - Uses WindowsServer2022DatacenterCore.
     */
    readonly sourceImageReference?: LinuxVirtualMachineSourceImageReference;
    /**
     * The ID of the source image for the virtual machine.
     */
    readonly sourceImageId?: string;
    /**
     * Tags to apply to the virtual machine.
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * The OS disk configuration for the virtual machine.
     * @default - Uses a disk with caching set to "ReadWrite" and storage account type "Standard_LRS".
     */
    readonly osDisk?: LinuxVirtualMachineOsDisk;
    /**
     * The subnet in which the virtual machine will be placed.
     * @default - Uses the default subnet from a new virtual network.
     */
    readonly subnet?: Subnet;
    /**
     * The allocation method for the public IP.
     */
    readonly publicIPAllocationMethod?: string;
    /**
     * Custom data to pass to the virtual machine upon creation.
     */
    readonly customData?: string;
    /**
     * Enable SSH Azure AD Login, required managed identity to be set.
     */
    readonly enableSshAzureADLogin?: boolean;
    /**
     * Bootdiagnostics settings for the VM.
     */
    readonly bootDiagnosticsStorageURI?: string;
    /**
     * Lifecycle settings for the Terraform resource.
     *
     * @remarks
     * This property specifies the lifecycle customizations for the Terraform resource,
     * allowing you to define specific actions to be taken during the lifecycle of the
     * resource. It can include settings such as create before destroy, prevent destroy,
     * ignore changes, etc.
     */
    readonly lifecycle?: cdktf.TerraformMetaArguments["lifecycle"];
}
export declare class LinuxVM extends AzureResource {
    readonly props: LinuxVMProps;
    resourceGroup: ResourceGroup;
    id: string;
    readonly name: string;
    readonly publicIp?: string;
    /**
     * Represents a Linux-based Virtual Machine (VM) within Microsoft Azure.
     *
     * This class is designed to provision and manage a Linux VM in Azure, facilitating detailed configuration including
     * VM size, the operating system image, network settings, and administrative credentials. It supports custom data scripts,
     * SSH configurations, and optional features like managed identity and boot diagnostics.
     *
     * @param scope - The scope in which to define this construct, typically representing the Cloud Development Kit (CDK) application.
     * @param id - The unique identifier for this instance of the Linux VM, used within the scope for reference.
     * @param props - Configuration properties for the Linux Virtual Machine, derived from the LinuxVMProps interface. These include:
     *                - `location`: The geographic location where the VM will be hosted (e.g., "eastus").
     *                - `name`: The name of the VM, which must be unique within the resource group.
     *                - `resourceGroup`: Optional. Reference to the resource group for deployment.
     *                - `size`: The size specification of the VM (e.g., "Standard_B2s").
     *                - `availabilitySetId`: The ID of the availability set in which to include the VM.
     *                - `userData`: Custom data scripts to pass to the VM upon creation.
     *                - `adminSshKey`: SSH keys for secure access to the VM.
     *                - `zone`: The availability zone for deploying the VM.
     *                - `identity`: Managed identity settings for accessing other Azure services.
     *                - `additionalCapabilities`: Special capabilities like Ultra Disk support.
     *                - `sourceImageReference`: A reference to the specific Linux image to be used for the VM.
     *                - `sourceImageId`: The identifier for a custom image to use for the VM.
     *                - `tags`: Key-value pairs for resource tagging.
     *                - `osDisk`: Configuration for the VM's operating system disk.
     *                - `subnet`: Specifies the subnet within which the VM will be placed.
     *                - `publicIPAllocationMethod`: Method used to allocate a public IP address.
     *                - `customData`: Additional scripts or commands passed to the VM at startup.
     *                - `enableSshAzureADLogin`: Option to enable Azure AD login for SSH.
     *                - `bootDiagnosticsStorageURI`: URI for storage where VM boot diagnostics are collected.
     *
     * Example usage:
     * ```typescript
     * const linuxVM = new LinuxVM(this, 'MyLinuxVM', {
     *   resourceGroup: myResourceGroup,
     *   name: 'myVM',
     *   size: 'Standard_DS1_v2',
     *   adminUsername: 'adminuser',
     *   adminSshKey: [{ publicKey: 'ssh-rsa AAAAB...' }],
     *   sourceImageReference: { publisher: 'Canonical', offer: 'UbuntuServer', sku: '18.04-LTS', version: 'latest' },
     *   osDisk: { caching: 'ReadWrite', storageAccountType: 'Standard_LRS' },
     *   subnet: mySubnet,
     *   tags: { environment: 'production' }
     * });
     * ```
     * This class initializes a Linux VM with the specified configurations, handling details like network setup, OS installation,
     * and security settings, thus providing a robust infrastructure for hosting applications on Linux environments.
     */
    constructor(scope: Construct, id: string, props: LinuxVMProps);
}
