"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const provider_1 = require("@cdktf/provider-azurerm/lib/provider");
const cdktf_1 = require("cdktf");
const vm = require("..");
const testing_1 = require("../../testing");
require("cdktf/lib/testing/adapters/jest");
describe("Azure Windows Virtual Machine With Defaults", () => {
    let stack;
    let fullSynthResult;
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "testAzureVMWithDefaults");
        new provider_1.AzurermProvider(stack, "azureFeature", { features: {} });
        new vm.WindowsVM(stack, "testVirtualMachine", {
            adminUsername: "testAdmin",
            adminPassword: "testPassword&@34$$123",
        });
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    it("renders an Azure Windows Virtual Machine with defaults and checks snapshot", () => {
        expect(cdktf_1.Testing.synth(stack)).toMatchSnapshot(); // Compare the already prepared stack
    });
    it("check if the produced terraform configuration is valid", () => {
        expect(fullSynthResult).toBeValidTerraform(); // Use the saved result
    });
    it("check if this can be planned", () => {
        (0, testing_1.TerraformPlan)(fullSynthResult); // Use the saved result
    });
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQXp1cmVXaW5kb3dzVmlydHVhbE1hY2hpbmUuc3BlYy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9henVyZS12aXJ0dWFsbWFjaGluZS90ZXN0L0F6dXJlV2luZG93c1ZpcnR1YWxNYWNoaW5lLnNwZWMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxtRUFBdUU7QUFDdkUsaUNBQWdEO0FBQ2hELHlCQUF5QjtBQUN6QiwyQ0FBOEM7QUFDOUMsMkNBQXlDO0FBRXpDLFFBQVEsQ0FBQyw2Q0FBNkMsRUFBRSxHQUFHLEVBQUU7SUFDM0QsSUFBSSxLQUFxQixDQUFDO0lBQzFCLElBQUksZUFBb0IsQ0FBQztJQUV6QixVQUFVLENBQUMsR0FBRyxFQUFFO1FBQ2QsTUFBTSxHQUFHLEdBQUcsZUFBTyxDQUFDLEdBQUcsRUFBRSxDQUFDO1FBQzFCLEtBQUssR0FBRyxJQUFJLHNCQUFjLENBQUMsR0FBRyxFQUFFLHlCQUF5QixDQUFDLENBQUM7UUFFM0QsSUFBSSwwQkFBZSxDQUFDLEtBQUssRUFBRSxjQUFjLEVBQUUsRUFBRSxRQUFRLEVBQUUsRUFBRSxFQUFFLENBQUMsQ0FBQztRQUU3RCxJQUFJLEVBQUUsQ0FBQyxTQUFTLENBQUMsS0FBSyxFQUFFLG9CQUFvQixFQUFFO1lBQzVDLGFBQWEsRUFBRSxXQUFXO1lBQzFCLGFBQWEsRUFBRSx1QkFBdUI7U0FDdkMsQ0FBQyxDQUFDO1FBRUgsZUFBZSxHQUFHLGVBQU8sQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyw0QkFBNEI7SUFDMUUsQ0FBQyxDQUFDLENBQUM7SUFFSCxFQUFFLENBQUMsNEVBQTRFLEVBQUUsR0FBRyxFQUFFO1FBQ3BGLE1BQU0sQ0FBQyxlQUFPLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsZUFBZSxFQUFFLENBQUMsQ0FBQyxxQ0FBcUM7SUFDdkYsQ0FBQyxDQUFDLENBQUM7SUFFSCxFQUFFLENBQUMsd0RBQXdELEVBQUUsR0FBRyxFQUFFO1FBQ2hFLE1BQU0sQ0FBQyxlQUFlLENBQUMsQ0FBQyxrQkFBa0IsRUFBRSxDQUFDLENBQUMsdUJBQXVCO0lBQ3ZFLENBQUMsQ0FBQyxDQUFDO0lBRUgsRUFBRSxDQUFDLDhCQUE4QixFQUFFLEdBQUcsRUFBRTtRQUN0QyxJQUFBLHVCQUFhLEVBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQyx1QkFBdUI7SUFDekQsQ0FBQyxDQUFDLENBQUM7QUFDTCxDQUFDLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEF6dXJlcm1Qcm92aWRlciB9IGZyb20gXCJAY2RrdGYvcHJvdmlkZXItYXp1cmVybS9saWIvcHJvdmlkZXJcIjtcbmltcG9ydCB7IFRlc3RpbmcsIFRlcnJhZm9ybVN0YWNrIH0gZnJvbSBcImNka3RmXCI7XG5pbXBvcnQgKiBhcyB2bSBmcm9tIFwiLi5cIjtcbmltcG9ydCB7IFRlcnJhZm9ybVBsYW4gfSBmcm9tIFwiLi4vLi4vdGVzdGluZ1wiO1xuaW1wb3J0IFwiY2RrdGYvbGliL3Rlc3RpbmcvYWRhcHRlcnMvamVzdFwiO1xuXG5kZXNjcmliZShcIkF6dXJlIFdpbmRvd3MgVmlydHVhbCBNYWNoaW5lIFdpdGggRGVmYXVsdHNcIiwgKCkgPT4ge1xuICBsZXQgc3RhY2s6IFRlcnJhZm9ybVN0YWNrO1xuICBsZXQgZnVsbFN5bnRoUmVzdWx0OiBhbnk7XG5cbiAgYmVmb3JlRWFjaCgoKSA9PiB7XG4gICAgY29uc3QgYXBwID0gVGVzdGluZy5hcHAoKTtcbiAgICBzdGFjayA9IG5ldyBUZXJyYWZvcm1TdGFjayhhcHAsIFwidGVzdEF6dXJlVk1XaXRoRGVmYXVsdHNcIik7XG5cbiAgICBuZXcgQXp1cmVybVByb3ZpZGVyKHN0YWNrLCBcImF6dXJlRmVhdHVyZVwiLCB7IGZlYXR1cmVzOiB7fSB9KTtcblxuICAgIG5ldyB2bS5XaW5kb3dzVk0oc3RhY2ssIFwidGVzdFZpcnR1YWxNYWNoaW5lXCIsIHtcbiAgICAgIGFkbWluVXNlcm5hbWU6IFwidGVzdEFkbWluXCIsXG4gICAgICBhZG1pblBhc3N3b3JkOiBcInRlc3RQYXNzd29yZCZAMzQkJDEyM1wiLFxuICAgIH0pO1xuXG4gICAgZnVsbFN5bnRoUmVzdWx0ID0gVGVzdGluZy5mdWxsU3ludGgoc3RhY2spOyAvLyBTYXZlIHRoZSByZXN1bHQgZm9yIHJldXNlXG4gIH0pO1xuXG4gIGl0KFwicmVuZGVycyBhbiBBenVyZSBXaW5kb3dzIFZpcnR1YWwgTWFjaGluZSB3aXRoIGRlZmF1bHRzIGFuZCBjaGVja3Mgc25hcHNob3RcIiwgKCkgPT4ge1xuICAgIGV4cGVjdChUZXN0aW5nLnN5bnRoKHN0YWNrKSkudG9NYXRjaFNuYXBzaG90KCk7IC8vIENvbXBhcmUgdGhlIGFscmVhZHkgcHJlcGFyZWQgc3RhY2tcbiAgfSk7XG5cbiAgaXQoXCJjaGVjayBpZiB0aGUgcHJvZHVjZWQgdGVycmFmb3JtIGNvbmZpZ3VyYXRpb24gaXMgdmFsaWRcIiwgKCkgPT4ge1xuICAgIGV4cGVjdChmdWxsU3ludGhSZXN1bHQpLnRvQmVWYWxpZFRlcnJhZm9ybSgpOyAvLyBVc2UgdGhlIHNhdmVkIHJlc3VsdFxuICB9KTtcblxuICBpdChcImNoZWNrIGlmIHRoaXMgY2FuIGJlIHBsYW5uZWRcIiwgKCkgPT4ge1xuICAgIFRlcnJhZm9ybVBsYW4oZnVsbFN5bnRoUmVzdWx0KTsgLy8gVXNlIHRoZSBzYXZlZCByZXN1bHRcbiAgfSk7XG59KTtcbiJdfQ==