"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WindowsCluster = exports.LinuxCluster = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const linux_virtual_machine_scale_set_1 = require("@cdktf/provider-azurerm/lib/linux-virtual-machine-scale-set");
const virtual_machine_scale_set_extension_1 = require("@cdktf/provider-azurerm/lib/virtual-machine-scale-set-extension");
const windows_virtual_machine_scale_set_1 = require("@cdktf/provider-azurerm/lib/windows-virtual-machine-scale-set");
const azure_virtualmachine_1 = require("../../azure-virtualmachine");
const network_1 = require("../../azure-virtualnetwork/lib/network");
const lib_1 = require("../../core-azure/lib");
class LinuxCluster extends lib_1.AzureResource {
    /**
     * Represents a Linux Virtual Machine Scale Set (VMSS) within Microsoft Azure.
     *
     * This class is designed to provision and manage a scale set of Linux virtual machines, providing capabilities such as
     * auto-scaling, high availability, and simplified management. It supports detailed configurations like VM size, operating
     * system image, network settings, and administrative credentials. Additional functionalities include custom data scripts,
     * SSH configurations, and optional features like managed identity and boot diagnostics.
     *
     * @param scope - The scope in which to define this construct, typically representing the Cloud Development Kit (CDK) application.
     * @param id - The unique identifier for this instance of the Linux cluster, used within the scope for reference.
     * @param props - Configuration properties for the Linux VM Scale Set, derived from the LinuxClusterProps interface. These include:
     *                - `location`: The geographic location where the scale set will be hosted (e.g., "eastus").
     *                - `name`: The name of the scale set, which must be unique within the resource group.
     *                - `resourceGroup`: Optional. Reference to the resource group for deployment.
     *                - `sku`: The size specification of the VMs (e.g., "Standard_B2s").
     *                - `adminUsername`: The administrator username for the VMs.
     *                - `adminPassword`: The administrator password for the VMs.
     *                - `adminSshKey`: SSH keys for secure access to the VMs.
     *                - `zones`: The availability zones for deploying the VMs.
     *                - `identity`: Managed identity settings for accessing other Azure services.
     *                - `sourceImageReference`: A reference to the specific Linux image to be used for the VMs.
     *                - `sourceImageId`: The identifier for a custom image to use for the VMs.
     *                - `tags`: Key-value pairs for resource tagging.
     *                - `osDisk`: Configuration for the VMs' operating system disks.
     *                - `subnet`: Specifies the subnet within which the VMs will be placed.
     *                - `publicIPAddress`: Method used to allocate public IP addresses to the VMs.
     *                - `customData`: Scripts or commands passed to the VMs at startup.
     *                - `instances`: The number of VM instances in the scale set.
     *                - `upgradePolicyMode`: The upgrade policy mode for the VMSS.
     *                - `overprovision`: Specifies if the VMSS should be overprovisioned to maintain capacity during updates.
     *                - `scaleInPolicy`: The scale-in policy for the VMSS.
     *                - `bootDiagnosticsStorageURI`: URI for storage where VMSS boot diagnostics are collected.
     *                - `enableSshAzureADLogin`: Option to enable Azure AD login for SSH on the VMs.
     *
     * Example usage:
     * ```typescript
     * const linuxCluster = new LinuxCluster(this, 'MyLinuxCluster', {
     *   resourceGroup: myResourceGroup,
     *   name: 'myCluster',
     *   sku: 'Standard_DS1_v2',
     *   adminUsername: 'adminuser',
     *   adminSshKey: [{ publicKey: 'ssh-rsa AAAAB...' }],
     *   sourceImageReference: { publisher: 'Canonical', offer: 'UbuntuServer', sku: '18.04-LTS', version: 'latest' },
     *   osDisk: { caching: 'ReadWrite', storageAccountType: 'Standard_LRS' },
     *   subnet: mySubnet,
     *   instances: 3,
     *   tags: { environment: 'production' }
     * });
     * ```
     * This class initializes a Linux VM Scale Set with the specified configurations, handling details like VM creation,
     * scaling policies, network setup, OS installation, and security settings, providing a robust and scalable infrastructure
     * for hosting cloud-based Linux applications.
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.resourceGroup = this.setupResourceGroup(props);
        const pathName = this.node.path.split("/")[0];
        const defaults = {
            name: props.name || pathName,
            adminUsername: props.adminUsername || `admin${pathName}`,
            location: props.location || "eastus",
            sku: props.sku || "Standard_B2s",
            instances: props.instances || 1,
            osDisk: props.osDisk || {
                caching: "ReadWrite",
                storageAccountType: "Standard_LRS",
            },
            sourceImageReference: props.sourceImageReference || azure_virtualmachine_1.LinuxImageReferences.ubuntuServer2204LTS,
            subnet: props.subnet ||
                new network_1.Network(this, "vnet", {
                    resourceGroup: this.resourceGroup,
                }).subnets.default,
        };
        const azurermLinuxVirtualMachineScaleSet = new linux_virtual_machine_scale_set_1.LinuxVirtualMachineScaleSet(this, "vmss", {
            ...defaults,
            resourceGroupName: this.resourceGroup.name,
            adminPassword: props.adminPassword,
            disablePasswordAuthentication: props.adminPassword ? false : true,
            tags: props.tags,
            lifecycle: props.lifecycle,
            networkInterface: [
                {
                    name: `nic-${defaults.name}`,
                    primary: true,
                    ipConfiguration: [
                        {
                            name: "internal",
                            subnetId: defaults.subnet.id,
                            primary: true,
                            publicIpAddress: props.publicIPAddress,
                        },
                    ],
                },
            ],
            osDisk: {
                ...defaults.osDisk,
            },
            sourceImageId: props.sourceImageId,
            customData: props.customData
                ? Buffer.from(props.customData).toString("base64")
                : undefined,
            userData: props.userData
                ? Buffer.from(props.userData).toString("base64")
                : undefined,
            adminSshKey: props.adminSshKey,
            identity: props.identity,
        });
        this.id = azurermLinuxVirtualMachineScaleSet.id;
        this.name = azurermLinuxVirtualMachineScaleSet.name;
        this.fqn = azurermLinuxVirtualMachineScaleSet.fqn;
        // Enable SSH Azure AD Login if specified
        if (props.enableSshAzureADLogin) {
            new virtual_machine_scale_set_extension_1.VirtualMachineScaleSetExtensionA(this, "AADSSHlogin", {
                name: "AADSSHLoginForLinux",
                virtualMachineScaleSetId: this.id,
                publisher: "Microsoft.Azure.ActiveDirectory",
                type: "AADSSHLoginForLinux",
                typeHandlerVersion: "1.0",
            });
        }
    }
}
exports.LinuxCluster = LinuxCluster;
_a = JSII_RTTI_SYMBOL_1;
LinuxCluster[_a] = { fqn: "@microsoft/terraform-cdk-constructs.azure_virtualmachinescaleset.LinuxCluster", version: "0.0.3-pre.12" };
class WindowsCluster extends lib_1.AzureResource {
    /**
     * Represents a Windows Virtual Machine Scale Set (VMSS) within Microsoft Azure.
     *
     * This class provides a way to deploy and manage a scale set of Windows virtual machines, allowing for configurations such as
     * auto-scaling, high availability, and simplified patch management. It supports detailed specifications including
     * VM size, the operating system image, network settings, and administrative credentials. Additional capabilities include
     * custom data scripts, automatic OS updates, and optional features like managed identity and boot diagnostics.
     *
     * @param scope - The scope in which to define this construct, typically representing the Cloud Development Kit (CDK) application.
     * @param id - The unique identifier for this instance of the Windows cluster, used within the scope for reference.
     * @param props - Configuration properties for the Windows VM Scale Set, derived from the WindowsClusterProps interface. These include:
     *                - `location`: The geographic location where the scale set will be hosted (e.g., "eastus").
     *                - `name`: The name of the scale set, which must be unique within the resource group.
     *                - `resourceGroup`: Optional. Reference to the resource group for deployment.
     *                - `sku`: The size specification of the VMs (e.g., "Standard_B2s").
     *                - `adminUsername`: The administrator username for the VMs.
     *                - `adminPassword`: The administrator password for the VMs.
     *                - `zones`: The availability zones for deploying the VMs.
     *                - `instances`: The number of VM instances in the scale set.
     *                - `sourceImageReference`: A reference to the specific Windows image to be used for the VMs.
     *                - `sourceImageId`: The identifier for a custom image to use for the VMs.
     *                - `tags`: Key-value pairs for resource tagging.
     *                - `osDisk`: Configuration for the VMs' operating system disks.
     *                - `subnet`: Specifies the subnet within which the VMs will be placed.
     *                - `publicIPAddress`: Method used to allocate public IP addresses to the VMs.
     *                - `customData`: Scripts or commands passed to the VMs at startup.
     *                - `upgradePolicyMode`: The upgrade policy mode for the VMSS.
     *                - `overprovision`: Specifies if the VMSS should be overprovisioned to maintain capacity during updates.
     *                - `scaleInPolicy`: The scale-in policy for the VMSS.
     *                - `bootDiagnosticsStorageURI`: URI for storage where VMSS boot diagnostics are collected.
     *                - `enableSshAzureADLogin`: Option to enable Azure AD login for SSH on the VMs.
     *
     * Example usage:
     * ```typescript
     * const windowsCluster = new WindowsCluster(this, 'MyWindowsCluster', {
     *   resourceGroup: myResourceGroup,
     *   name: 'myCluster',
     *   sku: 'Standard_DS1_v2',
     *   adminUsername: 'adminuser',
     *   adminPassword: 'securepassword123',
     *   sourceImageReference: { publisher: 'MicrosoftWindowsServer', offer: 'WindowsServer', sku: '2019-Datacenter', version: 'latest' },
     *   osDisk: { caching: 'ReadWrite', storageAccountType: 'Standard_LRS' },
     *   subnet: mySubnet,
     *   instances: 3,
     *   tags: { environment: 'production' }
     * });
     * ```
     * This class initializes a Windows VM Scale Set with the specified configurations, handling details like VM creation,
     * scaling policies, network setup, OS installation, and security settings, providing a robust and scalable infrastructure
     * for hosting cloud-based Windows applications.
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.resourceGroup = this.setupResourceGroup(props);
        const pathName = this.node.path.split("/")[0];
        // Default configurations for the virtual machine.
        const defaults = {
            name: props.name || this.node.path.split("/")[0],
            adminUsername: props.adminUsername || `admin${pathName}`,
            location: props.location || "eastus",
            sku: props.sku || "Standard_B2s",
            instances: props.instances || 1,
            osDisk: props.osDisk || {
                caching: "ReadWrite",
                storageAccountType: "Standard_LRS",
            },
            sourceImageReference: props.sourceImageReference ||
                azure_virtualmachine_1.WindowsImageReferences.windowsServer2022DatacenterCore,
            subnet: props.subnet ||
                new network_1.Network(this, "vnet", {
                    resourceGroup: this.resourceGroup,
                }).subnets.default,
        };
        // Base64 encode custom data if provided.
        const customData = props.customData || props.boostrapCustomData;
        const base64CustomData = customData
            ? Buffer.from(customData).toString("base64")
            : undefined;
        // Create the Windows Virtual Machine.
        const azurermWindowsVirtualMachine = new windows_virtual_machine_scale_set_1.WindowsVirtualMachineScaleSet(this, "vmss", {
            ...defaults,
            resourceGroupName: this.resourceGroup.name,
            adminUsername: props.adminUsername,
            adminPassword: props.adminPassword,
            tags: props.tags,
            lifecycle: props.lifecycle,
            networkInterface: [
                {
                    name: `nic-${defaults.name}`,
                    primary: true,
                    ipConfiguration: [
                        {
                            name: "internal",
                            subnetId: defaults.subnet.id,
                            primary: true,
                            publicIpAddress: props.publicIPAddress,
                        },
                    ],
                },
            ],
            osDisk: {
                ...defaults.osDisk,
            },
            sourceImageId: props.sourceImageId,
            customData: base64CustomData,
            bootDiagnostics: { storageAccountUri: props.bootDiagnosticsStorageURI },
        });
        this.id = azurermWindowsVirtualMachine.id;
        this.name = azurermWindowsVirtualMachine.name;
        // Bootstrap VM with custom script extension if bootstrap custom data is provided.
        if (props.boostrapCustomData) {
            new virtual_machine_scale_set_extension_1.VirtualMachineScaleSetExtensionA(this, "script-ext", {
                name: `${this.name}-script-ext`,
                virtualMachineScaleSetId: this.id,
                publisher: "Microsoft.Compute",
                type: "CustomScriptExtension",
                typeHandlerVersion: "1.10",
                protectedSettings: '{"commandToExecute": "rename  C:\\\\AzureData\\\\CustomData.bin  postdeploy.ps1 & powershell -ExecutionPolicy Unrestricted -File C:\\\\AzureData\\\\postdeploy.ps1"}',
            });
        }
    }
}
exports.WindowsCluster = WindowsCluster;
_b = JSII_RTTI_SYMBOL_1;
WindowsCluster[_b] = { fqn: "@microsoft/terraform-cdk-constructs.azure_virtualmachinescaleset.WindowsCluster", version: "0.0.3-pre.12" };
//# sourceMappingURL=data:application/json;base64,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