"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const provider_1 = require("@cdktf/provider-azurerm/lib/provider");
const cdktf_1 = require("cdktf");
const vmss = require("..");
const testing_1 = require("../../testing");
require("cdktf/lib/testing/adapters/jest");
describe("Azure Linux Virtual Machine Scale Set With Defaults", () => {
    let stack;
    let fullSynthResult;
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "testAzureVMSSWithDefaults");
        new provider_1.AzurermProvider(stack, "azureFeature", { features: {} });
        new vmss.LinuxCluster(stack, "testVirtualMachineScaleSet", {});
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    it("renders an Azure Linux Virtual Machine  Scale Set with defaults and checks snapshot", () => {
        expect(cdktf_1.Testing.synth(stack)).toMatchSnapshot(); // Compare the already prepared stack
    });
    it("check if the produced terraform configuration is valid", () => {
        expect(fullSynthResult).toBeValidTerraform(); // Use the saved result
    });
    it("check if this can be planned", () => {
        (0, testing_1.TerraformPlan)(fullSynthResult); // Use the saved result
    });
});
//# sourceMappingURL=data:application/json;base64,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