"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const provider_1 = require("@cdktf/provider-azurerm/lib/provider");
const cdktf_1 = require("cdktf");
const vmss = require("..");
const testing_1 = require("../../testing");
require("cdktf/lib/testing/adapters/jest");
describe("Azure Windows Virtual Machine Scale Set With Defaults", () => {
    let stack;
    let fullSynthResult;
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "testAzureVMSSWithDefaults");
        new provider_1.AzurermProvider(stack, "azureFeature", { features: {} });
        new vmss.WindowsCluster(stack, "testVirtualMachineScaleSet", {
            adminUsername: "testAdmin",
            adminPassword: "testPassword&@34$$123",
        });
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    it("renders an Azure Windows Virtual Machine  Scale Set with defaults and checks snapshot", () => {
        expect(cdktf_1.Testing.synth(stack)).toMatchSnapshot(); // Compare the already prepared stack
    });
    it("check if the produced terraform configuration is valid", () => {
        expect(fullSynthResult).toBeValidTerraform(); // Use the saved result
    });
    it("check if this can be planned", () => {
        (0, testing_1.TerraformPlan)(fullSynthResult); // Use the saved result
    });
});
//# sourceMappingURL=data:application/json;base64,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